<?php
require_once 'includes/db.php';

// --- PHP LOGIC AT THE TOP ---
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");

$user_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $active_tab = $_POST['tab_target'] ?? 'profile';

    // Update Profile Action
    if (isset($_POST['update_profile'])) {
        $name = sanitize_input($_POST['full_name']);
        $phone = sanitize_input($_POST['phone_number']);
        $stmt = $conn->prepare("UPDATE users SET full_name = ?, phone = ? WHERE id = ?");
        $stmt->bind_param("ssi", $name, $phone, $user_id);
        if ($stmt->execute()) {
            $_SESSION['user_name'] = $name;
            $_SESSION['flash_msg'] = "Profile updated!";
        }
    }

    // Save Address Action
    if (isset($_POST['save_address'])) {
        $addr_id = (int)$_POST['address_id'];
        $fname = sanitize_input($_POST['addr_name']);
        $phone = sanitize_input($_POST['addr_phone']);
        $l1 = sanitize_input($_POST['addr_line1']);
        $l2 = sanitize_input($_POST['addr_line2']);
        $city = sanitize_input($_POST['addr_city']);
        $state = sanitize_input($_POST['addr_state']);
        $pin = sanitize_input($_POST['addr_pincode']);

        if ($addr_id > 0) { // Update
            $stmt = $conn->prepare("UPDATE user_addresses SET full_name=?, phone=?, address_line_1=?, address_line_2=?, city=?, state=?, pincode=? WHERE id=? AND user_id=?");
            $stmt->bind_param("sssssssii", $fname, $phone, $l1, $l2, $city, $state, $pin, $addr_id, $user_id);
        } else { // Insert
            $stmt = $conn->prepare("INSERT INTO user_addresses (user_id, full_name, phone, address_line_1, address_line_2, city, state, pincode) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("isssssss", $user_id, $fname, $phone, $l1, $l2, $city, $state, $pin);
        }
        $stmt->execute();
        $_SESSION['flash_msg'] = "Address saved!";
    }

    // Change Password Action
    if (isset($_POST['change_pass'])) {
        $old = $_POST['old_pass'];
        $new = $_POST['new_pass'];
        $con = $_POST['confirm_pass'];
        $stmt = $conn->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $hash = $stmt->get_result()->fetch_assoc()['password'];
        if (!password_verify($old, $hash)) {
            $_SESSION['flash_error'] = "Incorrect current password.";
        } elseif ($new !== $con) {
            $_SESSION['flash_error'] = "New passwords do not match.";
        } else {
            $n_hash = password_hash($new, PASSWORD_BCRYPT);
            $upd = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            $upd->bind_param("si", $n_hash, $user_id);
            $upd->execute();
            $_SESSION['flash_msg'] = "Password changed!";
        }
    }

    header("Location: user-profile.php?active=$active_tab");
    exit;
}

if (isset($_GET['delete_addr'])) {
    $conn->query("DELETE FROM user_addresses WHERE id = " . (int)$_GET['delete_addr'] . " AND user_id = $user_id");
    $_SESSION['flash_msg'] = "Address deleted.";
    header("Location: user-profile.php?active=addresses");
    exit;
}

$user_data = $conn->query("SELECT * FROM users WHERE id = $user_id")->fetch_assoc();
$active_section = $_GET['active'] ?? 'profile';

include('includes/header.php');
?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>My Account</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>User Profile</li>
            </ul>
        </div>
    </div>
</div>

<section class="user-profile-area pt-100">
    <div class="container">
        <!-- FLASH MESSAGES -->
        <?php if (isset($_SESSION['flash_msg'])): ?>
            <div class="alert alert-success alert-dismissible fade show" id="autoHideAlert"><?= $_SESSION['flash_msg'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
            <?php unset($_SESSION['flash_msg']); ?>
        <?php endif; ?>
        <?php if (isset($_SESSION['flash_error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" id="autoHideAlertError"><?= $_SESSION['flash_error'] ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
            <?php unset($_SESSION['flash_error']); ?>
        <?php endif; ?>

        <!-- ================================================== -->
        <!-- ====== DYNAMIC MOBILE HORIZONTAL TAB NAVIGATION ===== -->
        <!-- ================================================== -->
        <div class="profile-nav-mobile">
            <!-- The main scrollable list of tabs -->
            <ul class="profile-nav-scrollable">
                <li><a href="#" class="profile-nav-link <?= $active_section == 'profile' ? 'active' : '' ?>" data-target="profile"><i class='bx bxs-user-circle'></i> My Profile</a></li>
                <li><a href="#" class="profile-nav-link <?= $active_section == 'orders' ? 'active' : '' ?>" data-target="orders"><i class='bx bxs-package'></i> My Orders</a></li>
                <li><a href="#" class="profile-nav-link <?= $active_section == 'addresses' ? 'active' : '' ?>" data-target="addresses"><i class='bx bxs-map'></i> Addresses</a></li>
                <li><a href="#" class="profile-nav-link <?= $active_section == 'cart' ? 'active' : '' ?>" data-target="cart"><i class='bx bxs-cart'></i> My Cart</a></li>
                <li><a href="#" class="profile-nav-link <?= $active_section == 'change-password' ? 'active' : '' ?>" data-target="change-password"><i class='bx bxs-lock-alt'></i> Password</a></li>
                <li><a href="#" class="profile-nav-link <?= $active_section == 'support' ? 'active' : '' ?>" data-target="support"><i class='bx bxs-help-circle'></i> Support</a></li>
                <li><a href="#" class="profile-nav-link" data-bs-toggle="modal" data-bs-target="#logoutConfirmModal"><i class='bx bxs-log-out-circle'></i> Logout</a></li>
            </ul>
        </div>

        <div class="row">
            <!-- SIDEBAR -->
            <div class="col-lg-3 col-md-4">
                <div class="profile-sidebar-wrapper">
                    <div class="profile-sidebar">
                        <div class="profile-user-info">
                            <h5 class="user-name"><?= htmlspecialchars($user_data['full_name']) ?></h5>
                            <span class="user-email"><?= htmlspecialchars($user_data['email']) ?></span>
                        </div>
                        <ul class="profile-nav">
                            <li><a href="#" class="profile-nav-link <?= $active_section == 'profile' ? 'active' : '' ?>" data-target="profile"><i class='bx bxs-user-circle'></i> My Profile</a></li>
                            <li><a href="#" class="profile-nav-link <?= $active_section == 'orders' ? 'active' : '' ?>" data-target="orders"><i class='bx bxs-package'></i> My Orders</a></li>
                            <li><a href="#" class="profile-nav-link <?= $active_section == 'addresses' ? 'active' : '' ?>" data-target="addresses"><i class='bx bxs-map'></i> Addresses</a></li>
                            <li><a href="#" class="profile-nav-link <?= $active_section == 'cart' ? 'active' : '' ?>" data-target="cart"><i class='bx bxs-cart'></i> My Cart</a></li>
                            <li><a href="#" class="profile-nav-link <?= $active_section == 'change-password' ? 'active' : '' ?>" data-target="change-password"><i class='bx bxs-lock-alt'></i> Password</a></li>
                            <li><a href="#" class="profile-nav-link <?= $active_section == 'support' ? 'active' : '' ?>" data-target="support"><i class='bx bxs-help-circle'></i> Support</a></li>
                            <li><a href="#" data-bs-toggle="modal" data-bs-target="#logoutConfirmModal"><i class='bx bxs-log-out-circle'></i> Logout</a></li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- MAIN CONTENT -->
            <div class="col-lg-9 col-md-8">
                <div class="profile-content">

                    <!-- Sections with inline style, as your main.js expects -->
                    <div id="profile" class="profile-content-section" style="<?= $active_section == 'profile' ? 'display:block;' : 'display:none;' ?>">
                        <h3>My Profile</h3>
                        <form method="POST">
                            <input type="hidden" name="tab_target" value="profile">
                            <div class="row">
                                <div class="col-lg-6 mb-3"><label>Full Name</label><input type="text" name="full_name" class="form-control" value="<?= htmlspecialchars($user_data['full_name']) ?>"></div>
                                <div class="col-lg-6 mb-3"><label>Email</label><input type="email" class="form-control" value="<?= htmlspecialchars($user_data['email']) ?>" readonly></div>
                                <div class="col-lg-6 mb-3"><label>Mobile</label><input type="text" name="phone_number" class="form-control" value="<?= htmlspecialchars($user_data['phone']) ?>"></div>
                                <div class="col-12 mt-3"><button type="submit" name="update_profile" class="default-btn">Update Profile</button></div>
                            </div>
                        </form>
                    </div>

                    <div id="orders" class="profile-content-section" style="<?= $active_section == 'orders' ? 'display:block;' : 'display:none;' ?>">
                        <h3>My Orders</h3>

                        <?php
                        $orders_res = $conn->query("SELECT * FROM orders WHERE user_id = $user_id ORDER BY created_at DESC");
                        if ($orders_res->num_rows > 0):
                        ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Order ID</th>
                                            <th>Date</th>
                                            <th>Total</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($order = $orders_res->fetch_assoc()): ?>
                                            <tr>
                                                <td><strong>#<?= str_pad($order['id'], 6, '0', STR_PAD_LEFT) ?></strong></td>
                                                <td><?= date('d M Y', strtotime($order['created_at'])) ?></td>
                                                <td>₹<?= number_format($order['total_amount'], 2) ?></td>
                                                <td><span class="badge bg-info text-white"><?= htmlspecialchars($order['order_status']) ?></span></td>
                                                <td><a href="order-details-view.php?id=<?= $order['id'] ?>" class="btn btn-sm btn-outline-primary">View</a></td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p>You have not placed any orders yet.</p>
                        <?php endif; ?>
                    </div>

                    <div id="addresses" class="profile-content-section" style="<?= $active_section == 'addresses' ? 'display:block;' : 'display:none;' ?>">
                        <div class="d-flex justify-content-between mb-4">
                            <h3>Address Book</h3><button class="default-btn" data-bs-toggle="modal" data-bs-target="#addressModal" onclick="prepareAddAddress()"><i class='bx bx-plus'></i> Add New</button>
                        </div>
                        <div class="row">
                            <?php $addr_res = $conn->query("SELECT * FROM user_addresses WHERE user_id = $user_id");
                            while ($addr = $addr_res->fetch_assoc()): ?>
                                <div class="col-md-6 mb-3">
                                    <div class="address-card default-address">
                                        <h5><?= htmlspecialchars($addr['full_name']) ?></h5>
                                        <p><?= htmlspecialchars($addr['phone']) ?></p>
                                        <p><?= htmlspecialchars($addr['address_line_1']) ?>, <?= $addr['city'] ?></p>
                                        <div class="address-actions"><a href="#" onclick='prepareEditAddress(<?= json_encode($addr) ?>)'>Edit</a> | <a href="user-profile.php?delete_addr=<?= $addr['id'] ?>" class="text-danger" onclick="return confirm('Delete?')">Delete</a></div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>

                    <div id="cart" class="profile-content-section" style="<?= $active_section == 'cart' ? 'display:block;' : 'display:none;' ?>">
                        <h3>My Cart</h3>

                        <?php if (empty($_SESSION['cart'])): ?>
                            <div class="text-center py-4">
                                <p>Your cart is currently empty.</p>
                                <a href="products.php" class="default-btn">Start Shopping</a>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-bordered align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Product</th>
                                            <th>Description</th>
                                            <th>Price</th>
                                            <th>Qty</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $subtotal = 0;
                                        foreach ($_SESSION['cart'] as $item):
                                            $line_total = $item['price'] * $item['quantity'];
                                            $subtotal += $line_total;
                                        ?>
                                            <tr>
                                                <td style="width: 80px;">
                                                    <a href="product-details.php?slug=<?= htmlspecialchars($item['slug']) ?>">
                                                        <img src="<?= htmlspecialchars($item['image']) ?>" alt="<?= htmlspecialchars($item['name']) ?>" style="width: 60px; height: auto; border-radius: 5px;">
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="product-details.php?slug=<?= htmlspecialchars($item['slug']) ?>" class="fw-bold text-dark text-decoration-none">
                                                        <?= htmlspecialchars($item['name']) ?>
                                                    </a>
                                                    <div class="small text-muted">
                                                        Color: <?= htmlspecialchars($item['color']) ?> <br>
                                                        Size: <?= htmlspecialchars($item['size']) ?>
                                                    </div>
                                                </td>
                                                <td>₹<?= number_format($item['price'], 2) ?></td>
                                                <td><?= $item['quantity'] ?></td>
                                                <td class="fw-bold">₹<?= number_format($line_total, 2) ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="row align-items-center mt-3">
                                <div class="col-md-6">
                                    <h5>Cart Subtotal: <span class="text-primary">₹<?= number_format($subtotal, 2) ?></span></h5>
                                </div>
                                <div class="col-md-6 text-md-end mt-3 mt-md-0">
                                    <a href="cart.php" class="optional-btn me-2">View & Edit Cart</a>
                                    <a href="checkout.php" class="default-btn">Proceed to Checkout</a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div id="change-password" class="profile-content-section" style="<?= $active_section == 'change-password' ? 'display:block;' : 'display:none;' ?>">
                        <h3>Change Password</h3>
                        <form method="POST">
                            <input type="hidden" name="tab_target" value="change-password">
                            <div class="row">
                                <div class="col-lg-12 mb-3"><label>Old Password</label>
                                    <div class="password-wrapper"><input type="password" name="old_pass" class="form-control"><i class='bx bx-hide toggle-password'></i></div>
                                </div>
                                <div class="col-lg-6 mb-3"><label>New Password</label>
                                    <div class="password-wrapper"><input type="password" name="new_pass" class="form-control"><i class='bx bx-hide toggle-password'></i></div>
                                </div>
                                <div class="col-lg-6 mb-3"><label>Confirm New</label>
                                    <div class="password-wrapper"><input type="password" name="confirm_pass" class="form-control"><i class='bx bx-hide toggle-password'></i></div>
                                </div>
                                <div class="col-12 mt-3"><button type="submit" name="change_pass" class="default-btn">Save</button></div>
                            </div>
                        </form>
                    </div>

                    <!-- 6. Support Section -->
                    <div id="support" class="profile-content-section" style="display:none;">
                        <h3>Help Center</h3>
                        <p>If you have any questions or need assistance, please don't hesitate to reach out.</p>
                        <a href="contact.php" class="default-btn">Contact Support</a>
                        <a href="faqs.php" class="optional-btn">View FAQs</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- MODALS -->
<div class="modal fade" id="addressModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" class="modal-content">
            <input type="hidden" name="tab_target" value="addresses">
            <input type="hidden" name="address_id" id="modal_addr_id" value="0">
            <div class="modal-header">
                <h5>Address Details</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3"><label>Full Name</label><input type="text" name="addr_name" id="modal_name" class="form-control" required></div>
                <div class="mb-3"><label>Phone</label><input type="text" name="addr_phone" id="modal_phone" class="form-control" required></div>
                <div class="mb-3"><label>House No. / Building / Street</label><input type="text" name="addr_line1" id="modal_l1" class="form-control" required></div>
                <div class="mb-3"><label>Area / Colony / Landmark</label><input type="text" name="addr_line2" id="modal_l2" class="form-control"></div>
                <div class="row">
                    <div class="col-6 mb-3"><label>City</label><input type="text" name="addr_city" id="modal_city" class="form-control" required></div>
                    <div class="col-6 mb-3"><label>Pincode</label><input type="text" name="addr_pincode" id="modal_pin" class="form-control" required></div>
                </div>
                <div class="mb-3"><label>State</label><input type="text" name="addr_state" id="modal_state" class="form-control" required></div>
            </div>
            <div class="modal-footer"><button type="submit" name="save_address" class="default-btn">Save</button></div>
        </form>
    </div>
</div>
<div class="modal fade" id="logoutConfirmModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5>Logout</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">Are you sure?</div>
            <div class="modal-footer"><button type="button" class="optional-btn" data-bs-dismiss="modal">Cancel</button><a href="logout.php" class="default-btn">Logout</a></div>
        </div>
    </div>
</div>

<script>
    // Address Helpers (MUST BE BEFORE main.js)
    function prepareAddAddress() {
        document.getElementById('modal_addr_id').value = 0;
        document.querySelector('#addressModal form').reset();
    }

    function prepareEditAddress(data) {
        document.getElementById('modal_addr_id').value = data.id;
        document.getElementById('modal_name').value = data.full_name;
        document.getElementById('modal_phone').value = data.phone;
        document.getElementById('modal_l1').value = data.address_line_1;
        document.getElementById('modal_l2').value = data.address_line_2;
        document.getElementById('modal_city').value = data.city;
        document.getElementById('modal_state').value = data.state;
        document.getElementById('modal_pin').value = data.pincode;

        // Use the native Bootstrap 5 function to show the modal
        new bootstrap.Modal(document.getElementById('addressModal')).show();
    }
</script>

<!-- Background Email Trigger -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Check if the trigger session exists (we pass this from PHP to JS)
    <?php if (isset($_SESSION['trigger_welcome_email']) && $_SESSION['trigger_welcome_email'] === true): ?>
        
        // Call the hidden email API
        fetch('api/send-welcome.php')
            .then(response => response.json())
            .then(data => {
                console.log('Background Email Processed');
            })
            .catch(error => console.error('Email error:', error));

    <?php endif; ?>
});
</script>

<?php include('includes/footer.php'); ?>

<?php include('includes/footer.php'); ?>