<?php include 'includes/header.php'; ?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Terms and Conditions</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Terms and Conditions</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Terms and Conditions Area -->
<section class="terms-conditions-area pt-70">
    <div class="container">
        <div class="policy-wrapper">

            <div class="policy-header mb-5">
                <h1>Terms & Conditions</h1>
                <p><strong>Last Updated:</strong> <span id="auto-date"></span></p>
            </div>

            <div class="policy-body">
                <section class="mb-5">
                    <h3>1. Agreement to Terms</h3>
                    <p>Welcome to Miss.Sogasu. These Terms and Conditions govern your access to and use of our website and services. By accessing our website or placing an order, you agree to comply with these Terms and all applicable laws. If you do not agree with these Terms, please do not use our website.</p>
                </section>

                <section class="mb-5">
                    <h3>2. Eligibility</h3>
                    <p>By using this website, you confirm that you are at least 18 years of age, or you are accessing the website under the direct supervision of a parent or legal guardian who agrees to be bound by these Terms.</p>
                </section>

                <section class="mb-5">
                    <h3>3. Products & Handcrafted Disclaimer</h3>
                    <ul>
                        <li>All products are subject to availability. We reserve the right to limit quantities or discontinue products without prior notice.</li>
                        <li><strong>Handcraft Disclaimer:</strong> Many of our products are handcrafted. Minor weaving irregularities or variations are not considered defects but are hallmarks of authentic artistry.</li>
                        <li><strong>Color Variation:</strong> Slight variations in color may occur due to professional studio lighting or differences in your device's screen settings.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>4. Pricing & Orders</h3>
                    <ul>
                        <li>All prices are listed in Indian Rupees (INR). Prices may change without prior notice.</li>
                        <li>We reserve the right to cancel any order in the event of technical errors or incorrect pricing.</li>
                        <li><strong>Order Acceptance:</strong> Order confirmation does not signify our acceptance of your order. We reserve the right to refuse service to anyone for any reason.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>5. Payment Policy</h3>
                    <p>Miss.Sogasu operates as a <strong>Prepaid-Only Store</strong>. We do not offer Cash on Delivery (COD). Orders are only processed and dispatched once full payment is confirmed through our secure payment gateway.</p>
                </section>

                <section class="mb-5">
                    <h3>6. Shipping & International Orders</h3>
                    <ul>
                        <li><strong>Domestic Shipping:</strong> We provide complimentary (Free) standard shipping on all orders delivered <strong>within India</strong>. Orders are typically dispatched within 1–2 business days.</li>

                        <li><strong>International Delivery:</strong> Free shipping is not applicable for orders outside of India. International customers are required to <strong>contact us directly via WhatsApp (+91 8128708120) or Email (misssogasu@gmail.com)</strong> for manual order processing and custom shipping quotations.</li>

                        <li><strong>Customs & Duties:</strong> For all international shipments, the customer is solely responsible for all customs duties, import taxes, and any additional administrative charges levied by the destination country.</li>

                        <li><strong>Liability:</strong> Miss.Sogasu is not responsible for any transit delays caused by courier partners or customs clearance procedures.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <div class="alert-box">
                        <h3>7. Exchange & Mandatory Unboxing Video</h3>
                        <p>We maintain a strict <strong>No Return & No Refund</strong> policy. All sales are final.</p>
                        <p><strong>Exchange Eligibility:</strong> Exchanges are only permitted if the product is received damaged or if the incorrect item was delivered.</p>
                        <p><strong>The 360° Unboxing Requirement:</strong> To claim an exchange, you must provide a continuous, unedited 360-degree unboxing video recorded in one single shot. The video must show the sealed parcel from all sides before opening. Failure to provide this video within 24 hours of delivery will result in the rejection of your claim.</p>
                    </div>
                </section>

                <section class="mb-5">
                    <h3>8. Order Cancellation</h3>
                    <p>Orders cannot be cancelled once they have been shipped. Cancellation requests must be submitted within 6 hours of placing the order.</p>
                </section>

                <section class="mb-5">
                    <h3>9. Governing Law</h3>
                    <p>These Terms shall be governed by the laws of India. Any disputes shall be subject to the exclusive jurisdiction of the courts in <strong>Hyderabad, Telangana, India</strong>.</p>
                </section>

                <section class="contact-card">
                    <h3>Contact Information</h3>
                    <p>Miss.Sogasu</p>
                    <p>Email: <a href="mailto:misssogasu@gmail.com">misssogasu@gmail.com</a></p>
                    <p>Phone / WhatsApp: +91 8128708120</p>
                    <p>Hyderabad, Telangana, India</p>
                </section>
            </div>
        </div>
    </div>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('auto-date').innerText = "01 January 2026";
    });
</script>

<?php include 'includes/footer.php'; ?>