<?php include 'includes/header.php'; ?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Shipping Policy</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Shipping Policy</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Shipping Policy Area -->
<section class="shipping-policy-area pt-70">
    <div class="container">
        <div class="policy-wrapper">

            <div class="policy-header mb-5">
                <h1>Shipping Policy</h1>
                <p><strong>Last Updated:</strong> <span id="auto-date"></span></p>
            </div>

            <div class="policy-body">
                <section class="mb-5">
                    <p>Welcome to <strong>Miss. Sogasu</strong>. We are dedicated to ensuring that your favorite sarees reach you safely and on time. Please review our shipping guidelines below.</p>
                </section>

                <section class="mb-5">
                    <h3>1. Order Processing & Dispatch</h3>
                    <ul>
                        <li>All orders are processed and dispatched within <strong>1–2 business days</strong> from the date of purchase.</li>
                        <li>Please note that we do not ship on weekends or public holidays.</li>
                        <li>During festive seasons, sale events, or periods of high volume, dispatch timelines may be slightly extended. We appreciate your patience during these times.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>2. Delivery Timelines & Charges</h3>
                    <div class="info-highlight mb-3">
                        <p><strong>Domestic Shipping (Within India):</strong></p>
                        <ul>
                            <li><strong>Free Shipping:</strong> We offer complimentary standard shipping on all orders delivered across India.</li>
                            <li><strong>Metro Cities:</strong> 3–5 business days.</li>
                            <li><strong>Other Locations:</strong> 5–7 business days.</li>
                        </ul>
                    </div>

                    <p><strong>International Orders:</strong> We offer global shipping; however, free shipping does not apply to international destinations. Shipping costs and delivery timelines vary based on the destination country.</p>
                    <p><em>Note: Delivery timelines are estimates and may vary due to external factors such as weather or logistics delays.</em></p>
                </section>

                <section class="mb-5">
                    <h3>3. Order Tracking</h3>
                    <p>Once your order has been handed over to our courier partner, you will receive a confirmation via email or SMS containing a unique tracking link. Please note that tracking details usually become active within <strong>24 hours</strong> of dispatch.</p>
                </section>

                <section class="mb-5">
                    <h3>4. International Shipping & Contact</h3>
                    <div class="alert-box">
                        <p><strong>How to place an International Order:</strong></p>
                        <p>Currently, international orders are processed manually. If you wish to have an order delivered outside of India, please <strong>contact us directly</strong> via WhatsApp or Email before placing your order. Our team will provide you with a custom shipping quote and estimated delivery timeline.</p>
                        <p class="mt-2">
                            <strong>WhatsApp:</strong> +91 8128708120 <br>
                            <strong>Email:</strong> misssogasu@gmail.com
                        </p>
                    </div>
                    <p class="mt-3">Please note that all customs duties, import taxes, or additional administrative charges imposed by the destination country are the <strong>sole responsibility of the customer</strong>.</p>
                </section>

                <section class="mb-5">
                    <h3>5. Address Accuracy & Delivery</h3>
                    <ul>
                        <li><strong>Incorrect Information:</strong> Customers are responsible for providing accurate and complete shipping details. We are not liable for delivery failures or issues arising from incorrect or incomplete addresses provided at checkout.</li>
                        <li><strong>Undeliverable Packages:</strong> If a package is returned to us due to failed delivery attempts or incorrect details, our team will contact you to arrange re-shipment. Additional shipping charges will apply for the second attempt.</li>
                        <li><strong>Delivery Confirmation:</strong> Once the courier partner marks an order as "Delivered" to the address provided, the order is considered successfully fulfilled, and our responsibility for the shipment ends.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>6. Shipping Delays & Liability</h3>
                    <p>Once an order is dispatched, customers are advised to monitor the shipment status directly with the courier partner using the provided tracking link. Miss. Sogasu is not responsible for delays caused by:</p>
                    <ul>
                        <li>Courier service internal delays.</li>
                        <li>Customs clearance procedures.</li>
                        <li>Natural events or "Act of God" circumstances.</li>
                        <li>Other circumstances beyond our reasonable control once the parcel is with the shipping partner.</li>
                    </ul>
                </section>

                <section class="contact-card">
                    <h3>Contact Us</h3>
                    <p>For any shipping-related questions or concerns, please reach out to us:</p>
                    <p>Miss.Sogasu</p>
                    <p>Email: <a href="mailto:misssogasu@gmail.com">misssogasu@gmail.com</a></p>
                    <p>Phone / WhatsApp: +91 8128708120</p>
                    <p>Hyderabad, Telangana, India</p>
                </section>
            </div>
        </div>
    </div>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('auto-date').innerText = "01 January 2026";
    });
</script>

<?php include 'includes/footer.php'; ?>