<?php include 'includes/header.php'; ?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Refund & Exchange Policy</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Refund & Exchange Policy</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Refund Policy Area -->
<section class="refund-policy-area pt-70">
    <div class="container">
        <div class="policy-wrapper">

            <div class="policy-header mb-5">
                <h1>Refund & Exchange Policy</h1>
                <p><strong>Effective Date:</strong> <span id="auto-date"></span></p>
            </div>

            <div class="policy-body">
                <section class="mb-5">
                    <p>At <strong>Miss.Sogasu</strong>, we maintain strict quality checks before dispatching every order to ensure you receive only the best. Please read this policy carefully before making a purchase.</p>
                </section>

                <section class="mb-5">
                    <h3>1. No Return & No Refund Policy</h3>
                    <ul>
                        <li><strong>All Sales are Final:</strong> We do not accept returns or offer monetary refunds once the product has been delivered.</li>
                        <li>We encourage you to review the product details, size guides, and images carefully before completing your purchase.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>2. Exchange Eligibility</h3>
                    <p>Exchanges are allowed <strong>only</strong> in the following specific cases:</p>
                    <ul>
                        <li>The product received is physically damaged during transit.</li>
                        <li>An incorrect product (wrong design, color, or size) was delivered.</li>
                    </ul>
                    <p><em>No other reasons (such as "disliking the color" or "change of mind") will be considered for exchange.</em></p>
                </section>

                <!-- CRITICAL: UNBOXING VIDEO REQUIREMENT -->
                <section class="mb-5">
                    <div class="alert-box">
                        <h3>3. Mandatory 360° Unboxing Requirement</h3>
                        <p>To claim an exchange for a damaged or incorrect item, the following conditions <strong>must</strong> be met:</p>
                        <ol>
                            <li><strong>Seal Check:</strong> A complete 360-degree video of the sealed parcel must be recorded before opening.</li>
                            <li><strong>All Sides:</strong> The parcel must be clearly shown from all sides in the video.</li>
                            <li><strong>Continuous Shot:</strong> The unboxing must be recorded in one single, continuous shot. <strong>The video must not be paused, edited, cut, or altered in any way.</strong></li>
                            <li><strong>Visibility:</strong> The product must be clearly visible in the same video after opening.</li>
                            <li><strong>Deadline:</strong> The video must be shared with our team via Email or WhatsApp within <strong>24 hours</strong> of delivery.</li>
                        </ol>
                        <p><strong>Note:</strong> Failure to provide a proper continuous unboxing video within 24 hours will result in the automatic rejection of the exchange request.</p>
                    </div>
                </section>

                <section class="mb-5">
                    <h3>4. Refunds in Eligible Cases</h3>
                    <p>If an exchange is not possible due to stock unavailability for a legitimate damaged/incorrect claim, a refund may be processed:</p>
                    <ul>
                        <li>Refunds will be processed to the original payment method.</li>
                        <li><strong>Processing Fees:</strong> Payment gateway processing fees (including Razorpay charges) are non-refundable, as these are charged directly by the provider.</li>
                        <li><strong>Timeline:</strong> Refund processing takes 7–10 business days after approval.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>5. International Orders</h3>
                    <ul>
                        <li><strong>Manual Processing:</strong> As international orders are processed manually via direct contact, all quoted shipping charges are <strong>non-refundable</strong> once the order has been dispatched.</li>

                        <li><strong>Customs & Duties:</strong> All customs duties, import taxes, and local destination charges are the sole responsibility of the customer.</li>

                        <li><strong>Refused Shipments:</strong> If an international shipment is refused by the customer due to unpaid customs charges or any other reason, any applicable refund will be processed <strong>only</strong> after the parcel is received back by us in original condition. </li>

                        <li><strong>Deductions:</strong> In such cases, the refund will be issued after deducting the original shipping cost, the return shipping cost, and any customs penalties or administrative fees incurred by Miss.Sogasu.</li>
                    </ul>
                </section>

                <section class="contact-card">
                    <h3>Contact Us</h3>
                    <p>Miss.Sogasu</p>
                    <p>Email: <a href="mailto:misssogasu@gmail.com">misssogasu@gmail.com</a></p>
                    <p>Phone / WhatsApp: +91 8128708120</p>
                    <p>Hyderabad, Telangana, India</p>
                </section>
            </div>
        </div>
    </div>
</section>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('auto-date').innerText = "01 January 2026";
    });
</script>

<?php include 'includes/footer.php'; ?>