<?php
include 'includes/header.php';

// --- 1. CAPTURE FILTER PARAMETERS ---
$category_slug = isset($_GET['category']) ? sanitize_input($_GET['category']) : '';
$search_query = isset($_GET['search']) ? sanitize_input($_GET['search']) : '';
// --- ADD THIS LINE ---
$special_filter = isset($_GET['filter']) ? sanitize_input($_GET['filter']) : '';
// ---------------------


// --- BRIDGE: Map Sidebar/Slider Categories to Special Logic ---
if ($category_slug === 'new-arrivals') {
    $special_filter = 'new-arrivals';
    $category_slug = ''; // Clear this so it doesn't look for a physical category ID
} elseif ($category_slug === 'best-sellers') {
    $special_filter = 'best-sellers';
    $category_slug = '';
} elseif ($category_slug === 'on-sale') { // <--- ADD THIS BLOCK
    $special_filter = 'sale';
    $category_slug = '';
}
// -------------------------------------------------------

$sort_by = isset($_GET['sort_by']) ? sanitize_input($_GET['sort_by']) : 'default';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$size_filter = isset($_GET['size']) ? sanitize_input($_GET['size']) : '';

// Handle Price Filter
if (isset($_GET['filter_by_price']) && !empty($_GET['filter_by_price'])) {
    $price_parts = explode(';', $_GET['filter_by_price']);
    $price_min = isset($price_parts[0]) ? (int)$price_parts[0] : 0;
    $price_max = isset($price_parts[1]) ? (int)$price_parts[1] : 50000;
} else {
    $price_min = 0;
    $price_max = 50000;
}

// Pagination Config
$per_page = 9;
$offset = ($page - 1) * $per_page;

// --- 2. BUILD SQL CONDITIONS ---
$where_clauses = ["p.is_active = 1"];

// Category Filter
if (!empty($category_slug)) {
    $where_clauses[] = "c.slug = '$category_slug'";
}

// --- ADD THIS BLOCK ---
// Special Filters
if ($special_filter === 'sale') {
    $where_clauses[] = "p.sale_price > 0 AND p.sale_price < p.price";
} elseif ($special_filter === 'new-arrivals') {
    // Logic: Show all items from last 7 days OR the absolute 6 newest items in the DB
    $where_clauses[] = "(
        p.created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)
        OR 
        p.id IN (SELECT id FROM (SELECT id FROM products WHERE is_active = 1 ORDER BY id DESC LIMIT 6) as temp)
    )";
} elseif ($special_filter === 'best-sellers') {
    // Show products that have at least 1 sale
    $where_clauses[] = "p.id IN (SELECT product_id FROM order_items)";
}
// ----------------------

// Search Filter
if (!empty($search_query)) {
    $where_clauses[] = "(
        p.name LIKE '%$search_query%' OR 
        p.description LIKE '%$search_query%' OR 
        p.sku LIKE '%$search_query%' OR
        -- NEW: Check if the product has a variant in this color
        p.id IN (SELECT product_id FROM product_sizes WHERE color_group LIKE '%$search_query%')
    )";
}
// Price Filter
if ($price_min > 0 || $price_max < 50000) {
    $where_clauses[] = "(COALESCE(NULLIF(p.sale_price, 0), p.price) BETWEEN $price_min AND $price_max)";
}

// Size Filter
if (!empty($size_filter)) {
    $where_clauses[] = "p.id IN (SELECT product_id FROM product_sizes WHERE size = '$size_filter' AND stock_quantity > 0)";
}

$where_sql = implode(' AND ', $where_clauses);


// --- 3. COUNT QUERY (Pagination) ---
$count_sql = "SELECT COUNT(*) as total 
              FROM products p 
              LEFT JOIN categories c ON p.category_id = c.id 
              WHERE $where_sql";

$count_res = $conn->query($count_sql);
$total_products = ($count_res && $count_res->num_rows > 0) ? $count_res->fetch_assoc()['total'] : 0;
$total_pages = ceil($total_products / $per_page);


// --- 4. MAIN QUERY (Fetch Data) ---

// 1. Define the Order By Clause
$order_sql = "";

switch ($sort_by) {
    case 'price_asc':
        $order_sql = "ORDER BY COALESCE(NULLIF(p.sale_price, 0), p.price) ASC";
        break;
    case 'price_desc':
        $order_sql = "ORDER BY COALESCE(NULLIF(p.sale_price, 0), p.price) DESC";
        break;
    case 'oldest':
        $order_sql = "ORDER BY p.id ASC"; // Oldest First
        break;
    case 'latest': // "Default" is now Latest
    case 'default':
    default:
        $order_sql = "ORDER BY p.id DESC"; // Newest First
        break;
}

// 2. Construct the Main Query using $order_sql
// We fetch the Main Image (Primary=1) AND Hover Image (Primary=0) for DEFAULT COLOR ONLY
$sql = "SELECT p.*, 
        (SELECT image_path FROM product_images pi 
         WHERE pi.product_id = p.id 
         AND pi.is_primary = 1 
         AND (pi.color_group = p.default_color_group OR pi.color_group IS NULL OR p.default_color_group IS NULL)
         LIMIT 1) as main_image,
        (SELECT image_path FROM product_images pi 
         WHERE pi.product_id = p.id 
         AND pi.is_primary = 0 
         AND (pi.color_group = p.default_color_group OR pi.color_group IS NULL OR p.default_color_group IS NULL)
         LIMIT 1) as hover_image
        FROM products p 
        LEFT JOIN categories c ON p.category_id = c.id 
        WHERE $where_sql 
        $order_sql 
        LIMIT $offset, $per_page";

$products = $conn->query($sql);

// --- 5. HEADER ---
$page_header = "Shop All Products";
// --- UPDATE THIS BLOCK ---
if ($special_filter === 'sale') {
    $page_header = "Flash Sale - Limited Time Offers";
} elseif ($special_filter === 'new-arrivals') {
    $page_header = "Just In: New Arrivals";
} elseif (!empty($category_slug)) {
    // -------------------------
    $cat_res = $conn->query("SELECT name FROM categories WHERE slug = '$category_slug'");
    if ($cat_res->num_rows > 0) $page_header = $cat_res->fetch_assoc()['name'];
} elseif (!empty($search_query)) {
    $page_header = "Search Results for: " . htmlspecialchars($search_query);
}
?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2><?= $page_header ?></h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Shop</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Products Area -->
<section class="products-area products-collections-area pt-100 pb-70">
    <div class="container-fluid">
        <div class="row justify-content-center">

            <!-- SIDEBAR FILTER -->
            <div class="col-lg-4 col-md-12">
                <div class="woocommerce-widget-area">

                    <!-- Current Selection -->
                    <?php if (!empty($category_slug) || !empty($size_filter) || (!empty($_GET['filter_by_price']))): ?>
                        <div class="woocommerce-widget filter-list-widget">
                            <h3 class="woocommerce-widget-title">Current Selection</h3>
                            <div class="selected-filters-wrap-list">
                                <ul>
                                    <?php if (!empty($category_slug)):
                                        $cat_name_display = $conn->query("SELECT name FROM categories WHERE slug='$category_slug'")->fetch_assoc()['name'] ?? 'Category';
                                        $params = $_GET;
                                        unset($params['category']);
                                        unset($params['page']);
                                    ?>
                                        <li><a href="products.php?<?= http_build_query($params) ?>"><i class='bx bx-x'></i> <?= htmlspecialchars($cat_name_display) ?></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($size_filter)):
                                        $params = $_GET;
                                        unset($params['size']);
                                        unset($params['page']);
                                    ?>
                                        <li><a href="products.php?<?= http_build_query($params) ?>"><i class='bx bx-x'></i> Size: <?= htmlspecialchars($size_filter) ?></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($_GET['filter_by_price'])):
                                        $params = $_GET;
                                        unset($params['filter_by_price']);
                                        unset($params['page']);
                                    ?>
                                        <li><a href="products.php?<?= http_build_query($params) ?>"><i class='bx bx-x'></i> Price: <?= $price_min ?> - <?= $price_max ?></a></li>
                                    <?php endif; ?>
                                </ul>
                                <a href="products.php" class="delete-selected-filters"><i class='bx bx-trash'></i> <span>Clear All</span></a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Categories -->
                    <div class="woocommerce-widget collections-list-widget">
                        <h3 class="woocommerce-widget-title">Categories</h3>
                        <ul class="collections-list-row">
                            <!-- Update All Products Active check -->
                            <li class="<?= (empty($category_slug) && empty($special_filter)) ? 'active' : '' ?>">
                                <a href="products.php">All Products</a>
                            </li>

                            <?php
                            $cats = $conn->query("SELECT name, slug FROM categories WHERE slug NOT IN ('new-arrivals', 'best-sellers', 'on-sale') ORDER BY name ASC");
                            while ($c = $cats->fetch_assoc()):
                                // Check if THIS item should be active
                                $is_active = ($category_slug == $c['slug']) || ($special_filter == $c['slug']);
                            ?>
                                <li class="<?= $is_active ? 'active' : '' ?>">
                                    <a href="products.php?category=<?= $c['slug'] ?>"><?= htmlspecialchars($c['name']) ?></a>
                                </li>
                            <?php endwhile; ?>
                        </ul>
                    </div>

                    <!-- Price Filter -->
                    <div class="woocommerce-widget price-list-widget">
                        <h3 class="woocommerce-widget-title">Price</h3>
                        <div class="collection-filter-by-price">
                            <form action="products.php" method="GET" id="priceFilterForm">
                                <?php if ($category_slug) echo '<input type="hidden" name="category" value="' . $category_slug . '">'; ?>
                                <?php if ($size_filter) echo '<input type="hidden" name="size" value="' . $size_filter . '">'; ?>
                                <?php if ($search_query) echo '<input type="hidden" name="search" value="' . $search_query . '">'; ?>
                                <?php if ($sort_by != 'default') echo '<input type="hidden" name="sort_by" value="' . $sort_by . '">'; ?>

                                <!-- Added data-prefix="₹" to show Rupee symbol in JS sliders -->
                                <input class="js-range-of-price" type="text"
                                    data-min="0"
                                    data-max="10000"
                                    name="filter_by_price"
                                    data-step="100"
                                    value="<?= $price_min ?>;<?= $price_max ?>">

                                <button type="submit" class="default-btn btn-sm mt-3 w-100">Filter Price</button>
                            </form>
                        </div>
                    </div>

                    <!-- Size Widget (Hardcoded) -->
                    <!-- <div class="woocommerce-widget size-list-widget">
                        <h3 class="woocommerce-widget-title">Size</h3>
                        <ul class="size-list-row">
                            <?php
                        
                            $hardcoded_sizes = ['XS', 'S', 'M', 'L', 'XL', 'XXL'];

                            foreach ($hardcoded_sizes as $s_name):
                                $link_params = array_merge($_GET, ['size' => $s_name]);
                                $link_params['page'] = 1;
                                $link = "products.php?" . http_build_query($link_params);
                            ?>
                                <li class="<?= ($size_filter == $s_name) ? 'active' : '' ?>">
                                    <a href="<?= $link ?>"><?= htmlspecialchars($s_name) ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div> -->

                    <!-- Sidebar Banner -->
                    <div class="woocommerce-widget aside-trending-widget">
                        <div class="aside-trending-products">
                            <img src="assets/img/offer-bg2.jpg" alt="Special Offer Banner">
                            <div class="category">
                                <h3>Sale Collection</h3>
                                <span>Get Maximum Discount</span>
                            </div>
                            <a href="products.php?filter=sale" class="link-btn"></a>
                        </div>
                    </div>

                </div>
            </div>

            <!-- PRODUCTS GRID -->
            <div class="col-lg-8 col-md-12">

                <!-- Filter Bar -->
                <div class="products-filter-options">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-lg-4 col-md-4">
                            <div class="d-lg-flex d-md-flex align-items-center">
                                <span class="sub-title d-lg-none"><a href="#" data-bs-toggle="modal" data-bs-target="#productsFilterModal"><i class='bx bx-filter-alt'></i> Filter</a></span>
                                <span class="sub-title d-none d-lg-block d-md-block">View:</span>
                                <div class="view-list-row d-none d-lg-block d-md-block">
                                    <div class="view-column">
                                        <a href="#" class="icon-view-two"><span></span><span></span></a>
                                        <a href="#" class="icon-view-three active"><span></span><span></span><span></span></a>
                                        <a href="#" class="icon-view-four"><span></span><span></span><span></span><span></span></a>
                                        <a href="#" class="view-grid-switch"><span></span><span></span></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-4 text-center">
                            <p>Showing <?= $products && $products->num_rows > 0 ? ($offset + 1) : 0 ?> – <?= $products ? min($offset + $per_page, $total_products) : 0 ?> of <?= $total_products ?></p>
                        </div>

                        <div class="col-lg-4 col-md-4 text-right">
                            <form method="GET" id="sortingForm">
                                <!-- Preserve other filters -->
                                <?php foreach ($_GET as $key => $val) {
                                    if ($key != 'sort_by' && $key != 'page') echo '<input type="hidden" name="' . $key . '" value="' . $val . '">';
                                } ?>

                                <select name="sort_by" class="form-control" onchange="this.form.submit()">
                                    <option value="latest" <?= ($sort_by == 'latest' || $sort_by == 'default') ? 'selected' : '' ?>>Sort by Latest</option>
                                    <option value="oldest" <?= $sort_by == 'oldest' ? 'selected' : '' ?>>Sort by Oldest</option>
                                    <option value="price_asc" <?= $sort_by == 'price_asc' ? 'selected' : '' ?>>Price: Low to High</option>
                                    <option value="price_desc" <?= $sort_by == 'price_desc' ? 'selected' : '' ?>>Price: High to Low</option>
                                </select>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Products Loop -->
                <div id="products-collections-filter" class="row">
                    <?php if ($products && $products->num_rows > 0): ?>
                        <?php while ($prod = $products->fetch_assoc()):
                            // MAIN IMAGE
                            $img_src = !empty($prod['main_image']) ? $prod['main_image'] : 'assets/img/placeholder.png';

                            // HOVER IMAGE (If not found, fallback to main image)
                            $hover_src = !empty($prod['hover_image']) ? $prod['hover_image'] : $img_src;

                            $price = $prod['price'];
                            $sale = $prod['sale_price'];
                            $has_sale = ($sale > 0 && $sale < $price);
                        ?>
                            <div class="col-lg-4 col-md-6 col-sm-6 col-6 products-col-item">
                                <div class="single-products-box">
                                    <div class="products-image">
                                        <a href="product-details.php?slug=<?= $prod['slug'] ?>">
                                            <img src="<?= $img_src ?>" class="main-image" alt="<?= htmlspecialchars($prod['name']) ?>">
                                            <img src="<?= $hover_src ?>" class="hover-image" alt="<?= htmlspecialchars($prod['name']) ?>">
                                        </a>
                                        <div class="products-button">
                                            <ul>
                                                <li>
                                                    <div class="quick-view-btn"><a href="#" data-bs-toggle="modal" data-bs-target="#productsQuickView" onclick="loadQuickView(<?= $prod['id'] ?>)"><i class='bx bx-search-alt'></i><span class="tooltip-label">Quick View</span></a></div>
                                                </li>
                                            </ul>
                                        </div>
                                        <?php
                                        // Check if product is new (added in last 24 hours)
                                        $is_new = false;
                                        if (!empty($prod['created_at'])) {
                                            $created_time = strtotime($prod['created_at']);
                                            $current_time = time();
                                            $hours_diff = ($current_time - $created_time) / 3600; // Convert to hours
                                            $is_new = ($hours_diff <= 24);
                                        }

                                        // Determine CSS class based on which tags exist
                                        $sale_tag_class = $has_sale ? 'sale-tag' : '';
                                        if ($has_sale && $is_new) {
                                            $sale_tag_class = 'sale-tag sale-with-new'; // Special class when both exist
                                        }

                                        // Display tags
                                        if ($has_sale): ?>
                                            <div class="<?= $sale_tag_class ?>">Sale!</div>
                                        <?php endif; ?>
                                        <?php if ($is_new): ?>
                                            <div class="new-tag">New!</div>
                                        <?php endif; ?>
                                        <a href="product-details.php?slug=<?= $prod['slug'] ?>" class="add-to-cart">View Details</a>
                                    </div>
                                    <div class="products-content">
                                        <h3><a href="product-details.php?slug=<?= $prod['slug'] ?>"><?= htmlspecialchars($prod['name']) ?></a></h3>
                                        <div class="price">
                                            <?php if ($has_sale): ?>
                                                <span class="old-price">₹<?= number_format($price, 2) ?></span>
                                                <span class="new-price">₹<?= number_format($sale, 2) ?></span>
                                            <?php else: ?>
                                                <span class="new-price">₹<?= number_format($price, 2) ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <div class="col-12 text-center py-5">
                            <h3>No products found.</h3>
                            <p>Try clearing filters or searching for something else.</p>
                            <a href="products.php" class="default-btn">Clear All Filters</a>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Pagination -->
                <?php if ($total_pages > 1): ?>
                    <div class="pagination-area text-center">
                        <?php
                        $params = $_GET;
                        unset($params['page']);
                        $base_url = "products.php?" . http_build_query($params) . "&page=";

                        if ($page > 1) echo '<a href="' . $base_url . ($page - 1) . '" class="prev page-numbers"><i class="bx bx-chevron-left"></i></a>';

                        for ($i = 1; $i <= $total_pages; $i++) {
                            if ($i == $page) {
                                echo '<span class="page-numbers current" aria-current="page">' . $i . '</span>';
                            } else {
                                echo '<a href="' . $base_url . $i . '" class="page-numbers">' . $i . '</a>';
                            }
                        }

                        if ($page < $total_pages) echo '<a href="' . $base_url . ($page + 1) . '" class="next page-numbers"><i class="bx bx-chevron-right"></i></a>';
                        ?>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</section>
<!-- End Products Area -->

<!-- Start Facility Area -->
<section class="facility-area pb-70">
    <div class="container">
        <div class="facility-slides owl-carousel owl-theme">
            <div class="single-facility-box">
                <div class="icon"><i class='flaticon-tracking'></i></div>
                <h3>Free Express Shipping</h3>
            </div>
            <div class="single-facility-box">
                <div class="icon"><i class='flaticon-return'></i></div>
                <h3>Hassle-Free Returns</h3>
            </div>
            <div class="single-facility-box">
                <div class="icon"><i class='flaticon-shuffle'></i></div>
                <h3>Easy Exchanges</h3>
            </div>
            <div class="single-facility-box">
                <div class="icon"><i class='flaticon-credit-card'></i></div>
                <h3>100% Secure Checkout</h3>
            </div>
            <div class="single-facility-box">
                <div class="icon"><i class='flaticon-location'></i></div>
                <h3>Order Tracking</h3>
            </div>
            <div class="single-facility-box">
                <div class="icon"><i class='flaticon-customer-service'></i></div>
                <h3>Dedicated Support</h3>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>