<?php
include 'includes/db.php';

// --- 1. GET PRODUCT SLUG FROM URL ---
$slug = isset($_GET['slug']) ? sanitize_input($_GET['slug']) : '';

if (empty($slug)) {
    header("Location: products.php");
    exit;
}

// --- 2. FETCH PRODUCT DETAILS ---
$product_sql = "SELECT p.*, c.name as category_name, c.slug as category_slug 
                FROM products p 
                LEFT JOIN categories c ON p.category_id = c.id 
                WHERE p.slug = '$slug' AND p.is_active = 1 LIMIT 1";

$product_result = $conn->query($product_sql);

if (!$product_result || $product_result->num_rows == 0) {
    header("Location: products.php");
    exit;
}

$product = $product_result->fetch_assoc();
$product_id = $product['id'];

// --- 3. FETCH PRODUCT IMAGES GROUPED BY COLOR ---
$images_sql = "SELECT * FROM product_images WHERE product_id = $product_id ORDER BY color_group, is_primary DESC";
$images_result = $conn->query($images_sql);

$images_by_color = [];
$available_colors = [];
$primary_images = [];

while ($img = $images_result->fetch_assoc()) {
    $color_group = $img['color_group'] ?: 'Standard';

    if (!isset($images_by_color[$color_group])) {
        $images_by_color[$color_group] = [];
        $available_colors[] = $color_group;
    }

    $images_by_color[$color_group][] = $img;

    // Store primary image for each color
    if ($img['is_primary'] == 1) {
        $primary_images[$color_group] = $img['image_path'];
    }
}

// If no primary images found, use first image of each color
foreach ($images_by_color as $color => $images) {
    if (!isset($primary_images[$color]) && count($images) > 0) {
        $primary_images[$color] = $images[0]['image_path'];
    }
}

// Validate that each color has exactly one primary image
foreach ($images_by_color as $color => $images) {
    $primary_count = 0;
    foreach ($images as $img) {
        if ($img['is_primary'] == 1) {
            $primary_count++;
        }
    }

    // If no primary found, set first image as primary
    if ($primary_count == 0 && count($images) > 0) {
        $first_img_id = $images[0]['id'];
        $conn->query("UPDATE product_images SET is_primary = 1 WHERE id = $first_img_id");
        $images_by_color[$color][0]['is_primary'] = 1;
    }
    // If multiple primaries found, keep only the first one
    elseif ($primary_count > 1) {
        $first_primary_set = false;
        foreach ($images as &$img) {
            if ($img['is_primary'] == 1) {
                if (!$first_primary_set) {
                    $first_primary_set = true;
                } else {
                    $img['is_primary'] = 0;
                    $img_id = $img['id'];
                    $conn->query("UPDATE product_images SET is_primary = 0 WHERE id = $img_id");
                }
            }
        }
    }
}

// Set default color
$default_color = $product['default_color_group'] ?: (count($available_colors) > 0 ? $available_colors[0] : 'Standard');
$current_color = isset($_GET['color']) ? sanitize_input($_GET['color']) : $default_color;

// Validate current color exists
if (!in_array($current_color, $available_colors)) {
    $current_color = $default_color;
}
// Ensure images_by_color has an entry for current color
if (!isset($images_by_color[$current_color])) {
    $images_by_color[$current_color] = [];
}

// --- 4. FETCH SIZES FOR CURRENT COLOR ---
$sizes_sql = "SELECT size, stock_quantity FROM product_sizes 
              WHERE product_id = $product_id AND color_group = '$current_color' 
              ORDER BY FIELD(size, 'XS', 'S', 'M', 'L', 'XL', 'XXL')";
$sizes_result = $conn->query($sizes_sql);

$available_sizes = [];
$size_stock = [];
$total_stock = 0;

while ($size = $sizes_result->fetch_assoc()) {
    $available_sizes[] = $size['size'];
    $size_stock[$size['size']] = $size['stock_quantity'];
    $total_stock += $size['stock_quantity'];
}

// Set default size
$current_size = '';
if (count($available_sizes) > 0) {
    $current_size = isset($_GET['size']) ? sanitize_input($_GET['size']) : $available_sizes[0];
    if (!in_array($current_size, $available_sizes)) {
        $current_size = $available_sizes[0];
    }
}

// --- 5. CHECK AVAILABILITY FOR SELECTED COLOR & SIZE ---
$selected_stock = isset($size_stock[$current_size]) ? $size_stock[$current_size] : 0;
$is_available = $selected_stock > 0;

// --- 6. FETCH RELATED PRODUCTS ---
$related_sql = "SELECT p.*, 
                (SELECT image_path FROM product_images pi 
                 WHERE pi.product_id = p.id 
                 AND pi.is_primary = 1 
                 AND (pi.color_group = p.default_color_group OR p.default_color_group IS NULL OR pi.color_group IS NULL)
                 LIMIT 1) as main_image,
                (SELECT image_path FROM product_images pi 
                 WHERE pi.product_id = p.id 
                 AND pi.is_primary = 0 
                 AND (pi.color_group = p.default_color_group OR p.default_color_group IS NULL OR pi.color_group IS NULL)
                 LIMIT 1) as hover_image
                FROM products p 
                WHERE p.category_id = {$product['category_id']} 
                AND p.id != $product_id 
                AND p.is_active = 1 
                ORDER BY p.created_at DESC LIMIT 5";

$related_result = $conn->query($related_sql);
$related_products = [];
if ($related_result) {
    while ($row = $related_result->fetch_assoc()) {
        $related_products[] = $row;
    }
}

// --- 7. PARSE ADDITIONAL INFO ---
$additional_info = [];
if (!empty($product['additional_info'])) {
    $additional_info = json_decode($product['additional_info'], true);
}
?>

<?php include 'includes/header.php'; ?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2><?php echo htmlspecialchars($product['name']); ?></h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li><a href="products.php">Shop</a></li>
                <?php if (!empty($product['category_slug'])): ?>
                    <li><a href="products.php?category=<?php echo $product['category_slug']; ?>"><?php echo htmlspecialchars($product['category_name']); ?></a></li>
                <?php endif; ?>
                <li><?php echo htmlspecialchars($product['name']); ?></li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Product Details Area -->
<section class="product-details-area pt-100">
    <div class="container">
        <div class="row justify-content-center">
            <!-- ================================================== -->
            <!-- ====== DYNAMIC PRODUCT IMAGE GALLERY ============== -->
            <!-- ================================================== -->
            <div class="col-lg-5 col-md-12">
                <!-- Main Image Slider -->
                <div class="product-details-main-slider-sync owl-carousel owl-theme" id="mainImageSlider">
                    <?php if (isset($images_by_color[$current_color])): ?>
                        <?php foreach ($images_by_color[$current_color] as $index => $image): ?>
                            <div class="item">
                                <a href="<?php echo $image['image_path']; ?>" class="image-popup-zoom">
                                    <img src="<?php echo $image['image_path']; ?>"
                                        alt="<?php echo htmlspecialchars($product['name'] . ' - ' . $current_color . ' - Image ' . ($index + 1)); ?>"
                                        data-color="<?php echo $current_color; ?>">
                                </a>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="item">
                            <a href="assets/img/placeholder.png" class="image-popup-zoom">
                                <img src="assets/img/placeholder.png" alt="Image not available">
                            </a>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Thumbnail Navigation Slider -->
                <div class="product-details-nav-slider-sync owl-carousel owl-theme" id="thumbnailSlider">
                    <?php if (isset($images_by_color[$current_color])): ?>
                        <?php foreach ($images_by_color[$current_color] as $index => $image): ?>
                            <div class="item">
                                <img src="<?php echo $image['image_path']; ?>"
                                    alt="Thumbnail <?php echo $index + 1; ?>"
                                    data-index="<?php echo $index; ?>">
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="item">
                            <img src="assets/img/placeholder.png" alt="Thumbnail">
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- ================================================== -->
            <!-- ====== DYNAMIC PRODUCT DETAILS =================== -->
            <!-- ================================================== -->
            <div class="col-lg-7 col-md-12">
                <div class="products-details-desc">
                    <h3><?php echo htmlspecialchars($product['name']); ?></h3>

                    <!-- Dynamic Pricing -->
                    <div class="price">
                        <?php
                        $price = $product['price'];
                        $sale_price = $product['sale_price'];
                        $has_discount = ($sale_price > 0 && $sale_price < $price);

                        // Calculate discount percentage
                        $discount_percent = 0;
                        if ($has_discount) {
                            $discount_percent = round((($price - $sale_price) / $price) * 100);
                        }
                        ?>

                        <?php if ($has_discount): ?>
                            <div class="price-with-discount">
                                <span class="sale-price">₹<?php echo number_format($sale_price, 2); ?></span>
                                <span class="original-price">₹<?php echo number_format($price, 2); ?></span>
                                <?php if ($discount_percent > 0): ?>
                                    <span class="discount-badge">Save <?php echo $discount_percent; ?>%</span>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="regular-price">
                                <span class="current-price highlight-price">₹<?php echo number_format($price, 2); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Short Description -->
                    <?php if (!empty($product['short_description'])): ?>
                        <p class="short-description"><?php echo htmlspecialchars($product['short_description']); ?></p>
                    <?php endif; ?>

                    <!-- Product Meta Info -->
                    <ul class="products-info">
                        <?php if (!empty($product['sku'])): ?>
                            <li><span>SKU:</span> <a href="#"><?php echo htmlspecialchars($product['sku']); ?></a></li>
                        <?php endif; ?>

                        <li>
                            <span>Availability:</span>
                            <span id="availabilityText" class="availability-status <?php echo $is_available ? 'in-stock' : 'out-of-stock'; ?>">
                                <?php if ($is_available): ?>
                                    <i class='bx bx-check-circle'></i> In Stock 
                                    <!-- (<?php echo $selected_stock; ?> left) -->
                                <?php else: ?>
                                    <i class='bx bx-x-circle'></i> Out of Stock
                                <?php endif; ?>
                            </span>
                        </li>

                        <?php if (!empty($product['category_name'])): ?>
                            <li>
                                <span>Category:</span>
                                <a href="products.php?category=<?php echo $product['category_slug']; ?>">
                                    <?php echo htmlspecialchars($product['category_name']); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>

                    <!-- Dynamic Color Selector (Only show if multiple colors) -->
                    <?php if (count($available_colors) > 1): ?>
                        <div class="products-color-switch">
                            <span>Color:</span>
                            <ul id="colorSelector">
                                <?php foreach ($available_colors as $color):
                                    // Generate simple CSS class from color name
                                    $color_class = 'color-' . strtolower(preg_replace('/[^a-z]/', '', $color));
                                ?>
                                    <li class="color-option <?php echo ($current_color == $color) ? 'active' : ''; ?>">
                                        <a href="javascript:void(0)"
                                            title="<?php echo htmlspecialchars($color); ?>"
                                            class="<?php echo $color_class; ?> color-dot"
                                            data-color="<?php echo htmlspecialchars($color); ?>"
                                            onclick="changeColor('<?php echo htmlspecialchars($color); ?>')">
                                        </a>
                                        <span class="color-label"><?php echo htmlspecialchars($color); ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <!-- Dynamic Size Selector -->
                    <!-- <?php if (count($available_sizes) > 0): ?>
                        <div class="products-size-wrapper">
                            <span>Size:</span>
                            <ul id="sizeSelector">
                                <?php foreach ($available_sizes as $size): ?>
                                    <li class="<?php echo ($current_size == $size) ? 'active' : ''; ?> 
                                                <?php echo ($size_stock[$size] == 0) ? 'out-of-stock' : ''; ?>">
                                        <a href="javascript:void(0)"
                                            data-size="<?php echo htmlspecialchars($size); ?>"
                                            onclick="changeSize('<?php echo htmlspecialchars($size); ?>')">
                                            <?php echo htmlspecialchars($size); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?> -->

                    <!-- Info buttons (Keep as is) -->
                    <div class="products-info-btn pt-3">
                        <!-- <a href="#" data-bs-toggle="modal" data-bs-target="#sizeGuideModal">
                            <i class='bx bx-crop'></i> Size Guide
                        </a> -->
                        <a href="#" data-bs-toggle="modal" data-bs-target="#productsShippingModal">
                            <i class='bx bxs-truck'></i> Shipping & Returns
                        </a>
                    </div>

                    <!-- Add to Cart section -->
                    <div class="products-add-to-cart">
                        <div class="input-counter">
                            <span class="minus-btn"><i class='bx bx-minus'></i></span>
                            <input type="text" id="quantityInput" value="1" min="1" max="<?php echo $selected_stock; ?>">
                            <span class="plus-btn"><i class='bx bx-plus'></i></span>
                        </div>
                        <button type="button"
                            id="addToCartBtn"
                            class="default-btn"
                            <?php echo !$is_available ? 'disabled' : ''; ?>
                            onclick="addToCart()">
                            <i class='bx bx-cart'></i>
                            <?php echo $is_available ? 'Add to Cart' : 'Sold Out'; ?>
                        </button>
                    </div>

                    <!-- Buy it Now button -->
                    <div class="buy-checkbox-btn">
                        <div class="item">
                            <button type="button"
                                class="default-btn w-100"
                                id="buyNowBtn"
                                <?php echo !$is_available ? 'disabled style="opacity:0.6; cursor:not-allowed;"' : ''; ?>
                                onclick="buyNow()">
                                <?php echo $is_available ? 'Buy it Now' : 'Sold Out'; ?>
                            </button>
                        </div>
                    </div>

                    <!-- Logistics Highlights (Industry Standard) -->
                    <div class="product-logistics-highlights mt-4">
                        <ul class="logistics-list">
                            <li>
                                <i class='bx bxs-truck'></i> 
                                <span><strong>Free Shipping</strong> across India</span>
                            </li>
                            <li>
                                <i class='bx bx-world'></i> 
                                <span>For <strong>International Orders</strong> Please <a href="contact.php" class="text-link"> Contact Us </a>Directly</span>
                            </li>
                        </ul>
                    </div>




                    <!-- Accordion for Description and Additional Info -->
                    <div class="products-details-accordion">
                        <ul class="accordion">
                            <!-- Description -->
                            <li class="accordion-item">
                                <a class="accordion-title active" href="javascript:void(0)">
                                    <i class='bx bx-chevron-down'></i> Description
                                </a>
                                <div class="accordion-content show">
                                    <?php if (!empty($product['description'])): ?>
                                        <?php echo nl2br(htmlspecialchars($product['description'])); ?>
                                    <?php else: ?>
                                        <p>No description available.</p>
                                    <?php endif; ?>
                                </div>
                            </li>

                            <!-- Additional Information -->
                            <?php if (!empty($additional_info)): ?>
                                <li class="accordion-item">
                                    <a class="accordion-title" href="javascript:void(0)">
                                        <i class='bx bx-chevron-down'></i> Additional Information
                                    </a>
                                    <div class="accordion-content">
                                        <table class="table table-striped">
                                            <tbody>
                                                <?php foreach ($additional_info as $key => $value): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars(ucfirst($key)); ?>:</td>
                                                        <td><?php echo htmlspecialchars($value); ?></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Product Details Area -->

<!-- Start Related Products Area -->
<section class="product-area pb-70">
    <div class="related-products">
        <div class="container">
            <?php if (count($related_products) > 0): ?>
                <div class="section-title">
                    <span class="sub-title">You Might Also Like</span>
                    <h2>Related Products</h2>
                </div>

                <div class="products-slides owl-carousel owl-theme">
                    <?php foreach ($related_products as $related): ?>
                        <?php
                        $has_discount_related = ($related['sale_price'] > 0 && $related['sale_price'] < $related['price']);
                        ?>
                        <div class="single-products-box">
                            <div class="products-image">
                                <a href="product-details.php?slug=<?php echo $related['slug']; ?>">
                                    <img src="<?php echo !empty($related['main_image']) ? $related['main_image'] : 'assets/img/placeholder.png'; ?>"
                                        class="main-image"
                                        alt="<?php echo htmlspecialchars($related['name']); ?>">
                                    <img src="<?php echo !empty($related['hover_image']) ? $related['hover_image'] : $related['main_image']; ?>"
                                        class="hover-image"
                                        alt="<?php echo htmlspecialchars($related['name']); ?>">
                                </a>
                                <div class="products-button">
                                    <ul>
                                        <li>
                                            <div class="quick-view-btn">
                                                <a href="#" data-bs-toggle="modal" data-bs-target="#productsQuickView"
                                                    onclick="loadQuickView(<?php echo $related['id']; ?>)">
                                                    <i class='bx bx-search-alt'></i>
                                                    <span class="tooltip-label">Quick View</span>
                                                </a>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                <?php
                                // Check if related product is new (added in last 24 hours)
                                $is_new_related = false;
                                if (!empty($related['created_at'])) {
                                    $created_time = strtotime($related['created_at']);
                                    $current_time = time();
                                    $hours_diff = ($current_time - $created_time) / 3600;
                                    $is_new_related = ($hours_diff <= 24);
                                }

                                // Determine CSS class
                                $sale_tag_class_related = $has_discount_related ? 'sale-tag' : '';
                                if ($has_discount_related && $is_new_related) {
                                    $sale_tag_class_related = 'sale-tag sale-with-new';
                                }
                                ?>

                                <?php if ($has_discount_related): ?>
                                    <div class="<?= $sale_tag_class_related ?>">Sale!</div>
                                <?php endif; ?>
                                <?php if ($is_new_related): ?>
                                    <div class="new-tag">New!</div>
                                <?php endif; ?>
                                <a href="product-details.php?slug=<?php echo $related['slug']; ?>" class="add-to-cart">View Details</a>
                            </div>
                            <div class="products-content">
                                <h3><a href="product-details.php?slug=<?php echo $related['slug']; ?>">
                                        <?php echo htmlspecialchars($related['name']); ?>
                                    </a></h3>
                                <div class="price">
                                    <?php if ($has_discount_related): ?>
                                        <span class="old-price">₹<?php echo number_format($related['price'], 2); ?></span>
                                        <span class="new-price">₹<?php echo number_format($related['sale_price'], 2); ?></span>
                                    <?php else: ?>
                                        <span class="new-price">₹<?php echo number_format($related['price'], 2); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<!-- End Related Products Area -->

<!-- MINIMAL JAVASCRIPT - Only what's absolutely needed -->
<script>
    // Color change function
    function changeColor(color) {
        const currentUrl = new URL(window.location.href);
        currentUrl.searchParams.set('color', color);
        currentUrl.searchParams.delete('size');
        window.location.href = currentUrl.toString();
    }

    // Size change function
    function changeSize(size) {
        const currentUrl = new URL(window.location.href);
        currentUrl.searchParams.set('size', size);
        window.location.href = currentUrl.toString();
    }

    // Set background colors for color dots using main.js helper
    setTimeout(function() {
        if (typeof getColorHex === 'function') {
            document.querySelectorAll('.color-dot').forEach(function(colorDot) {
                const colorName = colorDot.getAttribute('data-color');
                if (colorName) {
                    const hexColor = getColorHex(colorName);
                    colorDot.style.backgroundColor = hexColor;

                    // Add border for light colors for visibility
                    const lowerColor = colorName.toLowerCase().trim();
                    if (lowerColor === 'white' || lowerColor === 'yellow' || hexColor === '#ffffff') {
                        colorDot.style.border = '3px solid #f0f0f0';
                    }
                }
            });
        }
    }, 100);

    // Add to cart function
    function addToCart() {
        const productId = <?php echo $product_id; ?>;
        const color = '<?php echo $current_color; ?>';
        const size = '<?php echo $current_size; ?>';
        const quantity = document.getElementById('quantityInput').value;

        if (!size) {
            alert('Please select a size');
            return;
        }

        const btn = document.getElementById('addToCartBtn');
        const originalText = btn.innerHTML;

        // Disable button and show loading
        btn.disabled = true;
        btn.innerHTML = '<i class="bx bx-loader bx-spin"></i> Adding...';

        // AJAX request
        const formData = new FormData();
        formData.append('action', 'add');
        formData.append('product_id', productId);
        formData.append('color', color);
        formData.append('size', size);
        formData.append('quantity', quantity);

        fetch('add-to-cart.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    btn.innerHTML = '<i class="bx bx-check"></i> Added!';
                    updateCartCount(data.cart_count);

                    setTimeout(() => {
                        btn.innerHTML = originalText;
                        btn.disabled = false;
                    }, 1500);
                } else {
                    alert(data.message);
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error adding to cart. Please try again.');
                btn.innerHTML = originalText;
                btn.disabled = false;
            });
    }

    // Buy Now Function
    function buyNow() {
        const productId = <?php echo $product_id; ?>;
        // Get current params or default
        const urlParams = new URLSearchParams(window.location.search);
        const color = urlParams.get('color') || '<?php echo $default_color; ?>';
        const size = urlParams.get('size') || '<?php echo $current_size; ?>';
        const quantity = document.getElementById('quantityInput').value;

        if (!size) {
            alert('Please select a size');
            return;
        }

        // Redirect to checkout with specific parameters
        window.location.href = `checkout.php?buy_now=1&p_id=${productId}&color=${color}&size=${size}&qty=${quantity}`;
    }
</script>


<?php include 'includes/footer.php'; ?>