<?php include 'includes/header.php'; ?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Privacy Policy</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Privacy Policy</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Privacy Policy Area -->
<section class="privacy-policy-area pt-70">
    <div class="container">
        <div class="policy-wrapper">
            
            <div class="policy-header mb-5">
                <h1>Privacy Policy</h1>
                <p><strong>Effective Date:</strong> <span id="auto-date"></span></p>
            </div>

            <div class="policy-body">
                <section class="mb-5">
                    <h3>1. Our Commitment to Privacy</h3>
                    <p>At <strong>Miss.Sogasu</strong>, your trust is our highest priority. This Privacy Policy explains what information we collect, why we collect it, and how we protect it when you visit our website or place an order. By using our website, you agree to the practices described below.</p>
                </section>

                <section class="mb-5">
                    <h3>2. Information We Collect</h3>
                    <p>When you shop with us or create an account, we collect information necessary to process your request:</p>
                    <ul>
                        <li><strong>Personal Details:</strong> Your full name, email address, phone number, and billing/shipping addresses.</li>
                        <li><strong>Order Information:</strong> Products purchased, transaction details, and payment confirmation.</li>
                        <li><strong>Technical Data:</strong> IP address, device type, browser type, and pages visited to help improve your shopping experience.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>3. How We Use Your Information</h3>
                    <p>We use your information strictly to operate our business and provide you with a seamless service:</p>
                    <ul>
                        <li>To process and deliver your orders efficiently.</li>
                        <li>To send order confirmations and tracking updates.</li>
                        <li>To respond to your queries and provide customer support.</li>
                        <li>To detect and prevent fraudulent or unauthorized transactions.</li>
                        <li>To share exclusive offers or updates (only if you opt-in to receive them).</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>4. Payment Security</h3>
                    <p>All payments are processed through secure and trusted third-party payment gateways (like Razorpay). <strong>Miss.Sogasu does not store your complete debit or credit card details</strong> on our servers. Your payment data is encrypted and handled by professional providers to ensure maximum security.</p>
                </section>

                <section class="mb-5">
                    <h3>5. Sharing of Information</h3>
                    <p>We respect your privacy and do not sell, rent, or trade your personal information. Your data is shared only with trusted partners who assist in our operations:</p>
                    <ul>
                        <li>Payment gateway providers for transaction processing.</li>
                        <li>Reliable courier and logistics partners for order delivery.</li>
                        <li>Technical service providers who maintain our website functionality.</li>
                        <li>Legal authorities, if required by law to comply with regulations.</li>
                    </ul>
                </section>

                <section class="mb-5">
                    <h3>6. Cookies & Tracking</h3>
                    <p>Our website uses cookies to remember your preferences, improve website functionality, and analyze visitor behavior. You can choose to disable cookies through your browser settings, though this may affect some features of the shopping experience.</p>
                </section>

                <section class="mb-5">
                    <h3>7. Data Security & Retention</h3>
                    <p>We implement appropriate security measures, including SSL encryption, to protect your personal information. We retain your data only as long as necessary to fulfill orders, comply with legal obligations, or resolve disputes. Once no longer required, data is securely removed or anonymized.</p>
                </section>

                <section class="mb-5">
                    <h3>8. Your Rights</h3>
                    <p>You have the right to access the personal data we hold about you, correct inaccurate information, or request the deletion of your data. To exercise these rights, please contact us using the information provided below.</p>
                </section>

                <section class="contact-card">
                    <h3>Contact Us</h3>
                    <p>Miss.Sogasu</p>
                    <p>Email: <a href="mailto:misssogasu@gmail.com">misssogasu@gmail.com</a></p>
                    <p>Phone / WhatsApp: +91 8128708120</p>
                    <p>Hyderabad, Telangana, India</p>
                </section>
            </div>
        </div>
    </div>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sets the date requested by the client
        document.getElementById('auto-date').innerText = "01 January 2026";
    });
</script>

<?php include 'includes/footer.php'; ?>