<?php
require_once 'includes/db.php';

// Security: Ensure user came from a successful payment
if (!isset($_SESSION['success_order_id'])) {
    header("Location: index.php");
    exit;
}

$order_id = $_SESSION['success_order_id'];

// Fetch order details to display
$order_res = $conn->query("SELECT * FROM orders WHERE id = $order_id");
if($order_res->num_rows === 0) {
    // Should not happen, but a good safeguard
    header("Location: index.php");
    exit;
}
$order = $order_res->fetch_assoc();

// Clean up the session variable so this page can't be refreshed
unset($_SESSION['success_order_id']);

include 'includes/header.php';
?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Order Confirmation</h2>
        </div>
    </div>
</div>

<!-- Start Order Success Area -->
<section class="order-success-area ptb-100">
    <div class="container">
        <div class="order-success-content text-center">
            <i class='bx bx-check-circle' style="font-size: 80px; color: #28a745;"></i>
            <h2>Thank you for your order!</h2>
            <p>Your order has been placed successfully and is being processed. You will receive an email confirmation shortly.</p>
            
            <div class="order-summary-box">
                <h4>Order Summary</h4>
                <p><strong>Order ID:</strong> #<?= str_pad($order['id'], 6, '0', STR_PAD_LEFT) ?></p>
                <!-- <p><strong>Date:</strong> <?= date('F d, Y', strtotime($order['created_at'])) ?></p> -->
                <p><strong>Total Amount:</strong> ₹<?= number_format($order['total_amount'], 2) ?></p>
                <!-- <p><strong>Payment Method:</strong> <?= strtoupper($order['payment_method']) ?></p> -->
            </div>
            
            <div class="mt-4">
                <a href="products.php" class="default-btn">Continue Shopping</a>
                <a href="user-profile.php?active=orders" class="optional-btn">View My Orders</a>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>