<?php
require_once 'includes/db.php';

// 1. If user is already logged in, redirect them to their profile
if (isset($_SESSION['user_id'])) {
    header("Location: user-profile.php");
    exit;
}

$error = '';

// 2. Handle Login Submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = sanitize_input($_POST['email']);
    $pass  = $_POST['password'];

    if (empty($email) || empty($pass)) {
        $error = "Please enter both email and password.";
    } else {
        // Fetch user by email
        $stmt = $conn->prepare("SELECT id, full_name, password FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();

            // Verify the Hashed Password
            if (password_verify($pass, $user['password'])) {
                // SUCCESS: Create Session
                $_SESSION['user_id']    = $user['id'];
                $_SESSION['user_name']  = $user['full_name'];
                $_SESSION['user_email'] = $email;

                $user_id = $user['id'];

                // ---------------------------------------------------------
                // 1. MERGE SESSION CART TO DATABASE
                // ---------------------------------------------------------
                if (!empty($_SESSION['cart'])) {
                    foreach ($_SESSION['cart'] as $item) {
                        $p_id  = $item['product_id'];
                        $qty   = $item['quantity'];
                        $size  = sanitize_input($item['size']);
                        $color = sanitize_input($item['color']);

                        // Check if this specific item exists in DB for this user
                        $check_cart = $conn->query("SELECT id, quantity FROM cart 
                                                    WHERE user_id = $user_id 
                                                    AND product_id = $p_id 
                                                    AND size = '$size' 
                                                    AND color = '$color'");

                        if ($check_cart->num_rows > 0) {
                            // Item exists: Update quantity
                            // Option A: Add quantities together
                            $row = $check_cart->fetch_assoc();
                            $new_qty = $row['quantity'] + $qty;

                            // Optional: Check max stock here if you want to be strict
                            $conn->query("UPDATE cart SET quantity = $new_qty WHERE id = " . $row['id']);
                        } else {
                            // Item does not exist: Insert new row
                            $conn->query("INSERT INTO cart (user_id, product_id, quantity, size, color) 
                                          VALUES ($user_id, $p_id, $qty, '$size', '$color')");
                        }
                    }
                }

                // ---------------------------------------------------------
                // 2. REBUILD SESSION FROM DATABASE (The "Source of Truth")
                // ---------------------------------------------------------
                // Clear old session cart to avoid duplicates during rebuild
                $_SESSION['cart'] = [];

                // Fetch comprehensive cart data (joining with products and images)
                // We added COLLATE utf8mb4_unicode_ci to force the comparison to work even if DB settings differ
                $sql_load = "SELECT c.product_id, c.quantity, c.size, c.color,
                                    p.name, p.slug, p.price, p.sale_price,
                                    (SELECT pi.image_path FROM product_images pi 
                                     WHERE pi.product_id = c.product_id 
                                     AND (pi.color_group COLLATE utf8mb4_unicode_ci = c.color COLLATE utf8mb4_unicode_ci 
                                          OR pi.color_group = 'Standard') 
                                     ORDER BY pi.is_primary DESC LIMIT 1) as image_path
                             FROM cart c
                             JOIN products p ON c.product_id = p.id
                             WHERE c.user_id = $user_id";

                $result_load = $conn->query($sql_load);

                if ($result_load->num_rows > 0) {
                    while ($row = $result_load->fetch_assoc()) {
                        // Recreate the Cart Key used in add-to-cart.php
                        $cart_key = $row['product_id'] . '_' . $row['color'] . '_' . $row['size'];

                        // Determine price
                        $final_price = ($row['sale_price'] > 0) ? $row['sale_price'] : $row['price'];

                        // Determine image (fallback if specific color image missing)
                        $image = !empty($row['image_path']) ? $row['image_path'] : 'assets/img/placeholder.png';

                        $_SESSION['cart'][$cart_key] = [
                            'product_id' => $row['product_id'],
                            'name'       => $row['name'],
                            'slug'       => $row['slug'],
                            'color'      => $row['color'],
                            'size'       => $row['size'],
                            'quantity'   => $row['quantity'],
                            'price'      => $final_price,
                            'image'      => $image
                        ];
                    }
                }

                // ---------------------------------------------------------
                // 3. REDIRECT
                // ---------------------------------------------------------
                // Check GET first (passed via action URL)
                if (isset($_GET['redirect']) && $_GET['redirect'] == 'checkout') {
                    header("Location: checkout.php");
                } else {
                    header("Location: user-profile.php");
                }
                exit;
            } else {
                $error = "Invalid email or password.";
            }
        } else {
            $error = "No account found with that email.";
        }
        $stmt->close();
    }
}

$page_title = "Login";
include 'includes/header.php';
?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>My Account</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Login</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Login Area -->
<section class="login-area pt-100">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-6">
                <div class="login-content">
                    <h2>Login</h2>

                    <!-- Flash Message & Error Display -->
                    <?php if (isset($_SESSION['flash_msg'])): ?>
                        <div class="alert alert-<?= $_SESSION['flash_msg']['type'] ?? 'success' ?> alert-dismissible fade show">
                            <?= htmlspecialchars($_SESSION['flash_msg']['text']) ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['flash_msg']); ?>
                    <?php endif; ?>
                    <?php if ($error): ?>
                        <div class="alert alert-danger"><?= $error ?></div>
                    <?php endif; ?>

                    <form class="login-form" method="POST" action="login.php?<?php echo http_build_query($_GET); ?>">
                        <div class="form-group">
                            <label>Email Address</label>
                            <input type="email" name="email" class="form-control" placeholder="Email address" required>
                        </div>

                        <div class="form-group">
                            <label>Password</label>
                            <div class="password-wrapper">
                                <input type="password" name="password" class="form-control" placeholder="Password" required>
                                <i class='bx bx-hide toggle-password'></i>
                            </div>
                        </div>

                        <!-- Changed type to "submit" and removed onclick redirect -->
                        <button type="submit" class="default-btn">Login</button>

                        <a href="forgot-password.php" class="forgot-password">Lost your password?</a>
                    </form>
                </div>
            </div>

            <div class="col-lg-6 col-md-6">
                <div class="new-customer-content">
                    <h2>New Customer?</h2>
                    <span>Create an Account</span>
                    <p>Create an account with us to enjoy a faster checkout process, easily track your orders, view your purchase history, and manage your wishlist.</p>
                    <a href="signup.php" class="optional-btn">Create an Account</a>
                </div>
            </div>
        </div>
    </div>
</section>


<?php include 'includes/footer.php'; ?>