<?php include 'includes/header.php'; ?>

<!-- Start Main Banner Area -->
<div class="home-slides owl-carousel owl-theme">
    <?php
    $hero_slides = $conn->query("SELECT * FROM images_banners WHERE image_section = 'hero' AND is_active = 1 ORDER BY display_order ASC");

    if ($hero_slides->num_rows > 0):
        while ($slide = $hero_slides->fetch_assoc()):
            // Determine if we need the Bootstrap 'text-white' class or nothing (default black)
            $color_class = ($slide['text_color'] == 'white') ? 'text-white' : '';
    ?>
            <div class="main-banner" style="background-image: url('<?= htmlspecialchars($slide['image_path']) ?>');">
                <div class="d-table">
                    <div class="d-table-cell">
                        <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-lg-7 col-md-12">

                                    <!-- YOUR SPECIFIC DIV STRUCTURE -->
                                    <div class="main-banner-content <?= $color_class ?>">
                                        <span class="sub-title"><?= htmlspecialchars($slide['heading_small']) ?></span>
                                        <h1><?= htmlspecialchars($slide['heading_large']) ?></h1>
                                        <p><?= htmlspecialchars($slide['paragraph']) ?></p>
                                        <div class="btn-box">
                                            <a href="<?= htmlspecialchars($slide['btn_link']) ?>" class="default-btn">
                                                <?= htmlspecialchars($slide['btn_text']) ?>
                                            </a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    <?php endwhile;
    endif; ?>
</div>
<!-- End Main Banner Area -->


<!-- Start Categories Banner Area -->
<section class="categories-banner-area pt-70 pb-70">
    <div class="container-fluid">
        <div class="section-title">
            <span class="sub-title">Explore Our Style</span>
            <h2>Shop By Category</h2>
        </div>

        <div class="categories-slides categories-grid">
            <?php
            $home_cats = $conn->query("SELECT name, slug, image FROM categories WHERE is_active = 1 ORDER BY display_order ASC, name ASC");
            if ($home_cats->num_rows > 0):
                while ($cat = $home_cats->fetch_assoc()):
            ?>
                    <div class="item">
                        <div class="single-categories-box">
                            <img src="<?= !empty($cat['image']) ? $cat['image'] : 'assets/img/placeholder.png' ?>" alt="Category: <?= htmlspecialchars($cat['name']) ?>">
                            <div class="content text-white">
                                <h3><?= htmlspecialchars($cat['name']) ?></h3>
                                <a href="products.php?category=<?= htmlspecialchars($cat['slug']) ?>" class="default-btn">Shop Now</a>
                            </div>
                            <a href="products.php?category=<?= htmlspecialchars($cat['slug']) ?>" class="link-btn"></a>
                        </div>
                    </div>
            <?php
                endwhile;
            endif;
            ?>
        </div>
    </div>
</section>
<!-- End Categories Banner Area -->

<!-- Start Facility Area -->
<!-- <section class="facility-area">
    <div class="container-fluid">
        <div class="row justify-content-center">

            <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                <div class="single-facility-box">
                    <div class="icon">
                        <i class='flaticon-tracking'></i>
                    </div>
                    <h3>Free Express Shipping</h3>
                </div>
            </div>

            <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                <div class="single-facility-box">
                    <div class="icon">
                        <i class='flaticon-return'></i>
                    </div>
                    <h3>Hassle-Free Returns</h3>
                </div>
            </div>

            <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                <div class="single-facility-box">
                    <div class="icon">
                        <i class='flaticon-shuffle'></i>
                    </div>
                    <h3>Easy Exchanges</h3>
                </div>
            </div>

            <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                <div class="single-facility-box">
                    <div class="icon">
                        <i class='flaticon-credit-card'></i>
                    </div>
                    <h3>100% Secure Checkout</h3>
                </div>
            </div>

            <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                <div class="single-facility-box">
                    <div class="icon">
                        <i class='flaticon-location' style="padding-left: 15px;"></i>
                    </div>
                    <h3>Order Tracking</h3>
                </div>
            </div>

            <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                <div class="single-facility-box">
                    <div class="icon">
                        <i class='flaticon-customer-service'></i>
                    </div>
                    <h3>Dedicated Support</h3>
                </div>
            </div>
        </div>
    </div>
</section> -->
<!-- End Facility Area -->

<!-- Start Why Choose Us Area -->
<section class="why-choose-area ptb-70">
    <div class="container">
        <div class="row mb-5">
            <div class="col-12 text-center">
                <h2 class="why-title">Why Choose Us</h2>
            </div>
        </div>

        <!-- Changed from 'row' to 'owl-carousel' -->
        <div class="why-choose-slides owl-carousel owl-theme">

            <!-- Item 1 -->
            <div class="why-box has-divider text-center">
                <div class="why-icon">
                    <i class='bx bxs-edit-alt'></i>
                </div>
                <h3 class="why-heading">Signature <br> Handpicked Designs</h3>
                <p class="why-text">Each saree is thoughtfully chosen to reflect heritage, craftsmanship, and refined elegance — for women who value timeless artistry.</p>
            </div>

            <!-- Item 2 -->
            <div class="why-box has-divider text-center">
                <div class="why-icon">
                    <i class='bx bxs-badge-check'></i>
                </div>
                <h3 class="why-heading">Uncompromising <br> Quality</h3>
                <p class="why-text">From fabric selection to final finish, every detail is perfected to ensure comfort, richness, and enduring beauty.</p>
            </div>

            <!-- Item 3 -->
            <div class="why-box text-center">
                <div class="why-icon">
                    <i class='bx bxs-package'></i>
                </div>
                <h3 class="why-heading">Trusted Delivery <br> Experience</h3>
                <p class="why-text">Carefully packed, securely handled, and delivered with reliability — so your saree reaches you exactly as it was meant to.</p>
            </div>

        </div>
    </div>
</section>

<!-- Start Products Area -->
<section class="products-area ptb-70">
    <div class="container">
        <div class="section-title">
            <span class="sub-title">Just In</span>
            <h2>New Arrivals</h2>
        </div>

        <div class="row justify-content-center">
            <?php
            // 1. Prepare the MORE ADVANCED SQL query
            $new_arrivals_sql = "SELECT p.*,
                -- Use COALESCE to prioritize the default color's primary image, but fall back to any primary image if needed.
                COALESCE(
                    (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.color_group = p.default_color_group ORDER BY pi.is_primary DESC, pi.id ASC LIMIT 1),
                    (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id ORDER BY pi.is_primary DESC, pi.id ASC LIMIT 1)
                ) as main_image,
                -- Do the same for the hover image (non-primary).
                COALESCE(
                    (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.color_group = p.default_color_group AND pi.is_primary = 0 ORDER BY pi.id ASC LIMIT 1),
                    (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.is_primary = 0 ORDER BY pi.id ASC LIMIT 1)
                ) as hover_image
                FROM products p
                WHERE p.is_active = 1
                ORDER BY p.created_at DESC
                LIMIT 6";

            $new_arrivals_result = $conn->query($new_arrivals_sql);

            if ($new_arrivals_result->num_rows > 0):
                while ($product = $new_arrivals_result->fetch_assoc()):
                    // 2. Prepare variables (this part remains the same)
                    $product_url = "product-details.php?slug=" . htmlspecialchars($product['slug']);
                    $main_image = !empty($product['main_image']) ? htmlspecialchars($product['main_image']) : 'assets/img/placeholder.png';
                    $hover_image = !empty($product['hover_image']) ? htmlspecialchars($product['hover_image']) : $main_image;

                    $has_sale = !empty($product['sale_price']) && $product['sale_price'] > 0 && $product['sale_price'] < $product['price'];
                    $is_new = (strtotime($product['created_at']) > strtotime('-7 days'));
            ?>
                    <!-- Dynamic Product Card -->
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6">
                        <div class="single-products-box">
                            <div class="products-image">
                                <a href="<?= $product_url ?>">
                                    <img src="<?= $main_image ?>" class="main-image" alt="<?= htmlspecialchars($product['name']) ?>">
                                    <img src="<?= $hover_image ?>" class="hover-image" alt="<?= htmlspecialchars($product['name']) ?> hover">
                                </a>

                                <div class="products-button">
                                    <ul>
                                        <li>
                                            <div class="quick-view-btn">
                                                <a href="#" data-bs-toggle="modal" data-bs-target="#productsQuickView" onclick="loadQuickView(<?= $product['id'] ?>)">
                                                    <i class='bx bx-search-alt'></i>
                                                    <span class="tooltip-label">Quick View</span>
                                                </a>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                                <?php if ($has_sale): ?>
                                    <div class="sale-tag">Sale!</div>
                                <?php elseif ($is_new): ?>
                                    <div class="new-tag">New!</div>
                                <?php endif; ?>

                                <!-- PROFESSIONAL UPDATE: Changed to "View Details" as user must select size/color -->
                                <a href="<?= $product_url ?>" class="add-to-cart">View Details</a>
                            </div>

                            <div class="products-content">
                                <h3><a href="<?= $product_url ?>"><?= htmlspecialchars($product['name']) ?></a></h3>
                                <div class="price">
                                    <?php if ($has_sale): ?>
                                        <span class="old-price">₹<?= number_format($product['price']) ?></span>
                                        <span class="new-price">₹<?= number_format($product['sale_price']) ?></span>
                                    <?php else: ?>
                                        <span class="new-price">₹<?= number_format($product['price']) ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php
                endwhile;
            else:
                // Optional: Show a message if no products are found
                echo '<p class="text-center">No new products found at the moment. Please check back later!</p>';
            endif;
            ?>
        </div>
    </div>
</section>
<!-- End Products Area -->

<!-- Start Offer Area -->
<?php
$home_offer = $conn->query("SELECT * FROM offers WHERE location = 'home' AND is_active = 1")->fetch_assoc();
if ($home_offer):
?>
    <section class="offer-area ptb-100 jarallax" data-jarallax='{"speed": 0.3}' style="background-image: url('<?= $home_offer['image_path'] ?>');">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-6 offset-lg-7">
                    <div class="offer-content-box">
                        <span class="sub-title"><?= htmlspecialchars($home_offer['sub_title']) ?></span>
                        <h2><?= htmlspecialchars($home_offer['heading']) ?></h2>
                        <p><?= htmlspecialchars($home_offer['paragraph']) ?></p>
                        <a href="<?= htmlspecialchars($home_offer['btn_link']) ?>" class="default-btn"><?= htmlspecialchars($home_offer['btn_text']) ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<!-- End Offer Area -->


<!-- Start Products Area (Bestsellers Slider) -->
<section class="products-area pt-100 pb-70">
    <div class="container">
        <div class="section-title text-start">
            <span class="sub-title">Top Picks</span>
            <h2>Our Bestsellers</h2>
            <a href="products.php" class="default-btn">Shop More</a>
        </div>

        <div class="products-slides owl-carousel owl-theme">
            <?php
            // CHECK IF ANY SALES EXIST
            $has_sales = $conn->query("SELECT id FROM order_items LIMIT 1")->num_rows > 0;

            if ($has_sales) {
                // --- LOGIC 1: FETCH BY TOP SOLD ---
                $bestsellers_sql = "
                    SELECT p.*, 
                        (SELECT COALESCE(SUM(oi.quantity), 0) FROM order_items oi WHERE oi.product_id = p.id) as total_sold,
                        -- (Image subqueries remain the same)
                        COALESCE(
                            (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.color_group = p.default_color_group ORDER BY pi.is_primary DESC, pi.id ASC LIMIT 1),
                            (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id ORDER BY pi.is_primary DESC, pi.id ASC LIMIT 1)
                        ) as main_image,
                        COALESCE(
                            (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.color_group = p.default_color_group AND pi.is_primary = 0 ORDER BY pi.id ASC LIMIT 1),
                            (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.is_primary = 0 ORDER BY pi.id ASC LIMIT 1)
                        ) as hover_image
                    FROM products p
                    WHERE p.is_active = 1
                    ORDER BY total_sold DESC, p.created_at DESC
                    LIMIT 6";
            } else {
                // --- LOGIC 2: FALLBACK TO HIGHEST STOCK ---
                $bestsellers_sql = "
                    SELECT p.*,
                        -- Calculate total stock for the entire product
                        (SELECT SUM(ps.stock_quantity) FROM product_sizes ps WHERE ps.product_id = p.id) as total_stock,
                        -- (Image subqueries remain the same)
                        COALESCE(
                            (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.color_group = p.default_color_group ORDER BY pi.is_primary DESC, pi.id ASC LIMIT 1),
                            (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id ORDER BY pi.is_primary DESC, pi.id ASC LIMIT 1)
                        ) as main_image,
                        COALESCE(
                            (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.color_group = p.default_color_group AND pi.is_primary = 0 ORDER BY pi.id ASC LIMIT 1),
                            (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.is_primary = 0 ORDER BY pi.id ASC LIMIT 1)
                        ) as hover_image
                    FROM products p
                    WHERE p.is_active = 1
                    ORDER BY total_stock DESC, p.created_at DESC
                    LIMIT 6";
            }

            $bestsellers_result = $conn->query($bestsellers_sql);

            if ($bestsellers_result && $bestsellers_result->num_rows > 0):
                while ($product = $bestsellers_result->fetch_assoc()):
                    // The HTML loop below this remains exactly the same as before
                    $product_url = "product-details.php?slug=" . htmlspecialchars($product['slug']);
                    $main_image = !empty($product['main_image']) ? htmlspecialchars($product['main_image']) : 'assets/img/placeholder.png';
                    $hover_image = !empty($product['hover_image']) ? htmlspecialchars($product['hover_image']) : $main_image;
                    $has_sale = !empty($product['sale_price']) && $product['sale_price'] > 0 && $product['sale_price'] < $product['price'];
            ?>
                    <!-- Dynamic Slide Item (HTML is unchanged) -->
                    <div class="single-products-box">
                        <div class="products-image">
                            <a href="<?= $product_url ?>">
                                <img src="<?= $main_image ?>" class="main-image" alt="<?= htmlspecialchars($product['name']) ?>">
                                <img src="<?= $hover_image ?>" class="hover-image" alt="<?= htmlspecialchars($product['name']) ?> hover">
                            </a>
                            <div class="products-button">
                                <ul>
                                    <li>
                                        <div class="quick-view-btn">
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#productsQuickView" onclick="loadQuickView(<?= $product['id'] ?>)">
                                                <i class='bx bx-search-alt'></i>
                                                <span class="tooltip-label">Quick View</span>
                                            </a>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <?php if ($has_sale): ?><div class="sale-tag">Sale!</div><?php endif; ?>
                            <a href="<?= $product_url ?>" class="add-to-cart">View Details</a>
                        </div>
                        <div class="products-content">
                            <h3><a href="<?= $product_url ?>"><?= htmlspecialchars($product['name']) ?></a></h3>
                            <div class="price">
                                <?php if ($has_sale): ?>
                                    <span class="old-price">₹<?= number_format($product['price']) ?></span>
                                    <span class="new-price">₹<?= number_format($product['sale_price']) ?></span>
                                <?php else: ?>
                                    <span class="new-price">₹<?= number_format($product['price']) ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
            <?php
                endwhile;
            else:
                echo '<div class="text-center p-5 text-muted">No featured products found.</div>';
            endif;
            ?>
        </div>
    </div>
</section>


<!-- Start Testimonials Area -->
<section class="testimonials-area pb-70">
    <div class="container">
        <div class="section-title">
            <span class="sub-title">From Our Customers</span>
            <h2>What Our Clients Say</h2>
        </div>

        <div class="testimonials-slides owl-carousel owl-theme">
            <?php
            $testi_res = $conn->query("SELECT * FROM testimonials WHERE is_active = 1 ORDER BY display_order ASC");

            if ($testi_res->num_rows > 0):
                while ($item = $testi_res->fetch_assoc()):
            ?>
                    <!-- Re-structured for modern card look -->
                    <div class="single-testimonials-box">

                        <!-- The main quote box -->
                        <div class="quote-box">
                            <!-- <div class="rating">
                                <?php
                                $stars = (int)$item['rating'];
                                for ($i = 1; $i <= 5; $i++) {
                                    echo ($i <= $stars) ? "<i class='bx bxs-star'></i>" : "<i class='bx bx-star'></i>";
                                }
                                ?>
                            </div> -->
                            <p><?= htmlspecialchars($item['quote']) ?></p>
                        </div>

                        <!-- The author info, now outside the quote box -->
                        <div class="info">
                            <h3><?= htmlspecialchars($item['author_name']) ?></h3>
                            <span><?= htmlspecialchars($item['author_position']) ?></span>
                        </div>

                    </div>
            <?php
                endwhile;
            else:
                echo '<p class="text-center">Our happy customers are yet to leave a review.</p>';
            endif;
            ?>
        </div>
    </div>
</section>
<!-- End Testimonials Area -->

<!-- Start Our Story Area -->
<section class="our-story-area ptb-70">
    <div class="container">
        <!-- Added d-flex and flex-wrap to ensure order classes work perfectly -->
        <div class="row align-items-center justify-content-center d-flex">

            <!-- Story Text (Order 1 on mobile, Order 2 on desktop) -->
            <div class="col-lg-6 col-md-7 order-1 order-md-2">
                <div class="story-text-content">
                    <h2 class="story-title">More than a saree</h2>

                    <p class="story-quote">
                        Every Women has a moment when she fells in love with a saree <br> — that's where Miss.Sogasu begins.
                    </p>

                    <div class="story-tagline">
                        <i class='bx bxs-heart heart-icon'></i>
                        Stay Stylish.. Stay Sogasu
                    </div>
                </div>
            </div>

            <!-- Logo (Order 2 on mobile, Order 1 on desktop) -->
            <!-- Added mt-4 to provide space when logo moves to the bottom on mobile -->
            <div class="col-lg-4 col-md-5 order-2 order-md-1 mt-4 mt-md-0 text-center">
                <img src="assets/img/complete-logo.png" alt="Miss.Sogasu Logo" class="story-logo">
            </div>

        </div>
    </div>
</section>
<!-- End Our Story Area -->

<?php include 'includes/footer.php'; ?>