<?php
// At the top of header.php
require_once 'includes/db.php';

// Simplified Social Media Helper Array
$social_media_options = [
    'whatsapp'   => ['icon' => 'bx bxl-whatsapp'],
    'instagram'  => ['icon' => 'bx bxl-instagram'],
    'facebook'   => ['icon' => 'bx bxl-facebook'],
    'youtube'    => ['icon' => 'bx bxl-youtube'],
    'telegram'   => ['icon' => 'bx bxl-telegram'],
    'phone'      => ['icon' => 'bx bx-phone'],
    'email'      => ['icon' => 'bx bx-envelope']
];


$topbar_enabled_res = $conn->query("SELECT setting_value FROM site_settings WHERE setting_key = 'topbar_enabled'");
$topbar_enabled = $topbar_enabled_res->fetch_assoc()['setting_value'] ?? 0;

if ($topbar_enabled) {
    $promo_res = $conn->query("SELECT title, link FROM homepage_topbar LIMIT 1");
    $promo_data = $promo_res->fetch_assoc();
    $social_links_res = $conn->query("SELECT link_url, social_media_type FROM social_links WHERE is_active = 1 ORDER BY display_order ASC");
}

// Fetch Site Settings from Database
$settings = [];
$settings_res = $conn->query("SELECT setting_key, setting_value FROM site_settings");
if ($settings_res) {
    while ($row = $settings_res->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}

// Define variables with Database values or Fallbacks
$site_title = !empty($settings['site_title']) ? $settings['site_title'] : "Miss.Sogasu - Elegant Dresses & Women's Fashion";
$site_desc  = !empty($settings['site_description']) ? $settings['site_description'] : "Discover the latest collection of elegant and stylish dresses at Miss.Sogasu.";
$site_keys  = !empty($settings['site_keywords']) ? $settings['site_keywords'] : "dresses, women's fashion, online clothing store";

// Logic: If a specific page (like product details) sets a custom title, use it. Otherwise, use global.
$current_page_title = isset($page_title) ? $page_title . ' | ' . $site_title : $site_title;

?>




<!DOCTYPE html>
<html lang="zxx">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- ================================================== -->
    <!-- ========== Primary Meta Tags for SEO ============= -->
    <!-- ================================================== -->
    <title><?php echo htmlspecialchars($current_page_title); ?></title>

    <meta name="description" content="<?php echo htmlspecialchars($site_desc); ?>">

    <meta name="keywords" content="<?php echo htmlspecialchars($site_keys); ?>">

    <meta name="robots" content="index, follow">


    <!-- ================================================== -->
    <!-- ============= Canonical & Favicon Tags =========== -->
    <!-- ================================================== -->

    <link rel="canonical" href="https://www.misssogasu.com/">

    <link rel="icon" type="image/png" href="assets/img/favicon.png">


    <!-- ================================================== -->
    <!-- ========= Open Graph Tags (for Facebook) ========= -->
    <!-- ================================================== -->
    <meta property="og:title" content="<?php echo htmlspecialchars($current_page_title); ?>">

    <meta property="og:type" content="website">

    <meta property="og:url" content="https://www.misssogasu.com/">

    <!-- Note: You might want to make this dynamic later too, usually the site logo or a specific banner -->
    <meta property="og:image" content="https://www.misssogasu.com/assets/img/social-share-image.jpg">

    <meta property="og:description" content="<?php echo htmlspecialchars($site_desc); ?>">

    <meta property="og:site_name" content="<?php echo htmlspecialchars($site_title); ?>">


    <!-- ================================================== -->
    <!-- =========== Twitter Card Tags (for Twitter) ====== -->
    <!-- ================================================== -->
    <meta name="twitter:card" content="summary_large_image">

    <!-- CHANGE THIS: Your website's Twitter handle, if you have one. -->
    <meta name="twitter:site" content="@MissSogasu">

    <meta name="twitter:title" content="<?php echo htmlspecialchars($current_page_title); ?>">

    <meta name="twitter:description" content="<?php echo htmlspecialchars($site_desc); ?>">

    <meta name="twitter:image" content="https://www.misssogasu.com/assets/img/social-share-image.jpg">

    <!-- Links of CSS files -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/boxicons.min.css">
    <link rel="stylesheet" href="assets/css/flaticon.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/nice-select.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
    <link rel="stylesheet" href="assets/css/meanmenu.min.css">
    <link rel="stylesheet" href="assets/css/rangeSlider.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/dark.css">
    <link rel="stylesheet" href="assets/css/responsive.css">
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>

    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=NTR&display=swap" rel="stylesheet">

</head>

<body>

    <?php if ($topbar_enabled): ?>
        <!-- Start Top Header Area -->
        <div class="top-header">
            <div class="container">
                <div class="row align-items-center">

                    <!-- Left Column (30%) -->
                    <div class="col-lg-3 d-none d-lg-block">
                        <div class="top-header-left">
                            <span><b>Welcome to Miss.Sogasu</b></span>
                        </div>
                        <!-- <div class="top-header-left">
                            <span><i class='bx bxs-truck'></i> <b>Free Shipping Across India</b></span>
                        </div> -->
                    </div>

                    <!-- Center Column (40% - The Slider) -->
                    <div class="col-lg-6 col-12 text-center">
                        <div class="top-header-center">
                            <?php
                            // 1. Fetch active messages
                            $promo_sql = "SELECT title, link FROM homepage_topbar WHERE is_active = 1 ORDER BY display_order ASC";
                            $promo_res = $conn->query($promo_sql);

                            if ($promo_res->num_rows > 0):
                            ?>
                                <!-- 2. Owl Carousel Wrapper (Text Only) -->
                                <div class="top-text-slider owl-carousel owl-theme">
                                    <?php while ($promo = $promo_res->fetch_assoc()): ?>
                                        <div class="item">
                                            <!-- No links, just text -->
                                            <span><?= htmlspecialchars($promo['title']) ?></span>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Right Column (30% - Social Icons) -->
                    <div class="col-lg-3 d-none d-lg-block text-end">
                        <div class="top-header-right">
                            <ul class="justify-content-end">
                                <?php if (isset($social_links_res)) {
                                    $social_links_res->data_seek(0);
                                    while ($link = $social_links_res->fetch_assoc()):
                                        $icon_class = $social_media_options[$link['social_media_type']]['icon'] ?? ''; ?>
                                        <li>
    <a href="<?= htmlspecialchars($link['link_url']) ?>" 
       target="_blank" 
       class="social-icon-<?= htmlspecialchars($link['social_media_type']) ?>">
        <i class='<?= $icon_class ?>'></i>
    </a>
</li>
                                <?php endwhile;
                                } ?>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- End Top Header Area -->
    <?php endif; ?>

    <!-- Start Navbar Area -->
    <div class="navbar-area">
        <div class="xton-responsive-nav">
            <div class="container">
                <div class="xton-responsive-menu">
                    <!-- Mobile Offcanvas Toggle -->
                    <button class="mobile-menu-toggle" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileNavOffcanvas" aria-controls="mobileNavOffcanvas" aria-label="Open menu">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>

                    <!-- Logo -->
                    <div class="logo">
                        <a href="index.php">
                            <img src="assets/img/logo.png" class="main-logo" alt="logo">
                            <img src="assets/img/logo2.png" class="white-logo" alt="logo" style="height: 40px;">
                        </a>
                    </div>
                    <!-- Mobile Header Icons -->
                    <div class="others-option mobile-header-icons">

                        <div class="option-item">
                            <div class="search-btn-box">
                                <i class="search-btn bx bx-search-alt"></i>
                            </div>
                        </div>

                        <div class="option-item">
                            <div class="cart-btn">
                                <a href="cart.php"><i class='bx bx-shopping-bag'></i>
                                    <span>
                                        <?php
                                        $cart_count = 0;
                                        if (!empty($_SESSION['cart'])) {
                                            foreach ($_SESSION['cart'] as $item) {
                                                $cart_count += $item['quantity'];
                                            }
                                        }
                                        echo $cart_count; ?>
                                    </span>
                                </a>
                            </div>
                        </div>

                        <div class="option-item">
                            <div class="cart-btn">
                                <a href="login.php">
                                    <i class="bx bx-user"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- Start Mobile Offcanvas Menu -->
        <div class="offcanvas offcanvas-start mobile-nav-offcanvas" tabindex="-1" id="mobileNavOffcanvas" aria-labelledby="mobileNavOffcanvasLabel">
            <div class="offcanvas-header">
                <a href="index.php" class="mobile-offcanvas-logo" id="mobileNavOffcanvasLabel">
                    <img src="assets/img/logo.png" alt="logo" style="height: 50px;">
                </a>
                <button type="button" class="mobile-offcanvas-close" data-bs-dismiss="offcanvas" aria-label="Close menu">
                    <i class='bx bx-x'></i>
                </button>
            </div>

            <div class="offcanvas-body">
                <ul class="mobile-offcanvas-nav">
                    <li><a href="index.php">Home</a></li>
                    <li><a href="products.php?filter=new-arrivals">New Arrivals</a></li>
                    <li><a href="products.php?filter=best-sellers">Best Sellers</a></li>

                    <li class="has-submenu">
                        <button type="button" class="mobile-offcanvas-nav-toggle" data-bs-toggle="collapse" data-bs-target="#mobileShopSubmenu" aria-expanded="false" aria-controls="mobileShopSubmenu">
                            <span>Shop</span>
                            <i class='bx bx-plus'></i>
                        </button>

                        <ul class="collapse" id="mobileShopSubmenu">
                            <?php
                            $mobile_menu_cats = $conn->query("SELECT name, slug FROM categories WHERE show_in_menu = 1 ORDER BY display_order ASC, name ASC");
                            if ($mobile_menu_cats && $mobile_menu_cats->num_rows > 0):
                                while ($cat = $mobile_menu_cats->fetch_assoc()):
                            ?>
                                    <li>
                                        <a href="products.php?category=<?= htmlspecialchars($cat['slug']) ?>">
                                            <?= htmlspecialchars($cat['name']) ?>
                                        </a>
                                    </li>
                            <?php
                                endwhile;
                            endif;
                            ?>
                        </ul>
                    </li>

                    <li><a href="products.php?filter=sale">Sale</a></li>
                    <!-- <li class="nav-item">
                        <a href="about.php" class="nav-link gradient-flow">
                            Ready-made Hampers
                        </a>
                    </li> -->
                    <li class="nav-item">
                        <a href="about.php">
                            About Us
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- End Mobile Offcanvas Menu -->

        <div class="xton-nav">
            <div class="container">
                <nav class="navbar navbar-expand-md navbar-light">
                    <a class="navbar-brand" href="index.php">
                        <img src="assets/img/logo.png" class="main-logo" alt="logo" style="height: 60px;">
                        <img src="assets/img/logo2.png" class="white-logo" alt="logo" style="height: 60px;">
                    </a>

                    <div class="collapse navbar-collapse mean-menu">
                        <ul class="navbar-nav">
                            <!-- === 1. Home Link === -->
                            <li class="nav-item"><a href="index.php" class="nav-link">Home</a></li>

                            <!-- === 2. New Arrivals Link === -->
                            <li class="nav-item">
                                <a href="products.php?filter=new-arrivals" class="nav-link">New Arrivals</a>
                            </li>

                            <!-- === 3. Best Sellers Link === -->
                            <li class="nav-item">
                                <a href="products.php?filter=best-sellers" class="nav-link">Best Sellers</a>
                            </li>

                            <!-- === 4. Shop Simple Dropdown (Single Column) === -->
                            <li class="nav-item shop-dropdown"><a href="products.php" class="nav-link">Shop <i class='bx bx-chevron-down'></i></a>
                                <ul class="dropdown-menu">
                                    <li class="dropdown-header-custom">
                                        <h6 class="submenu-title">Shop By Category</h6>
                                    </li>
                                    <!-- <li class="nav-item"><a href="products.php" class="nav-link">All Dresses</a></li> -->

                                    <?php
                                    // CORRECTED: Fetch categories marked to show in menu, regardless of homepage visibility
                                    $menu_cats = $conn->query("SELECT name, slug FROM categories WHERE show_in_menu = 1 ORDER BY display_order ASC, name ASC");

                                    if ($menu_cats->num_rows > 0):
                                        while ($cat = $menu_cats->fetch_assoc()):
                                    ?>
                                            <li class="nav-item">
                                                <a href="products.php?category=<?= htmlspecialchars($cat['slug']) ?>" class="nav-link">
                                                    <?= htmlspecialchars($cat['name']) ?>
                                                </a>
                                            </li>
                                    <?php
                                        endwhile;
                                    endif;
                                    ?>
                                </ul>
                            </li>

                            <!-- === 5. Sale Link === -->
                            <li class="nav-item">
                                <a href="products.php?filter=sale" class="nav-link">Sale</a>
                            </li>

                            <!-- === 6. About Us Link === -->
                            <!-- <li class="nav-item">
                                <a href="about.php" class="nav-link gradient-flow">
                                    Ready-made Hampers
                                </a>
                            </li> -->

                            <li class="nav-item"><a href="about.php" class="nav-link">About Us</a></li>

                        </ul>

                        <div class="others-option">

                            <div class="option-item">
                                <div class="search-btn-box">
                                    <i class="search-btn bx bx-search-alt"></i>
                                </div>
                            </div>

                            <div class="option-item">
                                <div class="cart-btn">
                                    <a href="cart.php"><i class='bx bx-shopping-bag'></i>
                                        <span>
                                            <?php
                                            $cart_count = 0;
                                            if (!empty($_SESSION['cart'])) {
                                                foreach ($_SESSION['cart'] as $item) {
                                                    $cart_count += $item['quantity'];
                                                }
                                            }
                                            echo $cart_count; ?>
                                        </span>
                                    </a>
                                </div>
                            </div>

                            <div class="option-item">
                                <div class="cart-btn">
                                    <a href="login.php" aria-label="User Login">
                                        <i class="bx bx-user"></i>
                                    </a>
                                </div>
                            </div>

                            <div class="option-item">
                                <div class="burger-menu" role="button" data-bs-toggle="modal" data-bs-target="#sidebarModal" aria-label="Menu">
                                    <span class="top-bar"></span>
                                    <span class="middle-bar"></span>
                                    <span class="bottom-bar"></span>
                                </div>
                            </div>

                        </div>

                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!-- End Navbar Area -->

    <!-- Start Sticky Navbar Area -->
    <div class="navbar-area header-sticky">

        <div class="xton-nav">
            <div class="container">
                <nav class="navbar navbar-expand-md navbar-light">
                    <a class="navbar-brand" href="index.php">
                        <img src="assets/img/logo.png" class="main-logo" alt="logo" style="height: 60px;">
                        <img src="assets/img/logo2.png" class="white-logo" alt="logo" style="height: 60px;">
                    </a>

                    <div class="collapse navbar-collapse mean-menu">
                        <ul class="navbar-nav">
                            <!-- === 1. Home Link === -->
                            <li class="nav-item"><a href="index.php" class="nav-link">Home</a></li>

                            <!-- === 2. New Arrivals Link === -->
                            <li class="nav-item">
                                <a href="products.php?filter=new-arrivals" class="nav-link">New Arrivals</a>
                            </li>

                            <!-- === 3. Best Sellers Link === -->
                            <li class="nav-item">
                                <a href="products.php?filter=best-sellers" class="nav-link">Best Sellers</a>
                            </li>

                            <!-- === 4. Shop Simple Dropdown (Single Column) === -->
                            <li class="nav-item shop-dropdown"><a href="products.php" class="nav-link">Shop <i class='bx bx-chevron-down'></i></a>
                                <ul class="dropdown-menu">
                                    <li class="dropdown-header-custom">
                                        <h6 class="submenu-title">Shop By Category</h6>
                                    </li>
                                    <!-- <li class="nav-item"><a href="products.php" class="nav-link">All Dresses</a></li> -->

                                    <?php
                                    // CORRECTED: Fetch categories marked to show in menu, regardless of homepage visibility
                                    $menu_cats = $conn->query("SELECT name, slug FROM categories WHERE show_in_menu = 1 ORDER BY display_order ASC, name ASC");

                                    if ($menu_cats->num_rows > 0):
                                        while ($cat = $menu_cats->fetch_assoc()):
                                    ?>
                                            <li class="nav-item">
                                                <a href="products.php?category=<?= htmlspecialchars($cat['slug']) ?>" class="nav-link">
                                                    <?= htmlspecialchars($cat['name']) ?>
                                                </a>
                                            </li>
                                    <?php
                                        endwhile;
                                    endif;
                                    ?>
                                </ul>
                            </li>

                            <!-- === 5. Sale Link === -->
                            <li class="nav-item">
                                <a href="products.php?filter=sale" class="nav-link">Sale</a>
                            </li>

                            <!-- === 6. About Us Link === -->
                            <!-- <li class="nav-item">
                                <a href="about.php" class="nav-link gradient-flow">
                                    Ready-made Hampers
                                </a>
                            </li> -->
                            <li class="nav-item"><a href="about.php" class="nav-link">About Us</a></li>
                        </ul>

                        <div class="others-option">
                            <div class="option-item">
                                <div class="search-btn-box">
                                    <i class="search-btn bx bx-search-alt"></i>
                                </div>
                            </div>

                            <div class="option-item">
                                <div class="cart-btn">
                                    <a href="cart.php"><i class='bx bx-shopping-bag'></i><span><?php
                                                                                                $cart_count = 0;
                                                                                                if (!empty($_SESSION['cart'])) {
                                                                                                    foreach ($_SESSION['cart'] as $item) {
                                                                                                        $cart_count += $item['quantity'];
                                                                                                    }
                                                                                                }
                                                                                                echo $cart_count; ?></span>
                                    </a>
                                </div>
                            </div>

                            <div class="option-item">
                                <div class="cart-btn">
                                    <a href="login.php"><i class='bx bx-user'></i></a>
                                </div>
                            </div>

                            <div class="option-item">
                                <div class="burger-menu" data-bs-toggle="modal" data-bs-target="#sidebarModal">
                                    <span class="top-bar"></span>
                                    <span class="middle-bar"></span>
                                    <span class="bottom-bar"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!-- End Header Area -->

    <!-- Start Search Overlay -->
    <div class="search-overlay">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="search-overlay-layer"></div>
                <div class="search-overlay-layer"></div>
                <div class="search-overlay-layer"></div>

                <div class="search-overlay-close">
                    <span class="search-overlay-close-line"></span>
                    <span class="search-overlay-close-line"></span>
                </div>

                <div class="search-overlay-form">
                    <!-- FIX: Added action, method, and input name -->
                    <form action="products.php" method="GET">
                        <input type="text" name="search" class="input-search" placeholder="Search for dresses or SKU..." required>
                        <button type="submit"><i class='bx bx-search-alt'></i></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Search Overlay -->