<!-- Start Gallery Area -->
<div class="instagram-area pt-70">
    <div class="container-fluid">
        <div class="instagram-title">
            <!-- Updated title to match a Lookbook/Collection feel -->
            <a href="javascript:void(0)"><i class='bx bx-images'></i> THE MISS.SOGASU LOOKBOOK</a>
        </div>

        <div class="instagram-slides owl-carousel owl-theme">
            <?php
            $gallery_res = $conn->query("SELECT * FROM gallery WHERE is_active = 1 ORDER BY display_order ASC LIMIT 15");
            if ($gallery_res->num_rows > 0):
                while ($photo = $gallery_res->fetch_assoc()):
            ?>
                    <div class="single-instagram-post sogasu-gallery-item">
                        <img src="<?= htmlspecialchars($photo['image_path']) ?>" alt="Gallery Image">

                        <!-- Simplified Overlay (No Icon) -->
                        <div class="gallery-reveal-overlay"></div>
                    </div>
            <?php
                endwhile;
            endif;
            ?>
        </div>
    </div>
</div>
<!-- End Gallery Area -->


<!-- Start Sidebar Modal -->
<div class="modal right fade sidebarModal" id="sidebarModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                <span aria-hidden="true"><i class='bx bx-x'></i></span>
            </button>

            <div class="modal-body">
                <div class="sidebar-about-content">
                    <h3>About Miss.Sogasu</h3>

                    <div class="about-the-store">
                        <p>Welcome to Miss.Sogasu, your destination for elegant and contemporary women's fashion. We celebrate style and sophistication in every dress we offer.</p>

                        <ul class="sidebar-contact-info">
                            <!-- Dynamic Address -->
                            <?php if (!empty($settings['contact_address'])): ?>
                                <li>
                                    <i class='bx bx-map'></i>
                                    <a href="javascript:void(0)"><?php echo htmlspecialchars($settings['contact_address']); ?></a>
                                </li>
                            <?php endif; ?>

                            <!-- Dynamic Phone -->
                            <?php if (!empty($settings['contact_phone'])): ?>
                                <li>
                                    <i class='bx bx-phone-call'></i>
                                    <a href="tel:<?php echo preg_replace('/[^0-9+]/', '', $settings['contact_phone']); ?>">
                                        <?php echo htmlspecialchars($settings['contact_phone']); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <!-- Dynamic Email -->
                            <?php if (!empty($settings['contact_email'])): ?>
                                <li>
                                    <i class='bx bx-envelope'></i>
                                    <a href="mailto:<?php echo htmlspecialchars($settings['contact_email']); ?>">
                                        <?php echo htmlspecialchars($settings['contact_email']); ?>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                    <!-- IMPORTANT: Remember to change these links to your actual social media profiles -->
                    <ul class="social-link">

                        <?php if (($settings['social_facebook_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_facebook'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-facebook'></i></a></li>
                        <?php endif; ?>

                        <?php if (($settings['social_instagram_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_instagram'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-instagram'></i></a></li>
                        <?php endif; ?>

                        <?php if (($settings['social_twitter_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_twitter'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-twitter'></i></a></li>
                        <?php endif; ?>

                        <!-- YouTube (Verified Class: bxl-youtube) -->
                        <?php if (($settings['social_youtube_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_youtube'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-youtube'></i></a></li>
                        <?php endif; ?>

                        <!-- Telegram (Verified Class: bxl-telegram) -->
                        <?php if (($settings['social_telegram_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_telegram'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-telegram'></i></a></li>
                        <?php endif; ?>

                    </ul>
                </div>

                <div class="sidebar-new-in-store">

                    <p>Discover our latest collection of must-have dresses, perfect for making a statement this season.</p>
                    <!-- The browser will correctly turn &apos; or &#039; into a beautiful ' -->

                    <a href="products.php" class="shop-now-btn">Shop Now</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Sidebar Modal -->

<!-- Start QuickView Modal Area -->
<div class="modal fade productsQuickView" id="productsQuickView" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                <span aria-hidden="true"><i class='bx bx-x'></i></span>
            </button>

            <div class="row align-items-center justify-content-center">

                <!-- IMAGE SECTION -->
                <div class="col-lg-6 col-md-6">
                    <div class="products-image">
                        <!-- Added ID: qv_main_image -->
                        <img id="qv_main_image" src="assets/img/placeholder.png" alt="Product Image">
                    </div>
                </div>

                <!-- CONTENT SECTION -->
                <div class="col-lg-6 col-md-6">
                    <div class="products-content">
                        <!-- Added ID: qv_product_name, qv_product_link -->
                        <h3><a href="#" id="qv_product_link"><span id="qv_product_name">Loading...</span></a></h3>

                        <!-- Added ID: qv_price_box -->
                        <div class="price" id="qv_price_box">
                            <!-- Dynamic Content -->
                        </div>

                        <ul class="products-info">
                            <!-- Added IDs -->
                            <li><span>SKU:</span> <a href="#" id="qv_sku">N/A</a></li>
                            <li><span>Availability:</span> <a href="#" id="qv_availability">In Stock</a></li>
                            <li><span>Category:</span> <a href="#" id="qv_category">General</a></li>
                        </ul>

                        <!-- COLOR SELECTION (Hidden by default) -->
                        <div class="products-color-switch" id="qv_color_section" style="display:none;">
                            <span>Color:</span>
                            <ul id="qv_color_list">
                                <!-- Dynamic Colors injected here -->
                            </ul>
                        </div>

                        <!-- SIZE SELECTION -->
                        <!-- <div class="products-size-wrapper" id="qv_size_section">
                            <h4>Size:</h4>
                            <ul id="qv_size_list">
                                Dynamic Sizes injected 
                            </ul>
                        </div> -->

                        <!-- SIZE SELECTION (Hidden visually, but kept for JS functionality) -->
                        <div class="products-size-wrapper d-none" id="qv_size_section">
                            <h4>Size:</h4>
                            <ul id="qv_size_list">
                                <!-- JS will still inject "Standard" here, but the user won't see it -->
                            </ul>
                        </div>

                        <div class="products-add-to-cart">
                            <div class="input-counter">
                                <span class="minus-btn"><i class='bx bx-minus'></i></span>
                                <input type="text" value="1" id="qv_qty">
                                <span class="plus-btn"><i class='bx bx-plus'></i></span>
                            </div>
                            <button type="button" class="default-btn" id="qv_add_to_cart" onclick="addToCartFromQuickView()">
                                Add to Cart
                            </button>
                        </div>

                        <a href="#" class="view-full-info" id="qv_view_full">View Full Product Details</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End QuickView Modal Area -->

<!-- Start Size Guide Modal Area -->
<div class="modal fade sizeGuideModal" id="sizeGuideModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                <span aria-hidden="true"><i class="bx bx-x"></i></span>
            </button>

            <div class="modal-sizeguide">
                <h3>Women's Dress Size Guide</h3>
                <p>This is an approximate conversion table to help you find your size. Measurements are in inches.</p>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Size</th>
                                <th>UK</th>
                                <th>US</th>
                                <th>EU</th>
                                <th>Bust (in)</th>
                                <th>Waist (in)</th>
                                <th>Hips (in)</th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr>
                                <td>XS</td>
                                <td>8</td>
                                <td>4</td>
                                <td>36</td>
                                <td>32-33"</td>
                                <td>25-26"</td>
                                <td>35-36"</td>
                            </tr>
                            <tr>
                                <td>S</td>
                                <td>10</td>
                                <td>6</td>
                                <td>38</td>
                                <td>34-35"</td>
                                <td>27-28"</td>
                                <td>37-38"</td>
                            </tr>
                            <tr>
                                <td>M</td>
                                <td>12</td>
                                <td>8</td>
                                <td>40</td>
                                <td>36-37"</td>
                                <td>29-30"</td>
                                <td>39-40"</td>
                            </tr>
                            <tr>
                                <td>L</td>
                                <td>14</td>
                                <td>10</td>
                                <td>42</td>
                                <td>38-39"</td>
                                <td>31-32"</td>
                                <td>41-42"</td>
                            </tr>
                            <tr>
                                <td>XL</td>
                                <td>16</td>
                                <td>12</td>
                                <td>44</td>
                                <td>40-41"</td>
                                <td>33-34"</td>
                                <td>43-44"</td>
                            </tr>
                            <tr>
                                <td>XXL</td>
                                <td>18</td>
                                <td>14</td>
                                <td>46</td>
                                <td>42-43"</td>
                                <td>35-36"</td>
                                <td>45-46"</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <p class="mt-3"><strong>How to Measure:</strong></p>
                <ul>
                    <li><strong>Bust:</strong> Measure around the fullest part of your bust.</li>
                    <li><strong>Waist:</strong> Measure around your natural waistline.</li>
                    <li><strong>Hips:</strong> Measure around the widest part of your hips.</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- End Size Guide Modal Area -->

<!-- Start Shipping Modal Area -->
<div class="modal fade productsShippingModal" id="productsShippingModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                <span aria-hidden="true"><i class='bx bx-x'></i></span>
            </button>

            <div class="shipping-content">
                <!-- 1. Shipping Section -->
                <div class="modal-section-header">
                    <h3><i class='bx bxs-truck'></i> Shipping Information</h3>
                </div>
                <ul class="modal-policy-list">
                    <li><strong>Free Shipping:</strong> Complimentary standard shipping on all orders delivered <strong>within India</strong>.</li>
                    <li><strong>International Shipping:</strong> For orders outside of India, please <strong>contact us directly</strong> via WhatsApp or Email for a custom quote.</li>
                    <li><strong>Prepaid Only:</strong> We are a 100% prepaid store. Cash on Delivery (COD) is not available.</li>
                    <li><strong>Dispatch:</strong> Orders are processed and dispatched within 1–2 business days.</li>
                    <li><strong>Delivery Time:</strong> Estimated 3–7 business days within India. International timelines vary by country.</li>
                    <li>For more details, see our <a href="shipping-policy.php" target="_blank">Shipping Policy</a>.</li>
                </ul>

                <hr class="modal-divider">

                <!-- 2. Returns Section -->
                <div class="modal-section-header">
                    <h3><i class='bx bx-refresh'></i> Returns & Exchange</h3>
                </div>
                <ul class="modal-policy-list">
                    <li><strong>Final Sale:</strong> We maintain a strict <strong>No Return & No Refund</strong> policy.</li>
                    <li><strong>Exchange Only:</strong> Permitted only for damaged items during transit or incorrect product delivery.</li>
                </ul>

                <!-- 3. Crucial Unboxing Callout -->
                <div class="modal-alert-box">
                    <h4><i class='bx bx-video-recording'></i> Mandatory Unboxing Video</h4>
                    <p>To claim an exchange, a continuous 360° unboxing video is required within <strong>24 hours</strong> of delivery. The video must show the sealed parcel from all sides before opening.</p>
                </div>

                <p class="text-center mt-3">
                    <small>For full details, please read our <a href="refund-policy.php" target="_blank">Refund & Exchange Policy</a>.</small>
                </p>
            </div>
        </div>
    </div>
</div>
<!-- End Shipping Modal Area -->

<!-- Start Products Filter Modal Area -->
<div class="modal left fade productsFilterModal" id="productsFilterModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                <span aria-hidden="true"><i class='bx bx-x'></i> Close</span>
            </button>

            <div class="modal-body">
                <div class="woocommerce-widget-area">

                    <!-- 1. Current Selection (Updated for Special Filters) -->
                    <?php if (!empty($category_slug) || !empty($special_filter) || !empty($size_filter) || (!empty($_GET['filter_by_price']))): ?>
                        <div class="woocommerce-widget filter-list-widget">
                            <h3 class="woocommerce-widget-title">Current Selection</h3>
                            <div class="selected-filters-wrap-list">
                                <ul>
                                    <!-- Special Filter Tag (New Arrivals / Best Sellers / Sale) -->
                                    <?php if (!empty($special_filter)):
                                        $params = $_GET;
                                        unset($params['filter']);
                                        unset($params['category']); // In case the bridge cleared it
                                        unset($params['page']);
                                        $label = ($special_filter == 'new-arrivals') ? 'New Arrivals' : (($special_filter == 'best-sellers') ? 'Best Sellers' : 'Sale');
                                    ?>
                                        <li><a href="products.php?<?= http_build_query($params) ?>"><i class='bx bx-x'></i> <?= $label ?></a></li>
                                    <?php endif; ?>

                                    <!-- Standard Category Tag -->
                                    <?php if (!empty($category_slug) && empty($special_filter)):
                                        $cat_name_modal = $conn->query("SELECT name FROM categories WHERE slug='$category_slug'")->fetch_assoc()['name'] ?? 'Category';
                                        $params = $_GET;
                                        unset($params['category']);
                                        unset($params['page']);
                                    ?>
                                        <li><a href="products.php?<?= http_build_query($params) ?>"><i class='bx bx-x'></i> <?= htmlspecialchars($cat_name_modal) ?></a></li>
                                    <?php endif; ?>

                                    <!-- Size Tag -->
                                    <?php if (!empty($size_filter)):
                                        $params = $_GET;
                                        unset($params['size']);
                                        unset($params['page']);
                                    ?>
                                        <li><a href="products.php?<?= http_build_query($params) ?>"><i class='bx bx-x'></i> Size: <?= htmlspecialchars($size_filter) ?></a></li>
                                    <?php endif; ?>

                                    <!-- Price Tag -->
                                    <?php if (!empty($_GET['filter_by_price'])):
                                        $params = $_GET;
                                        unset($params['filter_by_price']);
                                        unset($params['page']);
                                    ?>
                                        <li><a href="products.php?<?= http_build_query($params) ?>"><i class='bx bx-x'></i> Price: ₹<?= $price_min ?> - ₹<?= $price_max ?></a></li>
                                    <?php endif; ?>
                                </ul>
                                <a href="products.php" class="delete-selected-filters"><i class='bx bx-trash'></i> <span>Clear All</span></a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- 2. Categories (Dynamic with Logic Sync) -->
                    <div class="woocommerce-widget collections-list-widget">
                        <h3 class="woocommerce-widget-title">Categories</h3>
                        <ul class="collections-list-row">
                            <li class="<?= (empty($category_slug) && empty($special_filter)) ? 'active' : '' ?>"><a href="products.php">All Products</a></li>
                            <?php
                            $cats_modal = $conn->query("SELECT name, slug FROM categories ORDER BY name ASC");
                            while ($c = $cats_modal->fetch_assoc()):
                                // Map the bridge logic for the mobile modal
                                $is_active = ($category_slug == $c['slug']) || ($special_filter == $c['slug']);
                            ?>
                                <li class="<?= $is_active ? 'active' : '' ?>">
                                    <a href="products.php?category=<?= $c['slug'] ?>"><?= htmlspecialchars($c['name']) ?></a>
                                </li>
                            <?php endwhile; ?>
                        </ul>
                    </div>

                    <!-- 3. Price Filter (Preserving the filter parameter) -->
                    <div class="woocommerce-widget price-list-widget">
                        <h3 class="woocommerce-widget-title">Price</h3>
                        <div class="collection-filter-by-price">
                            <form action="products.php" method="GET">
                                <!-- PRESERVE FILTERS IN HIDDEN INPUTS -->
                                <?php if ($category_slug) echo '<input type="hidden" name="category" value="' . $category_slug . '">'; ?>
                                <?php if ($special_filter) echo '<input type="hidden" name="filter" value="' . $special_filter . '">'; ?>
                                <?php if ($size_filter) echo '<input type="hidden" name="size" value="' . $size_filter . '">'; ?>
                                <?php if ($search_query) echo '<input type="hidden" name="search" value="' . $search_query . '">'; ?>
                                <?php if ($sort_by != 'default') echo '<input type="hidden" name="sort_by" value="' . $sort_by . '">'; ?>

                                <input class="js-range-of-price" type="text"
                                    data-min="0" data-max="50000"
                                    name="filter_by_price"
                                    data-step="100" data-prefix="₹"
                                    value="<?= $price_min ?>;<?= $price_max ?>">

                                <button type="submit" class="default-btn btn-sm mt-3 w-100">Filter Price</button>
                            </form>
                        </div>
                    </div>

                    <!-- 4. Size Widget (Hardcoded - Automatically preserves all params via array_merge) -->
                    <!-- <div class="woocommerce-widget size-list-widget">
                        <h3 class="woocommerce-widget-title">Size</h3>
                        <ul class="size-list-row">
                            <?php
                            $hardcoded_sizes_modal = ['XS', 'S', 'M', 'L', 'XL', 'XXL'];
                            foreach ($hardcoded_sizes_modal as $s_name):
                                $link_params = array_merge($_GET, ['size' => $s_name]);
                                $link_params['page'] = 1;
                                $link = "products.php?" . http_build_query($link_params);
                            ?>
                                <li class="<?= ($size_filter == $s_name) ? 'active' : '' ?>">
                                    <a href="<?= $link ?>"><?= htmlspecialchars($s_name) ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div> -->

                    <!-- 5. Sidebar Banner (No change needed) -->
                    <div class="woocommerce-widget aside-trending-widget">
                        <div class="aside-trending-products">
                            <img src="assets/img/offer-bg2.jpg" alt="Special Offer Banner">
                            <div class="category">
                                <h3>Sale Collection</h3>
                                <span>Get Maximum Discount!</span>
                            </div>
                            <a href="products.php?filter=sale" class="link-btn"></a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Start Footer Area -->
<footer class="footer-area">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="single-footer-widget">
                    <!-- Logo -->
                    <div class="logo">
                        <a href="index.php">
                            <img src="assets/img/logo2.png" class="white-logo" alt="logo" style="height: 60px;">
                        </a>
                    </div>

                    <div class="about-the-store">

                        <div class="footer-newsletter-box">
                            <p><?php echo !empty($settings['site_description']) ? htmlspecialchars($settings['site_description']) : "Discover the latest trends in women's fashion. Miss.Sogasu offers elegant and stylish dresses for every occasion."; ?></p>

                            <ul class="social-link">

                                <?php if (($settings['social_facebook_status'] ?? '0') == '1'): ?>
                                    <li><a href="<?php echo htmlspecialchars($settings['social_facebook'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-facebook'></i></a></li>
                                <?php endif; ?>

                                <?php if (($settings['social_instagram_status'] ?? '0') == '1'): ?>
                                    <li><a href="<?php echo htmlspecialchars($settings['social_instagram'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-instagram'></i></a></li>
                                <?php endif; ?>

                                <?php if (($settings['social_twitter_status'] ?? '0') == '1'): ?>
                                    <li><a href="<?php echo htmlspecialchars($settings['social_twitter'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-twitter'></i></a></li>
                                <?php endif; ?>

                                <!-- YouTube (Verified Class: bxl-youtube) -->
                                <?php if (($settings['social_youtube_status'] ?? '0') == '1'): ?>
                                    <li><a href="<?php echo htmlspecialchars($settings['social_youtube'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-youtube'></i></a></li>
                                <?php endif; ?>

                                <!-- Telegram (Verified Class: bxl-telegram) -->
                                <?php if (($settings['social_telegram_status'] ?? '0') == '1'): ?>
                                    <li><a href="<?php echo htmlspecialchars($settings['social_telegram'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-telegram'></i></a></li>
                                <?php endif; ?>

                            </ul>
                            <br>
                        </div>

                    </div>



                </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="single-footer-widget pl-4">
                    <h3>Quick Links</h3>

                    <ul class="quick-links">
                        <li><a href="home.php">Home</a></li>
                        <li><a href="about.php">About Us</a></li>

                        <li><a href="contact.php">Contact Us</a></li>
                        <li><a href="faqs.php">FAQ's</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="single-footer-widget">
                    <h3>Legal</h3>

                    <ul class="customer-support">
                        <li><a href="terms-and-conditions.php">Terms and Conditions</a></li>
                        <li><a href="privacy-policy.php">Privacy Policy</a></li>
                        <li><a href="refund-policy.php">Refund Policy</a></li>
                        <li><a href="shipping-policy.php">Shipping Policy</a></li>

                    </ul>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 col-sm-6">
                <div class="single-footer-widget">
                    <h3>Address</h3>

                    <ul class="customer-support">
                        <?php if (!empty($settings['contact_address'])): ?>
                            <li>
                                <i class='bx bx-map'></i>
                                <a href="javascript:void(0)"><?php echo htmlspecialchars($settings['contact_address']); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (!empty($settings['contact_email'])): ?>
                            <li>
                                <i class='bx bx-envelope'></i>
                                <a href="mailto:<?php echo htmlspecialchars($settings['contact_email']); ?>">
                                    <?php echo htmlspecialchars($settings['contact_email']); ?>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (!empty($settings['contact_phone'])): ?>
                            <li>
                                <i class='bx bx-phone-call'></i>
                                <a href="tel:<?php echo preg_replace('/[^0-9+]/', '', $settings['contact_phone']); ?>">
                                    <?php echo htmlspecialchars($settings['contact_phone']); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>

        </div>

        <div class="footer-bottom-area">
            <!-- This container uses Flexbox for the new layout -->
            <!-- flex-column (mobile), flex-lg-row (desktop) -->
            <!-- justify-content-lg-between spreads items out on desktop -->
            <div class="d-flex flex-column flex-lg-row justify-content-lg-between align-items-center">

                <!-- 1. Copyright Info (stacks first on mobile) -->
                <div class="mb-2 mb-lg-0">
                    <!-- The PHP date("Y") function automatically keeps the year current -->
                    <p>&copy; <?php echo date("Y"); ?> Miss.Sogasu. All Rights Reserved.</p>
                </div>

                <!-- 3. Designer Credit (stacks third on mobile) -->
                <div>
                    <p>Designed and Developed by <a href="https://www.dizisolutions.in" target="_blank">Dizi Solutions</a></p>
                </div>

                <!-- 2. Payment Icons (stacks second on mobile) -->
                <div class="mb-2 mb-lg-0">
                    <ul class="payment-types">
                        <li><a href="javascript:void(0)"><img src="assets/img/payment/visa.png" alt="image"></a></li>
                        <li><a href="javascript:void(0)"><img src="assets/img/payment/mastercard.png" alt="image"></a></li>
                        <li><a href="javascript:void(0)"><img src="assets/img/payment/mastercard2.png" alt="image"></a></li>
                        <li><a href="javascript:void(0)"><img src="assets/img/payment/visa2.png" alt="image"></a></li>
                        <li><a href="javascript:void(0)"><img src="assets/img/payment/expresscard.png" alt="image"></a></li>
                    </ul>
                </div>



            </div>
        </div>
    </div>

    <div class="lines">
        <div class="line"></div>
        <div class="line"></div>
        <div class="line"></div>
    </div>
</footer>
<!-- End Footer Area -->

<div class="go-top"><i class='bx bx-up-arrow-alt'></i></div>

<!-- Links of JS files -->
<script src="assets/js/jquery.min.js"></script>
<!-- <script src="assets/js/popper.min.js"></script> -->
<script src="assets/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/owl.carousel.min.js"></script>
<script src="assets/js/magnific-popup.min.js"></script>
<script src="assets/js/parallax.min.js"></script>
<script src="assets/js/rangeSlider.min.js"></script>
<script src="assets/js/nice-select.min.js"></script>
<script src="assets/js/meanmenu.min.js"></script>
<script src="assets/js/isotope.pkgd.min.js"></script>
<script src="assets/js/slick.min.js"></script>
<script src="assets/js/sticky-sidebar.min.js"></script>
<script src="assets/js/wow.min.js"></script>
<script src="assets/js/form-validator.min.js"></script>
<script src="assets/js/contact-form-script.js"></script>
<script src="assets/js/ajaxchimp.min.js"></script>
<script src="assets/js/main.js"></script>
</body>

</html>