<?php
/**
 * Frontend Database Configuration and Connection
 * Path: includes/db.php
 */

// --- Database Credentials ---
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'miss_sogasu_db');

// --- Create Connection ---
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// --- Check Connection ---
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set charset to handle special characters
$conn->set_charset("utf8mb4");

// --- Frontend Session Management ---
// We use a different session name to keep customer and admin logins separate
session_name('MISS-SOGASU_FRONTEND_SESSION');

// Start the session if it's not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// --- Global Helper Function ---
// A simple sanitize function for frontend inputs
// --- Update this function in includes/db.php ---
function sanitize_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    return $data;
}

?>