<?php
require_once 'admin/includes/db_config.php';

if (isset($_POST['id'])) {
    $id = (int)$_POST['id'];

    // 1. Get Base Product Info with DEFAULT COLOR
    $query = "SELECT p.*, c.name as category_name, p.default_color_group
              FROM products p 
              LEFT JOIN categories c ON p.category_id = c.id 
              WHERE p.id = $id AND p.is_active = 1 LIMIT 1";
    $result = $conn->query($query);

    if ($result->num_rows > 0) {
        $product = $result->fetch_assoc();
        $default_color = $product['default_color_group'] ?: 'Standard';

        // 2. Get Images (Grouped by Color) - Only primary images for quick view
        $images = [];
        $img_res = $conn->query("SELECT * FROM product_images WHERE product_id = $id ORDER BY is_primary DESC");
        while ($row = $img_res->fetch_assoc()) {
            $grp = $row['color_group'] ?: 'Standard';
            $images[$grp][] = [
                'path' => $row['image_path'],
                'is_primary' => $row['is_primary']
            ];
        }

        // 3. Get Sizes (Grouped by Color)
        $sizes = [];
        $size_res = $conn->query("SELECT * FROM product_sizes WHERE product_id = $id ORDER BY FIELD(size, 'XS', 'S', 'M', 'L', 'XL', 'XXL')");
        while ($row = $size_res->fetch_assoc()) {
            $grp = $row['color_group'] ?: 'Standard';
$sizes[$grp][] = [
    'size' => $row['size'],
    'stock' => (int)$row['stock_quantity'] // Cast to integer
];
        }

        // 4. Get primary image for each color
        $primary_images = [];
        foreach ($images as $color => $color_images) {
            // Find primary image
            foreach ($color_images as $img) {
                if ($img['is_primary'] == 1) {
                    $primary_images[$color] = $img['path'];
                    break;
                }
            }
            // If no primary found, use first image
           if (!isset($primary_images[$color]) && count($color_images) > 0) {
    $primary_images[$color] = $color_images[0]['path'];
} elseif (!isset($primary_images[$color])) {
    $primary_images[$color] = '../assets/img/placeholder.png'; // Use correct path
}
        }

        // 5. Determine available color groups
        $colors = array_unique(array_merge(array_keys($images), array_keys($sizes)));
        $variations = [];

        foreach ($colors as $color) {
            $variations[$color] = [
                'primary_image' => $primary_images[$color] ?? 'assets/img/placeholder.png',
                'images' => array_column($images[$color] ?? [], 'path'),
                'sizes' => $sizes[$color] ?? []
            ];
        }

        echo json_encode([
            'status' => 'success',
            'product' => $product,
            'default_color' => $default_color,
            'variations' => $variations
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Product not found']);
    }
}