<?php
require_once 'includes/db.php';

if (isset($_SESSION['user_id'])) {
    header("location: user-profile.php");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['email'])) {
    $email = trim(sanitize_input($_POST['email']));
    
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows == 1) {
        $user_id = $result->fetch_assoc()['id'];
        $token = bin2hex(random_bytes(32)); 
        $expires_at = date('Y-m-d H:i:s', strtotime('+1 hour'));
        
        $stmt_update = $conn->prepare("UPDATE users SET reset_token = ?, token_expires_at = ? WHERE id = ?");
        $stmt_update->bind_param("ssi", $token, $expires_at, $user_id);
        $stmt_update->execute();
        
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $domain = $_SERVER['HTTP_HOST'];
        $reset_link = "{$protocol}://{$domain}/reset-password.php?token=" . $token;
        
        // --- TRIGGER BACKGROUND EMAIL ---
        $_SESSION['trigger_reset_email'] = true;
        $_SESSION['reset_email'] = $email;
        $_SESSION['reset_link'] = $reset_link;
    }
    
    $_SESSION['flash_msg'] = ["type"=>"success", "text"=>"If an account with that email exists, a reset link has been sent. Please check your inbox."];
    header("Location: forgot-password.php");
    exit;
}

$page_title = "Forgot Password";
include 'includes/header.php';
?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Reset Password</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Forgot Password</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Forgot Password Area -->
<section class="login-area ptb-100">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-8">
                <div class="login-content">
                    <h2>Forgot Your Password?</h2>
                    <p class="text-muted mb-4">No problem. Enter your email address below and we will send you a link to create a new password.</p>

                    <!-- Flash Message Display -->
                    <?php if(isset($_SESSION['flash_msg'])): ?>
                        <div class="alert alert-<?= $_SESSION['flash_msg']['type'] ?>">
                            <?= $_SESSION['flash_msg']['text'] ?>
                        </div>
                        <?php unset($_SESSION['flash_msg']); ?>
                    <?php endif; ?>

                    <form class="login-form" method="POST" action="forgot-password.php">
                        <div class="form-group">
                            <label>Email Address</label>
                            <input type="email" name="email" class="form-control" placeholder="Enter your registered email" required>
                        </div>

                        <button type="submit" class="default-btn">Send Reset Link</button>
                        
                        <div class="text-center mt-3">
                            <p>Remembered your password? <a href="login.php">Log In</a></p>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Forgot Password Area -->

<script>
document.addEventListener('DOMContentLoaded', function() {
    <?php if (isset($_SESSION['trigger_reset_email']) && $_SESSION['trigger_reset_email'] === true): ?>
        fetch('api/send-reset.php')
            .then(response => response.json())
            .then(data => { console.log('Reset Email Processed'); })
            .catch(error => console.error('Error:', error));
    <?php endif; ?>
});
</script>

<?php include 'includes/footer.php'; ?>