<?php include 'includes/header.php'; ?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Contact Us</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Contact Us</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Contact Area -->
<section class="contact-area ptb-100">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-5 col-md-12">
                <div class="contact-info">
                    <h3>Here to Help</h3>
                    <p>Have a question? You may find an answer in our <a href="faqs.php">FAQs</a>, but you can also contact us directly.</p>

                    <ul class="contact-list">
                        <!-- Dynamic Location -->
                        <?php if (!empty($settings['contact_address'])): ?>
                            <li>
                                <i class='bx bx-map'></i> Location: <br> 
                                <a href="https://www.google.com/maps/search/<?php echo urlencode($settings['contact_address']); ?>" target="_blank">
                                    <?php echo htmlspecialchars($settings['contact_address']); ?>
                                </a>
                            </li> <br>
                        <?php endif; ?>

                        <!-- Dynamic Phone -->
                        <?php if (!empty($settings['contact_phone'])): ?>
                            <li>
                                <i class='bx bx-phone-call'></i> Call Us: <br> 
                                <a href="tel:<?php echo preg_replace('/[^0-9+]/', '', $settings['contact_phone']); ?>">
                                    <?php echo htmlspecialchars($settings['contact_phone']); ?>
                                </a>
                            </li> <br>
                        <?php endif; ?>

                        <!-- Dynamic Email -->
                        <?php if (!empty($settings['contact_email'])): ?>
                            <li>
                                <i class='bx bx-envelope'></i> Email Us: <br> 
                                <a href="mailto:<?php echo htmlspecialchars($settings['contact_email']); ?>">
                                    <?php echo htmlspecialchars($settings['contact_email']); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>

                    <!-- <h3>Opening Hours:</h3>
                    <ul class="opening-hours">
                        <li><span>Monday - Friday:</span> 10:00 AM - 6:00 PM</li>
                        <li><span>Saturday:</span> 11:00 AM - 4:00 PM</li>
                        <li><span>Sunday:</span> Closed</li>
                    </ul> -->

                    <h3>Follow Us:</h3>
                    <ul class="social">

                        <?php if (($settings['social_facebook_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_facebook'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-facebook'></i></a></li>
                        <?php endif; ?>

                        <?php if (($settings['social_instagram_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_instagram'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-instagram'></i></a></li>
                        <?php endif; ?>

                        <?php if (($settings['social_twitter_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_twitter'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-twitter'></i></a></li>
                        <?php endif; ?>

                        <!-- YouTube (Verified Class: bxl-youtube) -->
                        <?php if (($settings['social_youtube_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_youtube'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-youtube'></i></a></li>
                        <?php endif; ?>

                        <!-- Telegram (Verified Class: bxl-telegram) -->
                        <?php if (($settings['social_telegram_status'] ?? '0') == '1'): ?>
                            <li><a href="<?php echo htmlspecialchars($settings['social_telegram'] ?? '#'); ?>" class="d-block" target="_blank"><i class='bx bxl-telegram'></i></a></li>
                        <?php endif; ?>

                    </ul>
                </div>
            </div>

            <div class="col-lg-7 col-md-12">
                <div class="contact-form">
                    <h3>Drop Us A Line</h3>
                    <p>We're happy to answer any questions you have. Just send us a message in the form below, and we'll get back to you as soon as possible.</p>

                    <form id="contactForm">
                        <div class="row justify-content-center">
                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label>Name <span>*</span></label>
                                    <input type="text" name="name" id="name" class="form-control" required data-error="Please enter your name" placeholder="Your name">
                                    <div class="help-block with-errors"></div>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label>Email <span>*</span></label>
                                    <input type="email" name="email" id="email" class="form-control" required data-error="Please enter your email" placeholder="Your email address">
                                    <div class="help-block with-errors"></div>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label>Phone Number <span>*</span></label>
                                    <input type="text" name="phone_number" id="phone_number" class="form-control" required data-error="Please enter your phone number" placeholder="Your phone number">
                                    <div class="help-block with-errors"></div>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6">
                                <div class="form-group">
                                    <label>Subject <span>*</span></label>
                                    <input type="text" name="subject" id="subject" class="form-control" required data-error="Please enter your subject" placeholder="Your subject">
                                    <div class="help-block with-errors"></div>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12">
                                <div class="form-group">
                                    <label>Your Message <span>*</span></label>
                                    <textarea name="message" id="message" cols="30" rows="5" required data-error="Please enter your message" class="form-control" placeholder="Write your message..."></textarea>
                                    <div class="help-block with-errors"></div>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12">
                                <button type="submit" class="default-btn">Send Message</button>
                                <div id="msgSubmit" class="h3 text-center hidden"></div>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Contact Area -->

<!-- Map Section -->
<div id="map" class="map-area">
    <?php 
    if (!empty($settings['map_iframe'])) {
        // Fetch the value from admin settings
        $map_data = $settings['map_iframe'];

        // Logic: If the user pasted the whole <iframe> tag, we show it.
        // If they just pasted the link, we wrap it in a clean iframe.
        if (strpos($map_data, '<iframe') !== false) {
            echo $map_data; 
        } else {
            ?>
            <iframe 
                src="<?php echo htmlspecialchars($map_data); ?>" 
                width="100%" 
                height="450" 
                style="border:0;" 
                allowfullscreen="" 
                loading="lazy" 
                referrerpolicy="no-referrer-when-downgrade">
            </iframe>
            <?php
        }
    } else {
        // Fallback message if no map is provided in Admin
        echo '<div class="container text-center py-5"><h4>Map location not set.</h4></div>';
    }
    ?>
</div>
<!-- End Map Section -->

<?php include 'includes/footer.php'; ?>