<?php
require_once 'includes/db.php';

// --- ADD THIS BLOCK ---
// Fetch active, valid coupons to display in the slider
$available_coupons_sql = "SELECT c.code, c.discount_type, c.discount_value, cat.name as category_name, c.min_spend, c.expiry_date
                          FROM coupons c
                          LEFT JOIN categories cat ON c.category_id = cat.id
                          WHERE c.is_active = 1
                          AND (c.expiry_date IS NULL OR c.expiry_date >= CURDATE())
                          AND (c.usage_limit = 0 OR c.used_count < c.usage_limit)
                          ORDER BY c.created_at DESC LIMIT 5";
$coupons_result = $conn->query($available_coupons_sql);
// --- END OF BLOCK ---

// --- CHECKOUT CONTEXT LOGIC ---

// 1. Case: Fresh "Buy It Now" Request (URL params p_id, qty, size, color exist)
if (isset($_GET['buy_now']) && $_GET['buy_now'] == 1 && isset($_GET['p_id'])) {
    $_SESSION['checkout_items'] = [];
    $_SESSION['is_buy_now'] = true;

    $p_id = (int)$_GET['p_id'];
    $qty  = (int)$_GET['qty'];
    $size = sanitize_input($_GET['size']);
    $color = sanitize_input($_GET['color']);

    $stmt = $conn->prepare("SELECT p.*, 
        (SELECT image_path FROM product_images pi 
         WHERE pi.product_id = p.id 
         AND pi.color_group = ? 
         AND pi.is_primary = 1 LIMIT 1) as main_image
        FROM products p WHERE p.id = ? AND p.is_active = 1");
    $stmt->bind_param("si", $color, $p_id);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows > 0) {
        $product = $res->fetch_assoc();
        $stock_check = $conn->query("SELECT stock_quantity FROM product_sizes WHERE product_id = $p_id AND size = '$size' AND color_group = '$color'");
        $stock = ($stock_check->num_rows > 0) ? $stock_check->fetch_assoc()['stock_quantity'] : 0;

        if ($qty <= $stock) {
            $cart_key = $p_id . '_' . $color . '_' . $size;
            $price = ($product['sale_price'] > 0) ? $product['sale_price'] : $product['price'];
            $image = !empty($product['main_image']) ? $product['main_image'] : 'assets/img/placeholder.png';

            $_SESSION['checkout_items'][$cart_key] = [
                'product_id' => $p_id,
                'name' => $product['name'],
                'slug' => $product['slug'],
                'color' => $color,
                'size' => $size,
                'quantity' => $qty,
                'price' => $price,
                'image' => $image
            ];
        } else {
            echo "<script>alert('Selected quantity not available.'); window.location.href='product-details.php?slug={$product['slug']}';</script>";
            exit;
        }
    }
}
// 2. Case: Returning from Login (NO URL params, but SESSION flag is still TRUE)
elseif (isset($_SESSION['is_buy_now']) && $_SESSION['is_buy_now'] === true && !empty($_SESSION['checkout_items'])) {
    // Keep existing session data (don't overwrite with cart)
}
// 3. Case: Standard Cart Checkout (Default)
else {
    $_SESSION['is_buy_now'] = false;
    $_SESSION['checkout_items'] = [];

    if (empty($_SESSION['cart'])) {
        header("Location: cart.php");
        exit;
    }
    // Context is now exactly what is in the main cart
    $_SESSION['checkout_items'] = $_SESSION['cart'];
}

// From here on, we ONLY use $_SESSION['checkout_items']
$checkout_items = $_SESSION['checkout_items'];

// 3. Calculate Totals based on checkout_items
$subtotal = 0;
foreach ($checkout_items as $item) {
    $subtotal += $item['price'] * $item['quantity'];
}

// Logic to handle coupons 
$discount = 0;
if (isset($_SESSION['applied_coupon'])) {
    $discount = $_SESSION['applied_coupon']['discount'];
}

$total = $subtotal - $discount;

// ... (Rest of your existing code: Fetch User Data, Header, etc.)

$user_id = $_SESSION['user_id'] ?? null;
$user_data = null;
$saved_addresses = [];

// 2. Fetch User & Address Data if logged in
$address_js_data = []; // For the JS lookup
if ($user_id) {
    $user_res = $conn->query("SELECT * FROM users WHERE id = $user_id");
    $user_data = $user_res->fetch_assoc();

    $addr_res = $conn->query("SELECT * FROM user_addresses WHERE user_id = $user_id");
    while ($row = $addr_res->fetch_assoc()) {
        $saved_addresses[] = $row;
        // Store in array for JS (Keyed by ID)
        $address_js_data[$row['id']] = $row;
    }
}

include 'includes/header.php';
?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Checkout</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Checkout</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Checkout Area -->
<section class="checkout-area ptb-100">
    <div class="container">
        <?php if (!isset($_SESSION['user_id'])): ?>
            <div class="user-actions">
                <i class='bx bx-log-in'></i>
                <span>Returning customer? <a href="login.php?redirect=checkout">Click here to login</a></span>
            </div>
        <?php endif; ?>

        <form id="checkoutForm">
            <div class="row justify-content-center">
                <!-- ================================================== -->
                <!-- =========== BILLING / SHIPPING DETAILS =========== -->
                <!-- ================================================== -->
                <div class="col-lg-7 col-md-12">
                    <div class="billing-details">
                        <h3 class="title">Billing & Shipping Details</h3>

                        <?php if ($user_id && !empty($saved_addresses)): ?>
                            <!-- Address Picker -->
                            <div class="form-group mb-4">
                                <label class="fw-bold text-primary"><i class='bx bxs-map-pin'></i> Deliver to a Saved Address?</label>
                                <select class="form-control" id="addressPicker">
                                    <option value="new">-- Use a Different Address --</option>
                                    <?php foreach ($saved_addresses as $addr): ?>
                                        <option value="<?= $addr['id'] ?>">
                                            <?= htmlspecialchars($addr['full_name']) ?> - <?= htmlspecialchars($addr['address_line_1']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <hr>
                        <?php endif; ?>

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group"><label>Full Name <span class="required">*</span></label>
                                    <input type="text" name="full_name" id="checkout_name" class="form-control" value="<?= htmlspecialchars($user_data['full_name'] ?? '') ?>" required>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group"><label>Email Address <span class="required">*</span></label>
                                    <input type="email" name="email" id="checkout_email" class="form-control" value="<?= htmlspecialchars($user_data['email'] ?? '') ?>" required>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group"><label>Phone <span class="required">*</span></label>
                                    <input type="text" name="phone" id="checkout_phone" class="form-control" value="<?= htmlspecialchars($user_data['phone'] ?? '') ?>" required>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group"><label>House No. / Building / Street <span class="required">*</span></label>
                                    <input type="text" name="address_1" id="checkout_addr1" class="form-control" placeholder="e.g. 123, Fashion Street" required>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group"><label>Area / Colony / Landmark <span class="required">*</span></label>
                                    <input type="text" name="address_2" id="checkout_addr2" class="form-control" placeholder="e.g. Near City Park">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group"><label>Town / City <span class="required">*</span></label>
                                    <input type="text" name="city" id="checkout_city" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group"><label>Pincode <span class="required">*</span></label>
                                    <input type="text" name="pincode" id="checkout_pincode" class="form-control" maxlength="6" required>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group"><label>State <span class="required">*</span></label>
                                    <input type="text" name="state" id="checkout_state" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group"><textarea name="notes" id="notes" cols="30" rows="4" placeholder="Notes about your order (e.g. door code)" class="form-control"></textarea></div>
                            </div>
                        </div>
                        <!-- Logistics Highlights (Industry Standard) -->
                        <div class="product-logistics-highlights mt-4">
                            <ul class="logistics-list">
                                <li>
                                    <i class='bx bxs-truck'></i>
                                    <span><strong>Free Shipping</strong> across India</span>
                                </li>
                                <li>
                                    <i class='bx bx-world'></i>
                                    <span>For <strong>International Orders</strong> Please <a href="contact.php" class="text-link"> Contact Us </a>Directly</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- ================================================== -->
                <!-- =============== YOUR ORDER SUMMARY =============== -->
                <!-- ================================================== -->
                <div class="col-lg-5 col-md-12">
                    <div class="order-details">
                        <h3 class="title">Your Order</h3>
                        <!-- === ADD THIS ENTIRE SECTION === -->
                        <div class="coupon-area mb-4">
                            <h5>Have a Coupon?</h5>

                            <?php if (isset($_SESSION['user_id'])): ?>
                                <div class="input-group">
                                    <!-- FIX: Value attribute added to keep the code in the box -->
                                    <input type="text" class="form-control" id="couponCode"
                                        placeholder="Enter coupon code"
                                        value="<?= $_SESSION['applied_coupon']['code'] ?? '' ?>">
                                    <button type="button" class="optional-btn" style="margin-left: unset;" onclick="applyCoupon()">Apply</button>
                                </div>
                            <?php else: ?>
                                <div class="input-group login-lock-group">
                                    <input type="text" class="form-control" placeholder="Login to use coupons" disabled>
                                    <a href="login.php?redirect=checkout" class="default-btn" style="margin-left: unset;">Login</a>
                                </div>

                            <?php endif; ?>

                            <div id="couponMessage" class="mt-2">
                                <?php if (isset($_SESSION['coupon_success_msg'])): ?>
                                    <div class="alert alert-success alert-dismissible fade show">
                                        <?= $_SESSION['coupon_success_msg'];
                                        unset($_SESSION['coupon_success_msg']); ?>
                                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Coupon Slider -->
                            <?php if ($coupons_result->num_rows > 0): ?>
                                <div class="available-coupons-slider owl-carousel owl-theme mt-3">
                                    <?php while ($coupon = $coupons_result->fetch_assoc()): ?>
                                        <?php
                                        // Formatting Discount
                                        $discount_text = ($coupon['discount_type'] == 'percentage')
                                            ? '<strong>' . (float)$coupon['discount_value'] . '%</strong> OFF'
                                            : '<strong>₹' . number_format($coupon['discount_value']) . '</strong> OFF';

                                        // Formatting Applicability
                                        $on_text = ($coupon['category_name'])
                                            ? 'On ' . htmlspecialchars($coupon['category_name'])
                                            : 'On All Orders';
                                        ?>

                                        <div class="coupon-ticket">
                                            <div class="coupon-offer">🎉 <?= $discount_text ?></div>

                                            <div class="coupon-body">
                                                <div class="coupon-code-label">CLICK CODE TO APPLY</div>

                                                <!-- Only this box is clickable -->
                                                <div class="coupon-code"
                                                    onclick="selectCoupon('<?= htmlspecialchars($coupon['code']) ?>')"
                                                    title="Apply this code">
                                                    <?= htmlspecialchars($coupon['code']) ?>
                                                </div>
                                            </div>

                                            <div class="coupon-footer">
                                                <div>🛍️ <?= $on_text ?></div>

                                                <!-- NEW: Minimum Spend & Expiry Display -->
                                                <div class="coupon-details mt-1" style="font-size: 11px; color: #888;">
                                                    <?php if ($coupon['min_spend'] > 0): ?>
                                                        <span>Min. Spend: <strong>₹<?= number_format($coupon['min_spend']) ?></strong></span>
                                                    <?php endif; ?>

                                                    <?php if ($coupon['min_spend'] > 0 && $coupon['expiry_date']): ?>
                                                        <span class="mx-1">•</span>
                                                    <?php endif; ?>

                                                    <?php if ($coupon['expiry_date']): ?>
                                                        <span>Valid till: <strong><?= date('d M', strtotime($coupon['expiry_date'])) ?></strong></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <!-- === END OF SECTION TO ADD === -->
                        <div class="order-table table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col">Product</th>
                                        <th scope="col">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($checkout_items as $item): ?>
                                        <?php
                                        // 1. Create an array of parameters for the URL
                                        $url_params = [
                                            'slug'  => $item['slug'],
                                            'color' => $item['color'],
                                            'size'  => $item['size']
                                        ];
                                        // 2. Build the secure, URL-encoded link
                                        $product_variant_url = 'product-details.php?' . http_build_query($url_params);
                                        ?>
                                        <tr>
                                            <td class="product-name">
                                                <!-- 3. Use the new URL in the href attribute -->
                                                <a href="<?= htmlspecialchars($product_variant_url) ?>" class="d-flex align-items-center text-dark text-decoration-none">
                                                    <img src="<?= htmlspecialchars($item['image']) ?>"
                                                        alt="<?= htmlspecialchars($item['name']) ?>"
                                                        style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px; margin-right: 15px;">
                                                    <div>
                                                        <?= htmlspecialchars($item['name']) ?>
                                                        <div class="small text-muted"><strong>Color : </strong> <?= htmlspecialchars($item['color']) ?> <br> <strong>Size:</strong> <?= htmlspecialchars($item['size']) ?></div>
                                                        <span class="product-quantity">x <?= $item['quantity'] ?></span>
                                                    </div>
                                                </a>
                                            </td>
                                            <td class="product-total">
                                                <span class="subtotal-amount">₹<?= number_format($item['price'] * $item['quantity'], 2) ?></span>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>

                                    <!-- Totals Section -->
                                    <tr class="order-subtotal">
                                        <td><b>Cart Subtotal</b></td>
                                        <td class="order-subtotal-price">
                                            <span class="order-subtotal-amount">₹<?= number_format($subtotal, 2) ?></span>
                                        </td>
                                    </tr>

                                    <?php if ($discount > 0): ?>
                                        <tr class="order-discount">
                                            <td>
                                                <b>Discount (<?= htmlspecialchars($_SESSION['applied_coupon']['code']) ?>)</b>
                                                <!-- Professional Remove Link -->
                                                <a href="javascript:void(0)" id="removeCoupon" class="text-danger ms-2" style="font-size: 11px; text-decoration: underline;">(Remove)</a>
                                            </td>
                                            <td class="text-danger">
                                                <span>-₹<?= number_format($discount, 2) ?></span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>

                                    <tr class="order-shipping">
                                        <td><b>Shipping (within India)</b></td>
                                        <td class="shipping-price"><span>Free</span></td>
                                    </tr>
                                    <tr class="total-price">
                                        <td><strong>Order Total</strong></td>
                                        <td class="product-subtotal">
                                            <span class="subtotal-amount text-primary"><strong>₹<?= number_format($total, 2) ?></strong></span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="payment-box">
                            <div class="payment-method">
                                <p>
                                    <input type="radio" id="payment-card" name="payment_method" value="card" checked>
                                    <label for="payment-card">Credit / Debit Card / UPI</label>
                                    <small class="text-muted">Safe and secure payment via Razorpay. All major cards and UPI apps supported.</small>
                                </p>
                            </div>
                            <!-- The button remains the same -->
                            <button type="submit" id="placeOrderBtn" class="default-btn">Place Order</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
<!-- End Checkout Area -->


<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Address picker logic (remains the same)
        const savedAddresses = <?= json_encode($address_js_data) ?>;
        const picker = document.getElementById('addressPicker');
        if (picker) {
            // We use jQuery here because nice-select blocks standard JS 'change' events
            $(picker).on('change', function() {
                const addrId = $(this).val();

                if (addrId === "new") {
                    // Keep name/email/phone but clear address lines
                    document.getElementById('checkout_addr1').value = '';
                    document.getElementById('checkout_addr2').value = '';
                    document.getElementById('checkout_city').value = '';
                    document.getElementById('checkout_state').value = '';
                    document.getElementById('checkout_pincode').value = '';
                } else if (savedAddresses[addrId]) {
                    const data = savedAddresses[addrId];
                    // Fill all fields
                    document.getElementById('checkout_name').value = data.full_name;
                    document.getElementById('checkout_phone').value = data.phone;
                    document.getElementById('checkout_addr1').value = data.address_line_1;
                    document.getElementById('checkout_addr2').value = data.address_line_2;
                    document.getElementById('checkout_city').value = data.city;
                    document.getElementById('checkout_state').value = data.state;
                    document.getElementById('checkout_pincode').value = data.pincode;
                }
            });
        }

        // --- RAZORPAY INTEGRATION ---
        const placeOrderBtn = document.getElementById('placeOrderBtn');
        const checkoutForm = document.getElementById('checkoutForm');

        placeOrderBtn.addEventListener('click', function(e) {
            e.preventDefault();

            // 1. FORM VALIDATION: Check if all 'required' fields are filled
            if (!checkoutForm.checkValidity()) {
                checkoutForm.reportValidity(); // This highlights the empty fields for the user
                return;
            }

            // 2. Button UI State
            this.disabled = true;
            const originalBtnText = this.innerText;
            this.innerHTML = '<i class="bx bx-loader-alt bx-spin"></i> Processing...';

            // 3. Create Order on our server
            fetch('api/create-order.php', {
                    method: 'POST'
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const baseUrl = window.location.origin;
                        const logoUrl = baseUrl + '/assets/img/logo2.png';

                        const options = {
                            "key": data.key,
                            "amount": data.amount,
                            "currency": "INR",
                            "name": "Miss.Sogasu",
                            "description": "Order Payment",
                            "image": logoUrl,
                            "order_id": data.order_id,
                            "handler": function(response) {
                                // Successful Payment: Finalize
                                let formData = new FormData(checkoutForm);
                                formData.append('razorpay_payment_id', response.razorpay_payment_id);
                                formData.append('razorpay_order_id', response.razorpay_order_id);
                                formData.append('razorpay_signature', response.razorpay_signature);

                                fetch('api/verify-payment.php', {
                                        method: 'POST',
                                        body: formData
                                    })
                                    .then(verifyResponse => verifyResponse.json())
                                    .then(verifyData => {
                                        if (verifyData.success) {
                                            window.location.href = 'order-success.php';
                                        } else {
                                            alert('Verification failed: ' + verifyData.message);
                                            placeOrderBtn.disabled = false;
                                            placeOrderBtn.innerText = originalBtnText;
                                        }
                                    });
                            },
                            "prefill": {
                                "name": document.getElementById('checkout_name').value,
                                "email": document.getElementById('checkout_email').value,
                                "contact": document.getElementById('checkout_phone').value
                            },
                            "theme": {
                                "color": "#da0103"
                            },
                            // --- FIX: Manage Payment Cancellation/Dismissal ---
                            "modal": {
                                "on_dismiss": function() {
                                    // Reset button state if user closes the popup
                                    placeOrderBtn.disabled = false;
                                    placeOrderBtn.innerText = originalBtnText;
                                }
                            }
                        };

                        const rzp = new Razorpay(options);
                        rzp.open();

                    } else {
                        alert('Order Error: ' + data.message);
                        placeOrderBtn.disabled = false;
                        placeOrderBtn.innerText = originalBtnText;
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    placeOrderBtn.disabled = false;
                    placeOrderBtn.innerText = originalBtnText;
                });
        });
    });
</script>


<?php include 'includes/footer.php'; ?>

<script>
    // --- COUPON FUNCTIONALITY FOR CHECKOUT PAGE ---

    // 1. Function to handle clicking a coupon ticket from the slider
    function selectCoupon(code) {
        const input = document.getElementById('couponCode');
        if (!input) return;

        input.value = code;

        // Visual feedback: brief highlight
        input.style.backgroundColor = '#fff5f5';
        input.style.borderColor = '#da0103';

        setTimeout(() => {
            input.style.backgroundColor = '';
            input.style.borderColor = '';
        }, 1000);

        // Trigger the application logic
        applyCoupon();
    }

    // 2. Function to display error/success messages
    function displayCouponMessage(message, isSuccess) {
        const messageDiv = document.getElementById('couponMessage');
        const alertClass = isSuccess ? 'alert alert-success' : 'alert alert-danger';
        if (messageDiv) {
            messageDiv.innerHTML = `<div class="${alertClass} alert-dismissible fade show" role="alert">
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>`;

            // Auto-hide the message after 5 seconds
            startMessageTimer();

            // Scroll to message on mobile for visibility
            if (window.innerWidth < 768) {
                messageDiv.scrollIntoView({
                    behavior: 'smooth',
                    block: 'center'
                });
            }
        }
    }

    // 3. Logic to hide alerts automatically after 5 seconds
    function startMessageTimer() {
        setTimeout(function() {
            const activeAlert = document.querySelector('#couponMessage .alert');
            if (activeAlert) {
                // Smoothly fade out using jQuery
                $(activeAlert).fadeOut(1000, function() {
                    $(this).remove();
                });
            }
        }, 2300);
    }

    // 4. Function to apply the coupon via AJAX
    function applyCoupon() {
        const couponCode = document.getElementById('couponCode').value;
        const btn = document.querySelector('.coupon-area button');

        if (!couponCode.trim()) {
            displayCouponMessage('Please enter a coupon code.', false);
            return;
        }

        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="bx bx-loader-alt bx-spin"></i>';
        btn.disabled = true;

        const formData = new FormData();
        formData.append('code', couponCode);

        fetch('apply-coupon.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Page reload is necessary to update all PHP-calculated totals
                    window.location.reload();
                } else {
                    displayCouponMessage(data.message, false);
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                displayCouponMessage('An unexpected error occurred. Please try again.', false);
                btn.innerHTML = originalText;
                btn.disabled = false;
            });
    }

    // 5. Function to remove the coupon
    function removeCoupon() {
        if (!confirm('Are you sure you want to remove this coupon?')) return;

        const formData = new FormData();
        formData.append('action', 'remove');

        fetch('apply-coupon.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    window.location.reload();
                }
            });
    }

    // 6. Initialization on page load
    $(window).on('load', function() {
        // A. Initialize Owl Carousel
        const $slider = $('.available-coupons-slider');
        if ($slider.length) {
            $slider.trigger('destroy.owl.carousel');
            $slider.owlCarousel({
                items: 1,
                loop: true,
                margin: 10,
                nav: false,
                dots: true,
                autoplay: true,
                autoplayTimeout: 5000,
                autoplayHoverPause: true,
                smartSpeed: 800,
                responsive: {
                    0: {
                        items: 1
                    },
                    600: {
                        items: 1
                    },
                    1000: {
                        items: 1
                    }
                }
            });
        }

        // B. Start timer for any message already on page (after reload)
        startMessageTimer();
    });

    // 7. Global click listener for the Remove button
    $(document).on('click', '#removeCoupon', function(e) {
        e.preventDefault();
        removeCoupon();
    });
</script>