<?php
include 'includes/db.php';

// --- ADD THIS LINE HERE ---
$_SESSION['is_buy_now'] = false; 
// --------------------------

// Handle cart actions via AJAX (no page reload needed)
$cart_items = $_SESSION['cart'] ?? [];

// Calculate cart totals
$subtotal = 0;
foreach ($cart_items as $item) {
    $subtotal += $item['price'] * $item['quantity'];
}
?>

<?php include 'includes/header.php'; ?>

<!-- Start Page Title -->
<div class="page-title-area">
    <div class="container">
        <div class="page-title-content">
            <h2>Shopping Cart</h2>
            <ul>
                <li><a href="index.php">Home</a></li>
                <li>Cart</li>
            </ul>
        </div>
    </div>
</div>
<!-- End Page Title -->

<!-- Start Cart Area -->
<section class="cart-area ptb-100">
    <div class="container">
        <div class="cart-table table-responsive">
            <?php if (!empty($cart_items)): ?>
                <table class="table table-bordered" id="cartTable">
                    <thead>
                        <tr>
                            <th scope="col">Product</th>
                            <th scope="col">Name</th>
                            <th scope="col">Unit Price</th>
                            <th scope="col">Quantity</th>
                            <th scope="col">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($cart_items as $cart_key => $item):
                            $item_total = $item['price'] * $item['quantity'];
                        ?>
                            <tr data-cart-key="<?= $cart_key ?>">
                                <td class="product-thumbnail" data-label="Product">
                                    <a href="product-details.php?slug=<?= $item['slug'] ?>">
                                        <img src="<?= $item['image'] ?>" alt="<?= htmlspecialchars($item['name']) ?>">
                                    </a>
                                </td>
                                <td class="product-name" data-label="Name">
                                    <a href="product-details.php?slug=<?= $item['slug'] ?>"><?= htmlspecialchars($item['name']) ?></a>
                                    <ul>
                                        <li>Size: <span><?= htmlspecialchars($item['size']) ?></span></li>
                                        <li>Color: <span><?= htmlspecialchars($item['color']) ?></span></li>
                                    </ul>
                                </td>
                                <td class="product-price" data-label="Unit Price">
                                    <span class="unit-amount">₹<?= number_format($item['price'], 2) ?></span>
                                </td>
                                <td class="product-quantity" data-label="Quantity">
                                    <div class="input-counter">
                                        <span class="minus-btn" data-action="decrease"><i class='bx bx-minus'></i></span>
                                        <input type="text" value="<?= $item['quantity'] ?>" min="1" class="cart-quantity-input" data-max-stock="<?= getMaxStock($conn, $item['product_id'], $item['color'], $item['size']) ?>">
                                        <span class="plus-btn" data-action="increase"><i class='bx bx-plus'></i></span>
                                    </div>
                                </td>
                                <td class="product-subtotal" data-label="Total">
                                    <span class="subtotal-amount">₹<span class="item-total"><?= number_format($item_total, 2) ?></span></span>
                                    <a href="#" class="remove" onclick="removeFromCart('<?= $cart_key ?>')"><i class='bx bx-trash'></i></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <!-- Buttons Wrapper -->
                <div class="d-flex justify-content-between mt-3">
                    <a href="products.php" class="optional-btn">Continue Shopping</a>
                    <button type="button" class="default-btn" onclick="clearCart()">Clear Cart</button>
                </div>
            <?php else: ?>
                <div class="empty-cart text-center py-5">
                    <h3>Your cart is empty</h3>
                    <p>Add some products to get started!</p>
                    <a href="products.php" class="default-btn">Continue Shopping</a>
                </div>
            <?php endif; ?>
        </div>

        <?php if (!empty($cart_items)): ?>
            <!-- Cart Actions Section -->
            <div class="cart-actions">
                <div class="row align-items-center justify-content-center">

                    <!-- Right Side: Cart Totals -->
                    <div class="col-lg-5 col-md-12">
                        <div class="cart-totals">
                            <h3>Cart Totals</h3>
                            <ul>
                                <li>Subtotal <span id="cartSubtotal">₹<?= number_format($subtotal, 2) ?></span></li>

                                <?php
                                // Check if a coupon is active in the session
                                $has_coupon = isset($_SESSION['applied_coupon']);
                                $discount_amount = $has_coupon ? $_SESSION['applied_coupon']['discount'] : 0;
                                $total_with_discount = $subtotal - $discount_amount;
                                ?>

                                <li>Shipping (Within India) <span>Free</span></li>
                                <li>Total <span id="cartTotal">₹<?= number_format($total_with_discount, 2) ?></span></li>
                            </ul>
                            <a href="checkout.php" class="default-btn">Proceed to Checkout</a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>
<!-- End Cart Area -->

<script>



    // Initialize cart interactions
    document.addEventListener('DOMContentLoaded', function() {

        // 1. Define the Logic
        function handleQuantityChange(buttonElement) {
            const action = buttonElement.getAttribute('data-action');
            const input = buttonElement.parentElement.querySelector('.cart-quantity-input');
            const cartKey = buttonElement.closest('tr').getAttribute('data-cart-key');

            let currentValue = parseInt(input.value) || 0;
            const maxStock = parseInt(input.getAttribute('data-max-stock')) || 99;
            let newValue = currentValue;

            if (action === 'increase') {
                if (currentValue < maxStock) {
                    newValue = currentValue + 1;
                } else {
                    alert('Maximum available stock: ' + maxStock);
                    return;
                }
            } else if (action === 'decrease') {
                if (currentValue > 1) {
                    newValue = currentValue - 1;
                } else {
                    removeFromCart(cartKey);
                    return;
                }
            }

            if (newValue !== currentValue) {
                input.value = newValue;
                updateCartItem(cartKey, newValue);
            }
        }

        // 2. STRIP main.js events using cloneNode
        const buttons = document.querySelectorAll('.minus-btn, .plus-btn');

        buttons.forEach(originalBtn => {
            const newBtn = originalBtn.cloneNode(true);
            originalBtn.parentNode.replaceChild(newBtn, originalBtn);
            newBtn.addEventListener('click', function() {
                handleQuantityChange(this);
            });
        });

        // 3. Handle Manual Input Changes
        const inputs = document.querySelectorAll('.cart-quantity-input');
        inputs.forEach(originalInput => {
            const newInput = originalInput.cloneNode(true);
            originalInput.parentNode.replaceChild(newInput, originalInput);

            newInput.addEventListener('change', function() {
                const cartKey = this.closest('tr').getAttribute('data-cart-key');
                const maxStock = parseInt(this.getAttribute('data-max-stock')) || 99;
                let newValue = parseInt(this.value);

                if (isNaN(newValue) || newValue < 1) newValue = 1;
                else if (newValue > maxStock) {
                    newValue = maxStock;
                    alert('Maximum available stock: ' + maxStock);
                }
                this.value = newValue;
                updateCartItem(cartKey, newValue);
            });
        });
    });


    function updateCartItem(cartKey, quantity) {
        const row = document.querySelector(`tr[data-cart-key="${cartKey}"]`);
        const price = parseFloat(row.querySelector('.unit-amount').textContent.replace('₹', '').replace(',', ''));
        const itemTotal = price * quantity;

        // Update item total
        row.querySelector('.item-total').textContent = itemTotal.toFixed(2);

        // Update via AJAX
        const formData = new FormData();
        formData.append('action', 'update');
        formData.append('cart_key', cartKey);
        formData.append('quantity', quantity);

        fetch('add-to-cart.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    updateCartTotals();
                    // --- THIS IS THE FIX ---
                    // Call the global function from main.js to update the header
                    if (typeof updateCartCount === 'function') {
                        updateCartCount(data.cart_count);
                    }
                    // -----------------------
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error updating cart. Please try again.');
            });
    }

    function removeFromCart(cartKey) {
        // KEEP THIS CONFIRMATION - It serves both the "-" button and the Trash Icon
        if (!confirm('Remove this item from cart?')) return;

        const formData = new FormData();
        formData.append('action', 'remove');
        formData.append('cart_key', cartKey);

        fetch('add-to-cart.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const row = document.querySelector(`tr[data-cart-key="${cartKey}"]`);
                    if (row) row.remove();

                    // --- ADD THIS LINE ---
                    if (typeof updateCartCount === 'function') {
                        updateCartCount(data.cart_count);
                    }
                    // -------------------

                    updateCartTotals();

                    // If cart is empty, reload to show empty state
                    if (document.querySelectorAll('#cartTable tbody tr').length === 0) {
                        location.reload();
                    }
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error removing item. Please try again.');
            });
    }

    function clearCart() {
        if (!confirm('Clear all items from cart?')) return;

        const items = document.querySelectorAll('tr[data-cart-key]');
        const promises = [];

        items.forEach(row => {
            const cartKey = row.getAttribute('data-cart-key');
            const formData = new FormData();
            formData.append('action', 'remove');
            formData.append('cart_key', cartKey);

            promises.push(
                fetch('add-to-cart.php', {
                    method: 'POST',
                    body: formData
                })
            );
        });

        Promise.all(promises)
            .then(() => {
                location.reload();
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error clearing cart. Please try again.');
            });
    }

function updateCartTotals() {
        let subtotal = 0;

        // Calculate new subtotal from visible items
        document.querySelectorAll('.item-total').forEach(element => {
            // FIX: Remove commas before parsing the number
            const valueAsString = element.textContent.replace(/,/g, '');
            subtotal += parseFloat(valueAsString);
        });

        // Format with commas for display
        document.getElementById('cartSubtotal').textContent = '₹' + subtotal.toLocaleString('en-IN', {minimumFractionDigits: 2, maximumFractionDigits: 2});
        
        // Also update the final total
        document.getElementById('cartTotal').textContent = '₹' + subtotal.toLocaleString('en-IN', {minimumFractionDigits: 2, maximumFractionDigits: 2});
    }
</script>

<?php
// Helper function to get max stock
function getMaxStock($conn, $product_id, $color, $size)
{
    $stock_sql = "SELECT stock_quantity FROM product_sizes 
                  WHERE product_id = $product_id 
                  AND color_group = '$color' 
                  AND size = '$size'";
    $stock_result = $conn->query($stock_sql);

    if ($stock_result->num_rows > 0) {
        return $stock_result->fetch_assoc()['stock_quantity'];
    }
    return 0;
}
?>

<?php include 'includes/footer.php'; ?>