<?php
require_once '../../includes/db.php';

// Only process POST requests
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // 1. Get and Sanitize Input
    $name    = sanitize_input($_POST['name'] ?? '');
    $email   = sanitize_input($_POST['email'] ?? '');
    $phone   = sanitize_input($_POST['phone_number'] ?? ''); // Maps to 'phone' column
    $subject = sanitize_input($_POST['subject'] ?? '');
    $message = sanitize_input($_POST['message'] ?? '');

    // 2. Simple Validation
    if (empty($name) || empty($email) || empty($message)) {
        echo "Please fill in all required fields.";
        exit;
    }

    // 3. Save to Database
    $stmt = $conn->prepare("INSERT INTO contacts (name, email, phone, subject, message, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("sssss", $name, $email, $phone, $subject, $message);
    
    if ($stmt->execute()) {
        
        // 4. Send Email Notification to Admin
        // Fetch Admin Email from settings
        $res = $conn->query("SELECT setting_value FROM site_settings WHERE setting_key = 'contact_email'");
        $admin_email = ($res->num_rows > 0) ? $res->fetch_assoc()['setting_value'] : 'support@misssogasu.com';

        $to = $admin_email;
        $mail_subject = "New Contact Website Inquiry: " . $subject;
        
        // Email Body
        $email_content = "You have received a new message from your website contact form.\n\n";
        $email_content .= "Details:\n";
        $email_content .= "Name: $name\n";
        $email_content .= "Email: $email\n";
        $email_content .= "Phone: $phone\n";
        $email_content .= "Subject: $subject\n\n";
        $email_content .= "Message:\n$message\n";

        // Headers
        $headers = "From: web-inquiry@misssogasu.com\r\n";
        $headers .= "Reply-To: $email\r\n";
        $headers .= "X-Mailer: PHP/" . phpversion();

        // Use standard PHP mail() function
        @mail($to, $mail_subject, $email_content, $headers);

        // Success Response for AJAX
        echo "success";
    } else {
        echo "Database error. Please try again later.";
    }
    
    $stmt->close();
} else {
    echo "Invalid request.";
}
?>