(function($){
	"use strict";
    
    // Search Popup JS
    $(".others-option .search-btn").on("click", function(){
        $(".search-overlay").toggleClass("search-overlay-active");
    });
    $(".search-overlay-close").on("click", function(){
        $(".search-overlay").removeClass("search-overlay-active");
    });
    $(".header-top-others-option .search-btn").on("click", function(){
        $(".search-overlay").toggleClass("search-overlay-active");
    });
    
    // Mean Menu is disabled for mobile (Bootstrap offcanvas is used instead)

    // Header Sticky
    // Header Sticky (Desktop + Mobile Fix)
    $(window).on('scroll', function () {

        if ($(this).scrollTop() > 60) {

            // Desktop sticky
            $('.header-sticky').addClass('is-sticky');

            // Mobile sticky position fix
            $('.xton-responsive-nav').addClass('mobile-sticky');

        } else {

            // Desktop sticky remove
            $('.header-sticky').removeClass('is-sticky');

            // Mobile sticky remove
            $('.xton-responsive-nav').removeClass('mobile-sticky');

        }

    });

    var c, currentScrollTop = 0,
    navbar = $('.header-sticky');
    $(window).scroll(function () {
        var a = $(window).scrollTop();
        var b = navbar.height();
        currentScrollTop = a;
        if (c < currentScrollTop && a > b + b) {
            navbar.addClass("scrollUp");
        } else if (c > currentScrollTop && !(a <= b)) {
            navbar.removeClass("scrollUp");
        }
        c = currentScrollTop;
    });

    // Home Slides
    $('.home-slides').owlCarousel({
        loop: true,
        nav: true,
        dots: true,
        autoplayHoverPause: true,
        autoplay: true,
        smartSpeed: 500,
        autoHeight: true,
        items: 1,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
    });
    $(".home-slides").on("translate.owl.carousel", function(){
        $(".main-banner-content .sub-title").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
        $(".main-banner-content h1").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
        $(".main-banner-content p").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
        $(".main-banner-content .btn-box").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
    });
    $(".home-slides").on("translated.owl.carousel", function(){
        $(".main-banner-content .sub-title").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
        $(".main-banner-content h1").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
        $(".main-banner-content p").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
        $(".main-banner-content .btn-box").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
    });
    
    // Home Slides Two
    $('.home-slides-two').owlCarousel({
        loop: true,
        nav: true,
        dots: false,
        autoplayHoverPause: true,
        autoplay: true,
        autoHeight: true,
        animateOut: 'animate__animated animate__slideOutUp',
        items: 1,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
    });

    // Home Slides Three
    $('.home-slides-three').owlCarousel({
        loop: true,
        nav: false,
        dots: true,
        autoplayHoverPause: true,
        items: 1,
        smartSpeed: 750,
        autoplay: true,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
    });
    $(".home-slides-three").on("translate.owl.carousel", function(){
        $(".main-banner-content .sub-title").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
        $(".main-banner-content h1").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
        $(".main-banner-content p").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
        $(".main-banner-content .btn-box").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
        $(".banner-image img").removeClass("animate__animated animate__fadeInUp").css("opacity", "0");
        $(".banner-image .circle").removeClass("animate__animated animate__zoomIn").css("opacity", "0");
    });
    $(".home-slides-three").on("translated.owl.carousel", function(){
        $(".main-banner-content .sub-title").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
        $(".main-banner-content h1").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
        $(".main-banner-content p").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
        $(".main-banner-content .btn-box").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
        $(".banner-image img").addClass("animate__animated animate__fadeInUp").css("opacity", "1");
        $(".banner-image .circle").addClass("animate__animated animate__zoomIn").css("opacity", "1");
    });
    
    // Tooltip JS
    $(function () {
        $('[data-bs-toggle="tooltip"]').tooltip();
    });

    // Facility Slides
    $('.facility-slides').owlCarousel({
        loop: true,
        nav: true,
        dots: false,
        autoplayHoverPause: true,
        autoplay: true,
        margin: 30,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
        responsive: {
            0: {
                items: 1,
            },
            576: {
                items: 2,
            },
            768: {
                items: 3,
            },
            1200: {
                items: 4,
            }
        }
    });
    
    // Products Slides
    $('.products-slides').owlCarousel({
        loop: true,
        nav: true,
        dots: false,
        autoplayHoverPause: true,
        autoplay: true,
        margin: 30,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
        responsive: {
            0: {
                items: 1,
            },
            576: {
                items: 2,
            },
            768: {
                items: 2,
            },
            1200: {
                items: 3,
            }
        }
    });

    // Instagram Slides
    $('.instagram-slides').owlCarousel({
        loop: true,
        nav: false,
        dots: false,
        autoplayHoverPause: true,
        autoplay: true,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
        responsive: {
            0: {
                items: 1,
            },
            576: {
                items: 2,
            },
            768: {
                items: 3,
            },
            1200: {
                items: 6,
            }
        }
    });
    
    // Partner Slides
    $('.partner-slides').owlCarousel({
        loop: true,
        nav: false,
        dots: false,
        autoplayHoverPause: true,
        autoplay: true,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
        responsive: {
            0: {
                items: 2,
            },
            576: {
                items: 4,
            },
            768: {
                items: 4,
            },
            1200: {
                items: 7,
            }
        }
    });

    // Offer Products Slides
    $('.offer-products-slides').owlCarousel({
        loop: true,
        nav: false,
        dots: true,
        autoplayHoverPause: true,
        autoplay: true,
        animateOut: 'fadeOut',
        mouseDrag: false,
        items: 1,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
    });

    // Brand Slides
    $('.brand-slides').owlCarousel({
        loop: true,
        nav: false,
        dots: false,
        autoplayHoverPause: true,
        autoplay: true,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
        responsive: {
            0: {
                items: 2,
            },
            576: {
                items: 3,
            },
            768: {
                items: 4,
            },
            1200: {
                items: 7,
            }
        }
    });

    // Price Range Slider JS
    $(".js-range-of-price").ionRangeSlider({
        type: "double",
        drag_interval: true,
        min_interval: null,
        max_interval: null,
    });

    // Input Plus & Minus Number JS
    $('.input-counter').each(function() {
        var spinner = jQuery(this),
        input = spinner.find('input[type="text"]'),
        btnUp = spinner.find('.plus-btn'),
        btnDown = spinner.find('.minus-btn'),
        min = input.attr('min'),
        max = input.attr('max');
        
        btnUp.on('click', function() {
            var oldValue = parseFloat(input.val());
            if (oldValue >= max) {
                var newVal = oldValue;
            } else {
                var newVal = oldValue + 1;
            }
            spinner.find("input").val(newVal);
            spinner.find("input").trigger("change");
        });
        btnDown.on('click', function() {
            var oldValue = parseFloat(input.val());
            if (oldValue <= min) {
                var newVal = oldValue;
            } else {
                var newVal = oldValue - 1;
            }
            spinner.find("input").val(newVal);
            spinner.find("input").trigger("change");
        });
    });

    // Testimonials Slides
    $('.testimonials-slides').owlCarousel({
        loop: true,
        nav: false,
        dots: true,
        margin: 30,
        autoplayHoverPause: true,
        autoplay: true,
        center: true,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
        responsive: {
            0: {
                items: 1,
            },
            576: {
                items: 2,
            },
            768: {
                items: 2,
            },
            1200: {
                items: 3,
            }
        }
    });

// Top Header Text Slider (Professional Vertical Scroll)
    $('.top-text-slider').owlCarousel({
        items: 1,
        loop: true,
        nav: false,
        dots: false,
        autoplay: true,
        autoplayTimeout: 3000, // 4 seconds reading time
        smartSpeed: 800,       // 0.8s transition speed (Silky smooth)
        autoplayHoverPause: true,
        animateOut: 'slideOutUp', // Custom CSS Animation
        animateIn: 'slideInUp',   // Custom CSS Animation
        mouseDrag: false,
        touchDrag: false
    });

    // Tabs
    (function ($) {
        $('.tab ul.tabs').addClass('active').find('> li:eq(0)').addClass('current');
        $('.tab ul.tabs li a').on('click', function (g) {
            var tab = $(this).closest('.tab'), 
            index = $(this).closest('li').index();
            tab.find('ul.tabs > li').removeClass('current');
            $(this).closest('li').addClass('current');
            tab.find('.tab-content').find('div.tabs-item').not('div.tabs-item:eq(' + index + ')').slideUp();
            tab.find('.tab-content').find('div.tabs-item:eq(' + index + ')').slideDown();
            g.preventDefault();
        });
    })(jQuery);

    // FAQ Accordion
    $(function() {
        $('.accordion').find('.accordion-title').on('click', function(){
            // Adds Active Class
            $(this).toggleClass('active');
            // Expand or Collapse This Panel
            $(this).next().slideToggle('fast');
            // Hide The Other Panels
            $('.accordion-content').not($(this).next()).slideUp('fast');
            // Removes Active Class From Other Titles
            $('.accordion-title').not($(this)).removeClass('active');		
        });
    });

    // Products Filter Options
    $(function(){
        $(".icon-view-one").on("click", function(e){
            e.preventDefault();
            document.getElementById("products-collections-filter").classList.add('products-col-one')
            document.getElementById("products-collections-filter").classList.remove('products-col-two', 'products-col-three', 'products-col-four', 'products-row-view');
        });
        $(".icon-view-two").on("click", function(e){
            e.preventDefault();
            document.getElementById("products-collections-filter").classList.add('products-col-two')
            document.getElementById("products-collections-filter").classList.remove('products-col-one', 'products-col-three', 'products-col-four', 'products-row-view');
        });
        $(".icon-view-three").on("click", function(e){
            e.preventDefault();
            document.getElementById("products-collections-filter").classList.add('products-col-three')
            document.getElementById("products-collections-filter").classList.remove('products-col-one', 'products-col-two', 'products-col-four', 'products-row-view');
        });
        $(".icon-view-four").on("click", function(e){
            e.preventDefault();
            document.getElementById("products-collections-filter").classList.add('products-col-four')
            document.getElementById("products-collections-filter").classList.remove('products-col-one', 'products-col-two', 'products-col-three', 'products-row-view');
        });
        $(".view-grid-switch").on("click", function(e){
            e.preventDefault();
            document.getElementById("products-collections-filter").classList.add('products-row-view')
            document.getElementById("products-collections-filter").classList.remove('products-col-one', 'products-col-two', 'products-col-three', 'products-col-four');
        });
        $(".icon-view-six").on("click", function(e){
            e.preventDefault();
            document.getElementById("products-collections-filter").classList.add('products-col-six')
            document.getElementById("products-collections-filter").classList.remove('products-col-one', 'products-col-two', 'products-col-three', 'products-col-four', 'products-row-view');
        });
    });
    $('.products-filter-options .view-column a').on('click', function(){
        $('.view-column a').removeClass("active");
        $(this).addClass("active");
    });
    
    // Nice Select JS
    $('select').niceSelect();

    // Blog Slides
    $('.blog-slides').owlCarousel({
        loop: true,
        nav: false,
        dots: true,
        autoplayHoverPause: true,
        autoplay: true,
        margin: 30,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
        responsive: {
            0: {
                items: 1,
            },
            768: {
                items: 2,
            },
            1200: {
                items: 3,
            }
        }
    });

    // Subscribe form
    $(".newsletter-form").validator().on("submit", function (event) {
        if (event.isDefaultPrevented()) {
        // handle the invalid form...
            formErrorSub();
            submitMSGSub(false, "Please enter your email correctly.");
        } else {
            // everything looks good!
            event.preventDefault();
        }
    });
    function callbackFunction (resp) {
        if (resp.result === "success") {
            formSuccessSub();
        }
        else {
            formErrorSub();
        }
    }
    function formSuccessSub(){
        $(".newsletter-form")[0].reset();
        submitMSGSub(true, "Thank you for subscribing!");
        setTimeout(function() {
            $("#validator-newsletter").addClass('hide');
        }, 4000)
    }
    function formErrorSub(){
        $(".newsletter-form").addClass("animate__animated animate__shake");
        setTimeout(function() {
            $(".newsletter-form").removeClass("animate__animated animate__shake");
        }, 1000)
    }
    function submitMSGSub(valid, msg){
        if(valid){
            var msgClasses = "validation-success";
        } else {
            var msgClasses = "validation-danger";
        }
        $("#validator-newsletter").removeClass().addClass(msgClasses).text(msg);
    }
    // AJAX MailChimp
    $(".newsletter-form").ajaxChimp({
        url: "https://hibootstrap.us20.list-manage.com/subscribe/post?u=60e1ffe2e8a68ce1204cd39a5&amp;id=42d6d188d9", // Your url MailChimp
        callback: callbackFunction
    });

    // Popup Image
    $('.popup-btn').magnificPopup({
        type: 'image',
        removalDelay: 300,
        gallery: {
            enabled:true
        },
        callbacks: {
            beforeOpen: function() {
                this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure animated ' + this.st.el.attr('data-effect'));
            }
        },
    });

    // Isotop Js
    var $grid = $('.gallery-items, .blog-items, .lookbook-items').isotope({
        itemSelector: '.grid-item',
        percentPosition: true,
        masonry: {
            // Use outer width of grid-sizer for columnWidth
            columnWidth: '.grid-item'
        }
    });

    // Article Image Slides
    $('.article-image-slides').owlCarousel({
        loop: true,
        nav: true,
        dots: false,
        autoplayHoverPause: true,
        autoplay: true,
        animateOut: 'fadeOut',
        items: 1,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
    });

    // Sidebar Sticky
    $('.products-details-desc-sticky').stickySidebar({
        topSpacing: 110,
        bottomSpacing: 110
    });

    // Products Details Image Slides
    $('.products-details-image-slides').slick({
        dots: true,
        speed: 500,
        fade: false,
        slide: 'li',
        slidesToShow: 1,
        autoplay: true,
        autoplaySpeed: 4000,
        prevArrow: false,
        nextArrow: false,
        responsive: [{
            breakpoint: 800,
            settings: {
                arrows: false,
                centerMode: false,
                centerPadding: '40px',
                variableWidth: false,
                slidesToShow: 1,
                dots: true
            },
            breakpoint: 1200,
            settings: {
                arrows: false,
                centerMode: false,
                centerPadding: '40px',
                variableWidth: false,
                slidesToShow: 1,
                dots: true
            }
        }],
        customPaging: function (slider, i) {
            return '<button class="tab">' + $('.slick-thumbs li:nth-child(' + (i + 1) + ')').html() + '</button>';
        }
    });

    // Products Details Image Slides Style 2
    $('.products-details-image-slider').owlCarousel({
        loop: true,
        nav: true,
        dots: false,
        autoplayHoverPause: true,
        autoplay: true,
        margin: 30,
        navText: [
            "<i class='flaticon-left'></i>",
            "<i class='flaticon-right-arrow'></i>"
        ],
        responsive: {
            0: {
                items: 1,
            },
            576: {
                items: 2,
            },
            768: {
                items: 2,
            },
            1200: {
                items: 3,
            }
        }
    });

    // Count Time 
    function makeTimer() {
        var endTime = new Date("September 20, 2025 17:00:00 PDT");			
        var endTime = (Date.parse(endTime)) / 1000;
        var now = new Date();
        var now = (Date.parse(now) / 1000);
        var timeLeft = endTime - now;
        var days = Math.floor(timeLeft / 86400); 
        var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
        var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
        var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
        if (hours < "10") { hours = "0" + hours; }
        if (minutes < "10") { minutes = "0" + minutes; }
        if (seconds < "10") { seconds = "0" + seconds; }
        $("#days").html(days + "<span>Days</span>");
        $("#hours").html(hours + "<span>Hours</span>");
        $("#minutes").html(minutes + "<span>Minutes</span>");
        $("#seconds").html(seconds + "<span>Seconds</span>");
    }
    setInterval(function() { makeTimer(); }, 0);

    // Go to Top
    $(function(){
        // Scroll Event
        $(window).on('scroll', function(){
            var scrolled = $(window).scrollTop();
            if (scrolled > 300) $('.go-top').addClass('active');
            if (scrolled < 300) $('.go-top').removeClass('active');
        });  
        // Click Event
        $('.go-top').on('click', function() {
            $("html, body").animate({ scrollTop: "0" },  500);
        });
    });

	// WoW JS
	$(window).on ('load', function (){
        if ($(".wow").length) { 
            var wow = new WOW ({
                boxClass:     'wow',      // Animated element css class (default is wow)
                animateClass: 'animated', // Animation css class (default is animated)
                offset:       20,         // Distance to the element when triggering the animation (default is 0)
                mobile:       true,       // Trigger animations on mobile devices (default is true)
                live:         true,       // Act on asynchronously loaded content (default is true)
            });
            wow.init();
        }
    });

    // Switch Btn
	$('body').append("<div class='switch-box'><label id='switch' class='switch'><input type='checkbox' onchange='toggleTheme()' id='slider'><span class='slider round'></span></label></div>");

}(jQuery));

// function to set a given theme/color-scheme
function setTheme(themeName) {
    localStorage.setItem('xton_theme', themeName);
    document.documentElement.className = themeName;
}
// function to toggle between light and dark theme
function toggleTheme() {
    if (localStorage.getItem('xton_theme') === 'theme-dark') {
        setTheme('theme-light');
    } else {
        setTheme('theme-dark');
    }
}
// Immediately invoked function to set the theme on initial load
(function () {
    if (localStorage.getItem('xton_theme') === 'theme-dark') {
        setTheme('theme-dark');
        document.getElementById('slider').checked = false;
    } else {
        setTheme('theme-light');
    document.getElementById('slider').checked = true;
    }
})();


// #################################################################################################################################3
// #################################################################################################################################3
// #################################################################################################################################3
// #################################################################################################################################3
// #################################################################################################################################3
// #################################################################################################################################3
// #################################################################################################################################3
// #################################################################################################################################3
// #################################################################################################################################3


// Products Slides
$('.products-slides').owlCarousel({
    loop: true,
    nav: true,
    dots: false,
    autoplayHoverPause: true,
    autoplay: true,
    margin: 30,
    navText: [
        "<i class='bx bx-chevron-left'></i>",
        "<i class='bx bx-chevron-right'></i>"
    ],
    responsive: {
        0: {
            items: 1,
        },
        576: {
            items: 2,
        },
        768: {
            items: 2,
        },
        992: {
            items: 3,
        }
    }
});

// Functional Sorting Dropdown
$(document).ready(function() {
    $('#sortingSelect').on('change', function() {
        // When the user selects a new option, submit the form
        $('#sortingForm').submit();
    });
});


// Smarter Synced Product Details Image Slider (Owl Carousel) & Lightbox
$(document).ready(function() {
    // Check if the sliders exist on the page before running
    if ($('.product-details-main-slider-sync').length) {
        var mainSlider = $('.product-details-main-slider-sync');
        var navSlider = $('.product-details-nav-slider-sync');
        var itemCount = navSlider.find('.item').length;

        // Initialize the main slider (this happens in all cases)
        mainSlider.owlCarousel({
            items: 1,
            slideSpeed: 2000,
            nav: true,
            autoplay: false,
            dots: false,
            loop: true,
            responsiveRefreshRate: 200,
            navText: [
                "<i class='bx bx-chevron-left'></i>",
                "<i class='bx bx-chevron-right'></i>"
            ],
        }).on('changed.owl.carousel', function(e) {
            // When main slider changes, update the thumbnail's 'current' class
            var number = e.item.index;
            navSlider.find(".owl-item, .item").removeClass("current").eq(number).addClass("current");
        });

        // --- THE NEW LOGIC IS HERE ---
        if (itemCount <= 4) {
            // IF 4 OR FEWER ITEMS: Center them, don't make it a slider.
            navSlider.addClass('is-centered');
            navSlider.find(".item").eq(0).addClass("current"); // Set first item as current

            // Add click functionality for static thumbnails
            navSlider.on("click", ".item", function(e){
                e.preventDefault();
                var number = $(this).index();
                mainSlider.data('owl.carousel').to(number, 300, true);
            });
        } else {
            // IF MORE THAN 4 ITEMS: Initialize the slider as before.
            navSlider.on('initialized.owl.carousel', function () {
                navSlider.find(".owl-item").eq(0).addClass("current");
            }).owlCarousel({
                items: 4,
                dots: false,
                nav: false,
                margin: 15,
                smartSpeed: 200,
                slideSpeed: 500,
                slideBy: 1,
                responsiveRefreshRate: 100
            });
            
            // Add click functionality for slidable thumbnails
            navSlider.on("click", ".owl-item", function(e){
                e.preventDefault();
                var number = $(this).index();
                mainSlider.data('owl.carousel').to(number, 300, true);
            });
        }
    }

    // Lightbox initialization (remains the same)
    $('.image-popup-zoom').magnificPopup({
        type: 'image',
        zoom: {
            enabled: true,
            duration: 300,
            easing: 'ease-in-out'
        },
        gallery: {
            enabled: true
        }
    });
});


// Password Visibility Toggle
$(document).ready(function() {
    $('.toggle-password').on('click', function() {
        // Find the input field within the same wrapper
        var input = $(this).siblings('input'); 

        // Check the current type of the input
        if (input.attr('type') === 'password') {
            // Change to text
            input.attr('type', 'text');
            // Change the icon to the 'show' state (eye)
            $(this).removeClass('bx-hide').addClass('bx-show');
        } else {
            // Change back to password
            input.attr('type', 'password');
            // Change the icon back to the 'hide' state (eye-slash)
            $(this).removeClass('bx-show').addClass('bx-hide');
        }
    });
});




// User Profile Page Tab Switching
$(document).ready(function() {
    // When a profile navigation link is clicked
    $('.profile-nav-link').on('click', function(e) {
        e.preventDefault(); // Stop the link from navigating

        // Get the target ID from the 'data-target' attribute
        var target = $(this).data('target');

        // Handle active classes for the navigation links
        $('.profile-nav-link').removeClass('active');
        $(this).addClass('active');

        // Show/hide the content sections
        $('.profile-content-section').hide(); // Hide all sections
        $('#' + target).show(); // Show the targeted section
    });
});


// Categories Slides
$('.categories-slides.owl-carousel').owlCarousel({
    loop: true,
    nav: true,
    dots: false,
    autoplayHoverPause: true,
    autoplay: true,
    margin: 20,
    navText: [
        "<i class='bx bx-chevron-left'></i>",
        "<i class='bx bx-chevron-right'></i>"
    ],
    responsive: {
        0: {
            items: 1
        },
        576: {
            items: 2 
        },
        768: {
            items: 3 
        },
        1200: {
            items: 4 
        }
    }
});

// Why Choose Us Slider
    $('.why-choose-slides').owlCarousel({
        loop: true,
        nav: false,
        dots: true,
        autoplay: true,
        autoplayTimeout: 5000,
        smartSpeed: 1000,
        autoplayHoverPause: true,
        responsive: {
            0: {
                items: 1, // 1 Item on Mobile
                margin: 0
            },
            768: {
                items: 2, // 2 Items on Tablet
                margin: 20
            },
            992: {
                items: 3, // 3 Items on Desktop
                loop: false, // Disable loop on desktop as there are only 3 items
                autoplay: false,
                dots: false, // Hide dots on desktop
                margin: 30
            }
        }
    });


















function loadQuickView(productId) {
    // 1. Show Loading State
    document.getElementById('qv_product_name').innerText = 'Loading...';
    document.getElementById('qv_main_image').src = 'assets/img/placeholder.png';
    document.getElementById('qv_price_box').innerHTML = '';
    document.getElementById('qv_color_list').innerHTML = '';
    document.getElementById('qv_size_list').innerHTML = '';
    
    // 2. Fetch Data
    const formData = new FormData();
    formData.append('id', productId);

    fetch('get_product_data.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if(data.status === 'success') {
            const p = data.product;
            const vars = data.variations;
            const defaultColor = data.default_color || 'Standard';
            
            // --- A. Basic Info ---
            document.getElementById('qv_product_name').innerText = p.name;
            document.getElementById('qv_sku').innerText = p.sku || 'N/A';
            document.getElementById('qv_category').innerText = p.category_name || 'Uncategorized';
            document.getElementById('qv_product_link').href = 'product-details.php?slug=' + p.slug;
            document.getElementById('qv_view_full').href = 'product-details.php?slug=' + p.slug;

            // --- B. Price Logic ---
            let priceHtml = '';
            const price = parseFloat(p.price) || 0;
            const salePrice = parseFloat(p.sale_price) || 0;
            const hasDiscount = salePrice > 0 && salePrice < price;
            
            if(hasDiscount) {
                priceHtml = `<span class="old-price">₹${price.toLocaleString('en-IN')}</span> 
                             <span class="new-price">₹${salePrice.toLocaleString('en-IN')}</span>`;
            } else {
                priceHtml = `<span class="new-price">₹${price.toLocaleString('en-IN')}</span>`;
            }
            document.getElementById('qv_price_box').innerHTML = priceHtml;

            // --- C. Variations Logic ---
            const colorSection = document.getElementById('qv_color_section');
            const colorList = document.getElementById('qv_color_list');
            const sizeList = document.getElementById('qv_size_list');
            
            // Get Color Keys
            const colorKeys = Object.keys(vars);
            
            // Check if it's a "Standard" (No Color) product or has colors
            const hasMultipleColors = colorKeys.length > 1 || (colorKeys.length === 1 && colorKeys[0] !== 'Standard');
            
if(!hasMultipleColors) {
    colorSection.style.display = 'none';
    const colorName = colorKeys[0] || 'Standard';
    renderQvSizes(colorName, vars);
    renderQvImage(colorName, vars);
    updateQvAvailability(colorName, vars);
} else {
    // It has colors
    colorSection.style.display = 'block';
    let colorHtml = '';
    
    colorKeys.forEach((color, index) => {
        const isActive = (color === defaultColor) ? 'active' : '';
        const color_class = 'color-' + color.toLowerCase().replace(/[^a-z]/g, '');
        
        colorHtml += `<li class="color-option ${isActive}">
            <a href="javascript:void(0)" 
               title="${color}" 
               class="${color_class} color-dot"
               data-color="${color}"
               onclick="changeQvColor('${color}', this)">
            </a>
            <span class="color-label">${color}</span>
        </li>`;
    });
    colorList.innerHTML = colorHtml;

    //SETTIMEOUT
                setTimeout(function() {
                    document.querySelectorAll('#qv_color_list .color-dot').forEach(function(colorDot) {
                        const colorName = colorDot.getAttribute('data-color');
                        if (colorName) {
                            const hexColor = getColorHex(colorName);
                            colorDot.style.backgroundColor = hexColor;
                            
                            // Add white border for light colors
                            const lowerColor = colorName.toLowerCase();
                            if (lowerColor === 'white' || lowerColor === 'yellow' || hexColor === '#ffffff') {
                                colorDot.style.border = '3px solid #f0f0f0';
                            }
                        }
                    });
                }, 100);
    
    // Render for default color
    const activeColor = defaultColor in vars ? defaultColor : colorKeys[0];
    renderQvSizes(activeColor, vars);
    renderQvImage(activeColor, vars);
    updateQvAvailability(activeColor, vars);
}

            // Store data globally
            window.currentQvData = {
                productId: productId,
                variations: vars,
                product: p
            };
        }
    })
    .catch(err => {
        console.error('Quick View Error:', err);
        document.getElementById('qv_product_name').innerText = 'Error loading product';
    });
}

// Updated render functions
function renderQvImage(color, data) {
    const imgEl = document.getElementById('qv_main_image');
    if(data[color] && data[color].primary_image) {
        // Ensure proper path
        let imagePath = data[color].primary_image;
        // Remove leading ../ if present
        if (imagePath.startsWith('../')) {
            imagePath = imagePath.substring(3);
        }
        imgEl.src = imagePath;
        imgEl.alt = `Product in ${color} color`;
    } else {
        // Use a reliable placeholder
        imgEl.src = 'assets/img/products/placeholder.jpg'; // Update to existing image
        imgEl.alt = 'Image not available';
    }
}

function renderQvSizes(color, data) {
    const sizeList = document.getElementById('qv_size_list');
    const sizes = data[color] ? data[color].sizes : [];
    let html = '';

    if(sizes.length > 0) {
        sizes.forEach((s, idx) => {
            const outOfStock = s.stock <= 0;
            // Always make the first item active so the system has a "selected" size by default
            const activeClass = (idx === 0) ? 'active' : '';
            const disabledClass = outOfStock ? 'out-of-stock' : '';
            
            html += `<li class="${activeClass} ${disabledClass}">
                <a href="javascript:void(0)" 
                   onclick="selectQvSize('${s.size}', this)"
                   data-size="${s.size}"
                   data-stock="${s.stock}">
                    ${s.size}
                </a>
            </li>`;
        });
    } else {
        html = '<li class="out-of-stock active"><a href="javascript:void(0)" data-stock="0" data-size="Standard">Standard</a></li>';
    }
    sizeList.innerHTML = html;

    // --- AUTO-TRIGGER SELECTION ---
    // This ensures the "Add to Cart" button state is checked as soon as the modal opens
    const firstSize = sizeList.querySelector('li.active a');
    if (firstSize) {
        selectQvSize(firstSize.getAttribute('data-size'), firstSize);
    }
}

function updateQvAvailability(color, data) {
    const availabilityEl = document.getElementById('qv_availability');
    const sizes = data[color] ? data[color].sizes : [];
    
    let totalStock = 0;
    sizes.forEach(s => {
        totalStock += parseInt(s.stock) || 0;
    });
    
    if(totalStock > 0) {
        availabilityEl.innerText = 'In Stock';
        availabilityEl.className = 'in-stock';
    } else {
        availabilityEl.innerText = 'Out of Stock';
        availabilityEl.className = 'out-of-stock';
    }
}

function selectQvSize(size, element) {
    const allSizes = document.querySelectorAll('#qv_size_list li');
    allSizes.forEach(li => li.classList.remove('active'));
    element.parentElement.classList.add('active');
    
    const stock = parseInt(element.getAttribute('data-stock') || 0);
    const qvQtyInput = document.getElementById('qv_qty');
    
    if (qvQtyInput) {
        qvQtyInput.setAttribute('max', stock);
        // Reset quantity to 1 if in stock, 0 if out
        qvQtyInput.value = stock > 0 ? 1 : 0;
    }
    
    const availabilityEl = document.getElementById('qv_availability');
    if (availabilityEl) {
        if (stock > 0) {
            availabilityEl.innerText = `In Stock`;
            availabilityEl.className = 'in-stock';
        } else {
            availabilityEl.innerText = 'Out of Stock';
            availabilityEl.className = 'out-of-stock';
        }
    }
    
    const addToCartBtn = document.querySelector('#productsQuickView .default-btn');
    if(addToCartBtn) {
        if(stock <= 0) {
            addToCartBtn.disabled = true;
            addToCartBtn.innerHTML = '<i class="bx bx-x-circle"></i> Sold Out';
            addToCartBtn.style.opacity = '0.6';
        } else {
            addToCartBtn.disabled = false;
            addToCartBtn.innerHTML = '<i class="bx bx-cart"></i> Add to Cart';
            addToCartBtn.style.opacity = '1';
        }
    }
}

// Updated changeQvColor function
// Helper: Change Content when Color Clicked
function changeQvColor(color, element) {
    if(!window.currentQvData) return;
    
    const allColors = document.querySelectorAll('#qv_color_list li');
    allColors.forEach(li => li.classList.remove('active'));
    element.parentElement.classList.add('active');
    
    const vars = window.currentQvData.variations;
    if(vars[color]) {
        renderQvImage(color, vars);
        renderQvSizes(color, vars); // This now auto-triggers selectQvSize
        updateQvAvailability(color, vars);
    }
}

// New helper function
function updateSizeAvailability(stock) {
    const availabilityEl = document.getElementById('qv_availability');
    if (availabilityEl) {
        if (stock > 0) {
            availabilityEl.innerText = `In Stock (${stock} available)`;
            availabilityEl.className = 'in-stock';
        } else {
            availabilityEl.innerText = 'Out of Stock';
            availabilityEl.className = 'out-of-stock';
        }
    }
}

    // Helper: Simple Color Mapper (Optional)
    function getColorHex(colorName) {
        const lowerColor = colorName.toLowerCase().trim();
        const colorMap = {
            // Basics
            'red': '#da0103', 'blue': '#0000ff', 'green': '#008000',
            'yellow': '#ffff00', 'black': '#000000', 'white': '#ffffff',
            'gray': '#808080', 'grey': '#808080',
            
            // Boutique / Saree Specific
            'maroon': '#800000', 'wine': '#722f37', 'navy': '#000080',
            'teal': '#008080', 'mustard': '#e1ad01', 'purple': '#800080',
            'brown': '#8b4513', 'magenta': '#ff00ff', 'olive': '#808000',
            
            // Luxury / Metallic
            'gold': '#d4af37', 'silver': '#c0c0c0', 'ivory': '#fffff0',
            'cream': '#fffdd0', 'beige': '#f5f5dc',
            
            // Pastels
            'peach': '#ffdab9', 'pink': '#ffc0cb', 'lavender': '#e6e6fa',
            'turquoise': '#40e0d0', 'orange': '#ffa500'
        };
        
        // Try exact match first
        if (colorMap[lowerColor]) {
            return colorMap[lowerColor];
        }
        
        // Try partial match (e.g., "Dark Maroon" will match "Maroon")
        for (const [key, value] of Object.entries(colorMap)) {
            if (lowerColor.includes(key)) {
                return value;
            }
        }
        
        return '#cccccc'; // Default fallback grey
    }


function addToCartFromQuickView() {
    if(!window.currentQvData) {
        alert('Please select a product first');
        return;
    }
    
    const productId = window.currentQvData.productId;
    const quantity = parseInt(document.getElementById('qv_qty').value) || 1;
    
    // Get selected color
    let selectedColor = 'Standard';
    const activeColor = document.querySelector('#qv_color_list li.active');
    if(activeColor) {
        const colorDot = activeColor.querySelector('a');
        if(colorDot) {
            selectedColor = colorDot.getAttribute('data-color') || 'Standard';
        }
    }
    
    // Get selected size
    let selectedSize = '';
    const activeSize = document.querySelector('#qv_size_list li.active:not(.out-of-stock)');
    if(activeSize) {
        const sizeLink = activeSize.querySelector('a');
        if(sizeLink) {
            selectedSize = sizeLink.getAttribute('data-size');
        }
    }
    
    if(!selectedSize) {
        alert('Please select a size');
        return;
    }
    
    const btn = document.getElementById('qv_add_to_cart');
    const originalText = btn.innerHTML;
    
    // Disable button and show loading
    btn.disabled = true;
    btn.innerHTML = '<i class="bx bx-loader bx-spin"></i> Adding...';
    
    // AJAX request
    const formData = new FormData();
    formData.append('action', 'add');
    formData.append('product_id', productId);
    formData.append('color', selectedColor);
    formData.append('size', selectedSize);
    formData.append('quantity', quantity);
    
    fetch('add-to-cart.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            btn.innerHTML = '<i class="bx bx-check"></i> Added!';
            updateCartCount(data.cart_count);
            
            setTimeout(() => {
                btn.innerHTML = originalText;
                btn.disabled = false;
                // Close modal after successful add
                const modal = bootstrap.Modal.getInstance(document.getElementById('productsQuickView'));
                if(modal) modal.hide();
            }, 1500);
        } else {
            alert(data.message);
            btn.innerHTML = originalText;
            btn.disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error adding to cart. Please try again.');
        btn.innerHTML = originalText;
        btn.disabled = false;
    });
}

// Add this function to update cart count
function updateCartCount(count) {
    const cartCounts = document.querySelectorAll('.cart-btn span');
    cartCounts.forEach(span => {
        span.textContent = count;
    });
}



// Quantity counter for quick view
document.addEventListener('DOMContentLoaded', function() {
    // Quick view quantity counter
    const qvModal = document.getElementById('productsQuickView');
    if (qvModal) {
        qvModal.addEventListener('show.bs.modal', function() {
            // Set up quantity controls
            const qvMinus = qvModal.querySelector('.minus-btn');
            const qvPlus = qvModal.querySelector('.plus-btn');
            const qvQtyInput = document.getElementById('qv_qty');
            
            if (qvMinus && qvPlus && qvQtyInput) {
                // Remove existing event listeners
                const newMinus = qvMinus.cloneNode(true);
                const newPlus = qvPlus.cloneNode(true);
                qvMinus.parentNode.replaceChild(newMinus, qvMinus);
                qvPlus.parentNode.replaceChild(newPlus, qvPlus);
                
                // Add new event listeners
                newMinus.addEventListener('click', function() {
                    let value = parseInt(qvQtyInput.value);
                    if (value > 1) {
                        qvQtyInput.value = value - 1;
                    }
                });
                
                newPlus.addEventListener('click', function() {
                    let value = parseInt(qvQtyInput.value);
                    let max = 99; // Default max
                    
                    // Get current stock based on selected size
                    const activeSize = document.querySelector('#qv_size_list li.active:not(.out-of-stock)');
                    if (activeSize) {
                        const sizeLink = activeSize.querySelector('a');
                        if (sizeLink) {
                            max = parseInt(sizeLink.getAttribute('data-stock')) || 99;
                        }
                    }
                    
                    if (value < max) {
                        qvQtyInput.value = value + 1;
                    }
                });
                
                // Validate manual input
                qvQtyInput.addEventListener('change', function() {
                    let value = parseInt(this.value);
                    let max = 99;
                    
                    // Get current stock
                    const activeSize = document.querySelector('#qv_size_list li.active:not(.out-of-stock)');
                    if (activeSize) {
                        const sizeLink = activeSize.querySelector('a');
                        if (sizeLink) {
                            max = parseInt(sizeLink.getAttribute('data-stock')) || 99;
                        }
                    }
                    
                    if (isNaN(value) || value < 1) {
                        this.value = 1;
                    } else if (value > max) {
                        this.value = max;
                    }
                });
            }
        });
    }
});


// Update cart count on page load
document.addEventListener('DOMContentLoaded', function() {
    fetch('add-to-cart.php?get_count=1')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                updateCartCount(data.cart_count);
            }
        })
        .catch(error => console.error('Error loading cart count:', error));
});
