/*==============================================================*/
// Xton Contact Form JS - FIXED
/*==============================================================*/
(function ($) {
    "use strict"; 
    $("#contactForm").validator().on("submit", function (event) {
        if (event.isDefaultPrevented()) {
            formError();
            submitMSG(false, "Did you fill in the form properly?");
        } else {
            event.preventDefault();
            submitForm();
        }
    });

    function submitForm(){
        // 1. Capture the variables (ADDED: subject)
        var name = $("#name").val();
        var email = $("#email").val();
        var phone_number = $("#phone_number").val();
        var subject = $("#subject").val(); // <--- FIXED: Now capturing subject
        var message = $("#message").val();

        $.ajax({
            type: "POST",
            url: "assets/php/form-process.php",
            // 2. Add subject to the data string
            data: "name=" + name + "&email=" + email + "&phone_number=" + phone_number + "&subject=" + subject + "&message=" + message,
            success : function(statustxt){
                if (statustxt == "success"){
                    formSuccess();
                } else {
                    formError();
                    submitMSG(false, statustxt);
                }
            }
        });
    }

    function formSuccess(){
        $("#contactForm")[0].reset();
        submitMSG(true, "Message Submitted!")
    }

    function formError(){
        $("#contactForm").removeClass().addClass('shake animated').one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function(){
            $(this).removeClass();
        });
    }

    function submitMSG(valid, msg){
        if(valid){
            var msgClasses = "h4 text-start tada animated text-success";
        } else {
            var msgClasses = "h4 text-start text-danger";
        }
        $("#msgSubmit").removeClass().addClass(msgClasses).text(msg);
    }
}(jQuery));