<?php
// /api/verify-payment.php
require_once '../includes/db.php';
require_once '../vendor/autoload.php';
require_once '../includes/mailer.php';

use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;

header('Content-Type: application/json');

// --- CONFIGURATION ---
$razorpay_key_id = 'rzp_test_RxizQDyxG1bASz';
$razorpay_key_secret = 'Y7O20oKHajdcjd2sjx1lMwvB';

$success = false;
$error = "Payment Failed";

// 1. Verify Signature
if (empty($_POST['razorpay_payment_id']) === false) {
    $api = new Api($razorpay_key_id, $razorpay_key_secret);

    try {
        $attributes = [
            'razorpay_order_id' => $_SESSION['razorpay_order_id'],
            'razorpay_payment_id' => $_POST['razorpay_payment_id'],
            'razorpay_signature' => $_POST['razorpay_signature']
        ];
        $api->utility->verifyPaymentSignature($attributes);
        $success = true; // Signature is valid
    } catch (SignatureVerificationError $e) {
        $success = false;
        $error = 'Razorpay Error : ' . $e->getMessage();
    }
}

// 2. If Signature is Verified, FINALIZE the order
if ($success === true) {
    // --- NEW: SERVER-SIDE DATA VALIDATION ---
    $required_fields = ['full_name', 'email', 'phone', 'address_1', 'city', 'pincode', 'state'];
    foreach ($required_fields as $field) {
        if (empty($_POST[$field])) {
            echo json_encode(['success' => false, 'message' => 'Critical Error: Missing Shipping Information. Please do not refresh the page during payment.']);
            exit;
        }
    }
    // --- DATABASE TRANSACTION (All or Nothing) ---
    $conn->begin_transaction();
    try {
        // A. Get all required data
        $user_id = $_SESSION['user_id'] ?? null;
        $shipping_details = json_encode($_POST);
        $payment_method = 'razorpay';
        $razorpay_order_id = $_SESSION['razorpay_order_id'];
        $razorpay_payment_id = $_POST['razorpay_payment_id'];

        $subtotal = 0;
        foreach ($_SESSION['checkout_items'] as $item) $subtotal += $item['price'] * $item['quantity'];

        // NEW: Get coupon data from session
        $coupon_code = $_SESSION['applied_coupon']['code'] ?? null;
        $discount = $_SESSION['applied_coupon']['discount'] ?? 0;
        $total_amount = $subtotal - $discount;

        // B. INSERT into `orders` table (with new coupon columns)
        $stmt_order = $conn->prepare("INSERT INTO orders (user_id, total_amount, coupon_used, discount_amount, payment_method, razorpay_order_id, razorpay_payment_id, payment_status, shipping_address_details) VALUES (?, ?, ?, ?, ?, ?, ?, 'Completed', ?)");
        $stmt_order->bind_param("idsdssss", $user_id, $total_amount, $coupon_code, $discount, $payment_method, $razorpay_order_id, $razorpay_payment_id, $shipping_details);
        $stmt_order->execute();
        $db_order_id = $conn->insert_id;

        // C. INSERT into `order_items` and DECREMENT stock
        $stmt_item = $conn->prepare("INSERT INTO order_items (order_id, product_id, quantity, size, color, price) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt_stock = $conn->prepare("UPDATE product_sizes SET stock_quantity = stock_quantity - ? WHERE product_id = ? AND color_group = ? AND size = ?");

        foreach ($_SESSION['checkout_items'] as $item) {
            $stmt_item->bind_param("iiisss", $db_order_id, $item['product_id'], $item['quantity'], $item['size'], $item['color'], $item['price']);
            $stmt_item->execute();

            $stmt_stock->bind_param("isss", $item['quantity'], $item['product_id'], $item['color'], $item['size']);
            $stmt_stock->execute();
        }

        // D. UPDATE coupon usage
        if (isset($_SESSION['applied_coupon']['id'])) {
            $coupon_id = $_SESSION['applied_coupon']['id'];
            $conn->query("UPDATE coupons SET used_count = used_count + 1 WHERE id = $coupon_id");
        }

        // E. COMMIT! 
        $conn->commit();

        // --- START ORDER CONFIRMATION EMAIL (Synchronous) ---
        $toEmail = sanitize_input($_POST['email']);
        $toName = sanitize_input($_POST['full_name']);
        $order_num = str_pad($db_order_id, 6, '0', STR_PAD_LEFT);
        $subject = "Order Confirmed! Your Miss.Sogasu Purchase #$order_num";

        // Generate Table Rows for Items
        $items_rows = "";
        foreach ($_SESSION['checkout_items'] as $item) {
            $price_fmt = number_format($item['price'], 2);
            $total_fmt = number_format($item['price'] * $item['quantity'], 2);
            $items_rows .= "
                <tr>
                    <td style='padding: 12px; border-bottom: 1px solid #eeeeee;'>
                        <span style='font-weight: bold; color: #111;'>{$item['name']}</span><br>
                        <small style='color: #666;'>Variation: {$item['color']} / {$item['size']}</small>
                    </td>
                    <td style='padding: 12px; border-bottom: 1px solid #eeeeee; text-align: center;'>{$item['quantity']}</td>
                    <td style='padding: 12px; border-bottom: 1px solid #eeeeee; text-align: right;'>₹{$total_fmt}</td>
                </tr>";
        }

        $htmlContent = "
            <div style='background-color: #fdfaf7; padding: 30px 10px; font-family: sans-serif;'>
                <div style='max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 10px rgba(0,0,0,0.05);'>
                    
                    <!-- Header -->
                    <div style='background-color: #111111; padding: 25px; text-align: center;'>
                        <img src='https://misssogasu.com/assets/img/logo2.png' alt='Miss.Sogasu' style='height: 50px;'>
                    </div>

                    <!-- Intro -->
                    <div style='padding: 30px; border-bottom: 1px solid #eeeeee;'>
                        <h2 style='color: #111; margin-top: 0;'>Thank you for your order, {$toName}!</h2>
                        <p style='color: #555; font-size: 15px;'>We've received your order and are getting it ready for shipment. Your order number is <strong>#$order_num</strong>.</p>
                    </div>

                    <!-- Items Table -->
                    <div style='padding: 20px 30px;'>
                        <table style='width: 100%; border-collapse: collapse; font-size: 14px;'>
                            <thead>
                                <tr style='background-color: #f8f8f8;'>
                                    <th style='padding: 12px; text-align: left;'>Product</th>
                                    <th style='padding: 12px; text-align: center;'>Qty</th>
                                    <th style='padding: 12px; text-align: right;'>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                $items_rows
                            </tbody>
                        </table>
                    </div>

                    <!-- Totals -->
                    <div style='padding: 0 30px 30px;'>
                        <div style='background-color: #fcfcfc; padding: 20px; border-radius: 5px;'>
                            <table style='width: 100%; font-size: 14px; color: #444;'>
                                <tr>
                                    <td style='padding: 5px 0;'>Subtotal:</td>
                                    <td style='text-align: right;'>₹" . number_format($subtotal, 2) . "</td>
                                </tr>" . ($discount > 0 ? "
                                <tr style='color: #da0103;'>
                                    <td style='padding: 5px 0;'>Coupon Discount:</td>
                                    <td style='text-align: right;'>-₹" . number_format($discount, 2) . "</td>
                                </tr>" : "") . "
                                <tr>
                                    <td style='padding: 5px 0;'>Shipping:</td>
                                    <td style='text-align: right;'>Free</td>
                                </tr>
                                <tr style='font-size: 18px; color: #da0103; font-weight: bold;'>
                                    <td style='padding: 15px 0 0;'>Order Total:</td>
                                    <td style='text-align: right; padding: 15px 0 0;'>₹" . number_format($total_amount, 2) . "</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div style='padding: 30px; text-align: center; background-color: #f8f9fa; color: #888; font-size: 12px;'>
                        <p><strong>Shipping Address:</strong><br>
                        {$_POST['address_1']}, {$_POST['city']}, {$_POST['state']} - {$_POST['pincode']}</p>
                        <hr style='border: 0; border-top: 1px solid #ddd; margin: 20px 0;'>
                        <p>Questions? Contact us at misssogasu@gmail.com or WhatsApp +91 8128708120</p>
                        <p>© 2026 Miss.Sogasu. Stay Stylish, Stay Sogasu.</p>
                    </div>
                </div>
            </div>";

        // Send Email
        sendSogasuEmail($toEmail, $toName, $subject, $htmlContent);
        // --- END ORDER CONFIRMATION EMAIL ---

        // F. Clean up session - SMART CLEANUP

        // 1. Always clear the checkout context
        unset($_SESSION['checkout_items']);
        unset($_SESSION['razorpay_order_id']);

        // 2. ONLY clear the main cart if this was a Standard Checkout
        if (isset($_SESSION['is_buy_now']) && $_SESSION['is_buy_now'] === true) {
            // Do NOT clear $_SESSION['cart'] or database cart
            // Just unset the flag
            unset($_SESSION['is_buy_now']);
        } else {
            // Standard Checkout: Clear Main Cart
            unset($_SESSION['cart']);

            // Also Clear Database Cart if logged in
            if (isset($_SESSION['user_id'])) {
                $uid = $_SESSION['user_id'];
                $conn->query("DELETE FROM cart WHERE user_id = $uid");
            }
        }

        // Coupon is consumed in both cases
        unset($_SESSION['applied_coupon']);

        // G. Store success order ID for success page
        $_SESSION['success_order_id'] = $db_order_id;

        echo json_encode(['success' => true, 'order_id' => $db_order_id]);
        exit;
    } catch (Exception $e) {
        // Something went wrong, rollback all database changes
        $conn->rollback();
        echo json_encode(['success' => false, 'message' => 'Database Error: ' . $e->getMessage()]);
        exit;
    }
} else {
    echo json_encode(['success' => false, 'message' => $error]);
    exit;
}
