<?php
// api/send-welcome.php
require_once '../includes/db.php';
require_once '../includes/mailer.php';

header('Content-Type: application/json');

// Only proceed if the trigger flag is set in the session
if (isset($_SESSION['trigger_welcome_email']) && $_SESSION['trigger_welcome_email'] === true) {

    $toEmail = $_SESSION['user_email'];
    $toName = $_SESSION['user_name'];
    // 1. Use a simple hyphen in the subject to prevent encoding issues
    $subject = "Welcome to Miss.Sogasu - Your Journey to Elegance Begins";

    // 2. Updated HTML Content
    $htmlContent = "
    <div style='background-color: #fdfaf7; padding: 40px 20px; font-family: sans-serif;'>
        <div style='max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 15px rgba(0,0,0,0.05);'>
            
            <!-- Fixed Logo Container -->
            <div style='background-color: #111111; padding: 20px; text-align: center;'>
                <a href='https://misssogasu.com' target='_blank'>
                    <!-- Check your filename: is it logo2.png or logo.png? -->
                    <img src='https://misssogasu.com/assets/img/logo2.png' alt='Miss.Sogasu' style='display: block; margin: 0 auto; height: 60px; max-width: 200px;' border='0'>
                </a>
            </div>
            
            <!-- Body -->
            <div style='padding: 40px 30px; color: #333333; line-height: 1.6;'>
                <h2 style='color: #111111; margin-top: 0; font-size: 24px;'>Welcome, {$toName}!</h2>
                <p style='font-size: 16px;'>We are delighted to have you join <strong>Miss.Sogasu</strong>. Explore our latest handpicked designs and start your collection today.</p>
                
                <div style='text-align: center; margin: 35px 0;'>
                    <a href='https://misssogasu.com/products.php' style='background-color: #da0103; color: #ffffff; padding: 15px 35px; text-decoration: none; border-radius: 5px; font-weight: bold; font-size: 16px; display: inline-block;'>Explore the Lookbook</a>
                </div>
                
                <hr style='border: 0; border-top: 1px solid #eeeeee; margin: 30px 0;'>
                
                <p style='font-size: 13px; color: #888888; text-align: center;'>
                    Stay Stylish. Stay Sogasu. <br>
                    © 2026 Miss.Sogasu
                </p>
            </div>
        </div>
    </div>
";

    $sent = sendSogasuEmail($toEmail, $toName, $subject, $htmlContent);

    if ($sent) {
        unset($_SESSION['trigger_welcome_email']);
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Mail delivery failed']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'No trigger found']);
}
