<?php
// api/send-reset.php
require_once '../includes/db.php';
require_once '../includes/mailer.php';

header('Content-Type: application/json');

if (isset($_SESSION['trigger_reset_email']) && $_SESSION['trigger_reset_email'] === true) {
    
    $toEmail = $_SESSION['reset_email'];
    $resetLink = $_SESSION['reset_link'];
    $subject = "Password Reset Request - Miss.Sogasu";
    
    $htmlContent = "
        <div style='background-color: #fdfaf7; padding: 40px 20px; font-family: sans-serif;'>
            <div style='max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 15px rgba(0,0,0,0.05);'>
                
                <!-- Logo -->
                <div style='background-color: #111111; padding: 20px; text-align: center;'>
                    <img src='https://misssogasu.com/assets/img/logo2.png' alt='Miss.Sogasu' style='height: 50px;'>
                </div>
                
                <!-- Body -->
                <div style='padding: 40px 30px; color: #333333; line-height: 1.6;'>
                    <h2 style='color: #111111; margin-top: 0;'>Password Reset Request</h2>
                    <p>Hello,</p>
                    <p>We received a request to reset the password for your Miss.Sogasu account. If you did not make this request, you can safely ignore this email.</p>
                    
                    <p>To create a new password, click the button below. This link is valid for <strong>1 hour</strong>.</p>
                    
                    <div style='text-align: center; margin: 35px 0;'>
                        <a href='{$resetLink}' style='background-color: #da0103; color: #ffffff; padding: 15px 35px; text-decoration: none; border-radius: 5px; font-weight: bold; font-size: 16px; display: inline-block;'>Reset My Password</a>
                    </div>
                    
                    <p style='font-size: 13px; color: #888888;'>If the button doesn't work, copy and paste this link into your browser:<br>{$resetLink}</p>
                    
                    <hr style='border: 0; border-top: 1px solid #eeeeee; margin: 30px 0;'>
                    <p style='font-size: 13px; color: #888888; text-align: center;'>Stay Stylish. Stay Sogasu.</p>
                </div>
            </div>
        </div>
    ";

    $sent = sendSogasuEmail($toEmail, 'Customer', $subject, $htmlContent);

    if ($sent) {
        unset($_SESSION['trigger_reset_email']);
        unset($_SESSION['reset_email']);
        unset($_SESSION['reset_link']);
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}