<?php
// /api/create-order.php
require_once '../includes/db.php';
require_once '../vendor/autoload.php'; // Path to Composer's autoload

use Razorpay\Api\Api;

header('Content-Type: application/json');

// --- CONFIGURATION ---
$razorpay_key_id = 'rzp_test_RxizQDyxG1bASz'; // Replace with your Test Key ID
$razorpay_key_secret = 'Y7O20oKHajdcjd2sjx1lMwvB'; // Replace with your Test Key Secret

if (empty($_SESSION['checkout_items'])) {
    echo json_encode(['success' => false, 'message' => 'No items to checkout.']);
    exit;
}

// 1. Calculate the final, trustworthy total
$subtotal = 0;
// UPDATE: Loop through checkout_items
foreach ($_SESSION['checkout_items'] as $item) {
    $subtotal += $item['price'] * $item['quantity'];
}
$discount = $_SESSION['applied_coupon']['discount'] ?? 0;
$total_amount = $subtotal - $discount;

// Razorpay requires amount in the smallest currency unit (e.g., paise for INR)
$total_in_paise = round($total_amount * 100);

// 2. Create Razorpay Order
try {
    $api = new Api($razorpay_key_id, $razorpay_key_secret);

    $orderData = [
        'receipt'         => 'rcptid_' . uniqid(),
        'amount'          => $total_in_paise,
        'currency'        => 'INR',
        'payment_capture' => 1 // Auto-capture the payment
    ];

    $razorpayOrder = $api->order->create($orderData);
    $razorpayOrderId = $razorpayOrder['id'];

    // Store order ID in session to verify on the next step
    $_SESSION['razorpay_order_id'] = $razorpayOrderId;
    
    // Also store user info if logged in, for display on Razorpay modal
    $user_data = [];
    if(isset($_SESSION['user_id'])) {
        $user_id = $_SESSION['user_id'];
        $user_res = $conn->query("SELECT full_name, email, phone FROM users WHERE id = $user_id");
        if($user_res->num_rows > 0) {
            $user_data = $user_res->fetch_assoc();
        }
    }

    echo json_encode([
        'success'   => true,
        'order_id'  => $razorpayOrderId,
        'amount'    => $total_in_paise,
        'key'       => $razorpay_key_id,
        'user_data' => $user_data // Send user data for pre-fill
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Razorpay Error: ' . $e->getMessage()]);
    exit;
}
?>