<?php
require_once 'includes/db_config.php';
check_login();

// --- 1. CONFIGURATION ---
// Social Media Master List (for icons)
$all_social_options = [
    'whatsapp'   => ['icon' => 'bx bxl-whatsapp',   'prefix' => 'https://wa.me/'],
    'instagram'  => ['icon' => 'bx bxl-instagram',  'prefix' => 'https://www.instagram.com/'],
    'facebook'   => ['icon' => 'bx bxl-facebook',   'prefix' => 'https://www.facebook.com/'],
    'youtube'    => ['icon' => 'bx bxl-youtube',    'prefix' => 'https://www.youtube.com/'],
    'telegram'   => ['icon' => 'bx bxl-telegram',   'prefix' => 'https://t.me/'],
    'phone'      => ['icon' => 'bx bx-phone',       'prefix' => 'tel:'],
    'email'      => ['icon' => 'bx bx-envelope',    'prefix' => 'mailto:']
];
$allowed_in_dropdown = array_keys($all_social_options);

// Flash Message Helper
$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

// --- 2. HANDLE POST REQUESTS ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // A. Global Topbar Toggle
    if (isset($_POST['toggle_topbar_status'])) {
        $new_status = $_POST['current_status'] == 1 ? 0 : 1;
        $conn->query("UPDATE site_settings SET setting_value = '$new_status' WHERE setting_key = 'topbar_enabled'");
        $_SESSION['flash_message'] = '<div class="alert alert-success">Top bar visibility updated.</div>';
    }

    // B. Announcement Messages (Add/Update)
    elseif (isset($_POST['save_message'])) {
        $id = (int)$_POST['msg_id'];
        $title = sanitize_input($_POST['title']);
        $display_order = (int)$_POST['display_order'];
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        if (empty($title)) {
            $_SESSION['flash_message'] = '<div class="alert alert-danger">Message text is required.</div>';
        } else {
            if ($id > 0) {
                // Update
                $stmt = $conn->prepare("UPDATE homepage_topbar SET title=?, display_order=?, is_active=? WHERE id=?");
                $stmt->bind_param("siii", $title, $display_order, $is_active, $id);
                $stmt->execute();
                $_SESSION['flash_message'] = '<div class="alert alert-success">Message updated.</div>';
            } else {
                // Insert
                $stmt = $conn->prepare("INSERT INTO homepage_topbar (title, display_order, is_active) VALUES (?, ?, ?)");
                $stmt->bind_param("sii", $title, $display_order, $is_active);
                $stmt->execute();
                $_SESSION['flash_message'] = '<div class="alert alert-success">New message added.</div>';
            }
        }
    }

    // C. Social Links (Add/Update)
    elseif (isset($_POST['save_social_link'])) {
        $id = (int)$_POST['social_id'];
        $type = sanitize_input($_POST['social_media_type']);
        $handle_or_url = sanitize_input($_POST['handle_or_url']);

        // Intelligent URL Handling
        if (filter_var($handle_or_url, FILTER_VALIDATE_URL)) {
            $full_url = $handle_or_url;
        } else {
            $prefix = $all_social_options[$type]['prefix'] ?? '';
            $full_url = $prefix . $handle_or_url;
        }

        $display_order = (int)$_POST['display_order'];
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        if ($id > 0) {
            $stmt = $conn->prepare("UPDATE social_links SET social_media_type=?, link_url=?, display_order=?, is_active=? WHERE id=?");
            $stmt->bind_param("ssiii", $type, $full_url, $display_order, $is_active, $id);
        } else {
            $stmt = $conn->prepare("INSERT INTO social_links (social_media_type, link_url, display_order, is_active) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssii", $type, $full_url, $display_order, $is_active);
        }
        $stmt->execute();
        $_SESSION['flash_message'] = '<div class="alert alert-success">Social link saved.</div>';
    }

    header("Location: topbar.php");
    exit;
}

// --- 3. HANDLE DELETE REQUESTS ---
if (isset($_GET['delete_msg']) && ($id = (int)$_GET['delete_msg'])) {
    $conn->query("DELETE FROM homepage_topbar WHERE id = $id");
    $_SESSION['flash_message'] = '<div class="alert alert-success">Message deleted.</div>';
    header("Location: topbar.php");
    exit;
}

if (isset($_GET['delete_social']) && ($id = (int)$_GET['delete_social'])) {
    $conn->query("DELETE FROM social_links WHERE id = $id");
    $_SESSION['flash_message'] = '<div class="alert alert-success">Social link deleted.</div>';
    header("Location: topbar.php");
    exit;
}

// --- 4. FETCH DATA ---
$topbar_enabled = $conn->query("SELECT setting_value FROM site_settings WHERE setting_key = 'topbar_enabled'")->fetch_assoc()['setting_value'] ?? 0;
$messages = $conn->query("SELECT * FROM homepage_topbar ORDER BY display_order ASC");
$social_links = $conn->query("SELECT * FROM social_links ORDER BY display_order ASC");

// Fetch Edit Data (Message)
$edit_msg_data = null;
if (isset($_GET['edit_msg'])) {
    $id = (int)$_GET['edit_msg'];
    $edit_msg_data = $conn->query("SELECT * FROM homepage_topbar WHERE id = $id")->fetch_assoc();
}

// Fetch Edit Data (Social)
$edit_social_data = null;
$edit_handle = '';
if (isset($_GET['edit_social'])) {
    $id = (int)$_GET['edit_social'];
    $edit_social_data = $conn->query("SELECT * FROM social_links WHERE id = $id")->fetch_assoc();
    if ($edit_social_data) {
        $prefix = $all_social_options[$edit_social_data['social_media_type']]['prefix'] ?? '';
        $edit_handle = str_replace($prefix, '', $edit_social_data['link_url']);
    }
}

$page_title = "Top Bar Management";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <div class="page-title-box">
        <h2 class="page-title"><i class="fas fa-bullhorn"></i> Top Bar Management</h2>
        <p class="text-muted">Control the sliding announcements and social media links.</p>
    </div>

    <?= $message ?>

    <!-- 1. GLOBAL VISIBILITY -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-light border-0 shadow-sm">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 text-dark">Global Visibility</h5>
                    <form method="POST" class="mb-0">
                        <input type="hidden" name="current_status" value="<?= $topbar_enabled ?>">
                        <button type="submit" name="toggle_topbar_status" class="btn <?= $topbar_enabled ? 'btn-success' : 'btn-danger' ?>">
                            <i class="fas <?= $topbar_enabled ? 'fa-eye' : 'fa-eye-slash' ?> mr-2"></i>
                            Topbar is <?= $topbar_enabled ? 'VISIBLE' : 'HIDDEN' ?>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <!-- 2. ANNOUNCEMENT MESSAGES (Left Column) -->
        <div class="col-lg-12">
            <!-- Add/Edit Form -->
            <div class="card mb-4" id="msgForm">
                <div class="card-header card-header-custom">
                    <h5 class="mb-0"><?= $edit_msg_data ? 'Edit' : 'Add' ?> Announcement</h5>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <input type="hidden" name="msg_id" value="<?= $edit_msg_data['id'] ?? 0 ?>">

                        <div class="form-group">
                            <label class="font-weight-bold">Message Text</label>
                            <textarea name="title" class="form-control" rows="2" placeholder="e.g. Free Shipping on orders over ₹1999" required><?= htmlspecialchars($edit_msg_data['title'] ?? '') ?></textarea>
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label>Order</label>
                                    <input type="number" name="display_order" class="form-control" value="<?= $edit_msg_data['display_order'] ?? 0 ?>">
                                </div>
                            </div>
                            <div class="col-6 pt-4">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="msgActive" name="is_active" value="1" <?= (!isset($edit_msg_data) || $edit_msg_data['is_active']) ? 'checked' : '' ?>>
                                    <label class="custom-control-label font-weight-bold" for="msgActive">Active</label>
                                </div>
                            </div>
                        </div>

                        <button type="submit" name="save_message" class="btn btn-primary btn-block">
                            <?= $edit_msg_data ? 'Update' : 'Add' ?> Message
                        </button>
                        <?php if ($edit_msg_data): ?><a href="topbar.php" class="btn btn-secondary btn-block mt-2">Cancel</a><?php endif; ?>
                    </form>
                </div>
            </div>

            <!-- Existing Messages List -->
            <div class="card">
                <div class="card-header card-header-custom bg-secondary">
                    <h5 class="mb-0">Active Announcements</h5>
                </div>
                <div class="card-body card-body-no-padding">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Order</th>
                                    <th>Text</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($messages->num_rows > 0): while ($row = $messages->fetch_assoc()): ?>
                                        <tr>
                                            <td><?= $row['display_order'] ?></td>
                                            <td>
                                                <?= htmlspecialchars($row['title']) ?>
                                            </td>
                                            <td>
                                                <?php if (!$row['is_active']): ?>
                                                    <span class="badge badge-secondary">Hidden</span>
                                                <?php else: ?>
                                                    <span class="badge badge-success">Active</span>
                                                <?php endif; ?>
                                            </td>

                                            <td>
                                                <a href="topbar.php?edit_msg=<?= $row['id'] ?>#msgForm" class="btn btn-sm btn-info"><i class="fas fa-edit"></i></a>
                                                <a href="topbar.php?delete_msg=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete?')"><i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    <?php endwhile;
                                else: ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted">No messages found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- 3. SOCIAL LINKS (Right Column) -->
        <div class="col-lg-12">
            <!-- Add/Edit Form -->
            <div class="card mb-4" id="socialForm">
                <div class="card-header card-header-custom">
                    <h5 class="mb-0"><?= $edit_social_data ? 'Edit' : 'Add' ?> Social Link</h5>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <input type="hidden" name="social_id" value="<?= $edit_social_data['id'] ?? 0 ?>">

                        <div class="form-row">
                            <div class="col-md-6 form-group">
                                <label>Platform</label>
                                <select name="social_media_type" class="form-control" required>
                                    <option value="">-- Select --</option>
                                    <?php foreach ($all_social_options as $type => $details): ?>
                                        <option value="<?= $type ?>" <?= (isset($edit_social_data['social_media_type']) && $edit_social_data['social_media_type'] == $type) ? 'selected' : '' ?>>
                                            <?= ucfirst($type) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6 form-group">
                                <label>Handle / URL</label>
                                <input type="text" name="handle_or_url" class="form-control" value="<?= htmlspecialchars($edit_handle) ?>" placeholder="e.g. misssogasu" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label>Order</label>
                                    <input type="number" name="display_order" class="form-control" value="<?= $edit_social_data['display_order'] ?? 0 ?>">
                                </div>
                            </div>
                            <div class="col-6 pt-4">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="socialActive" name="is_active" value="1" <?= (!isset($edit_social_data) || $edit_social_data['is_active']) ? 'checked' : '' ?>>
                                    <label class="custom-control-label font-weight-bold" for="socialActive">Active</label>
                                </div>
                            </div>
                        </div>

                        <button type="submit" name="save_social_link" class="btn btn-primary btn-block">
                            <?= $edit_social_data ? 'Update' : 'Add' ?> Link
                        </button>
                        <?php if ($edit_social_data): ?><a href="topbar.php" class="btn btn-secondary btn-block mt-2">Cancel</a><?php endif; ?>
                    </form>
                </div>
            </div>

            <!-- Existing Links List -->
            <div class="card">
                <div class="card-header card-header-custom bg-secondary">
                    <h5 class="mb-0">Active Social Links</h5>
                </div>
                <div class="card-body card-body-no-padding">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Order</th>
                                    <th>Icon</th>
                                    <th>Link</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($social_links->num_rows > 0): while ($link = $social_links->fetch_assoc()): ?>
                                        <tr>
                                            <td><?= $link['display_order'] ?></td>
                                            <td><i class='<?= $all_social_options[$link['social_media_type']]['icon'] ?? 'bx bx-link' ?>' style="font-size: 1.2rem;"></i></td>
                                            <td><small class="text-muted"><?= substr(htmlspecialchars($link['link_url']), 0, 25) ?>...</small></td>
                                            <td>
                                                <?php if (!$link['is_active']): ?><span class="badge badge-secondary">Hidden</span><?php else: ?><span class="badge badge-success">Active</span><?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="topbar.php?edit_social=<?= $link['id'] ?>#socialForm" class="btn btn-sm btn-info"><i class="fas fa-edit"></i></a>
                                                <a href="topbar.php?delete_social=<?= $link['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete?')"><i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                    <?php endwhile;
                                else: ?>
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">No links found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php include 'includes/admin_footer.php'; ?>