<?php
require_once 'includes/db_config.php';
check_login();

// --- 1. HANDLE DELETE ---
if (isset($_GET['delete']) && ($id = (int)$_GET['delete'])) {
    $conn->query("DELETE FROM testimonials WHERE id = $id");
    $_SESSION['flash_message'] = '<div class="alert alert-success">Testimonial deleted.</div>';
    header("Location: testimonials.php");
    exit;
}

// --- 2. HANDLE POST (ADD/UPDATE) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $name     = sanitize_input($_POST['author_name']);
    $position = sanitize_input($_POST['author_position']);
    $quote    = sanitize_input($_POST['quote']);
    $rating   = (int)$_POST['rating'];
    $order    = (int)$_POST['display_order'];
    $active   = isset($_POST['is_active']) ? 1 : 0;

    if ($action === 'add') {
        $stmt = $conn->prepare("INSERT INTO testimonials (author_name, author_position, quote, rating, display_order, is_active) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssiis", $name, $position, $quote, $rating, $order, $active);
        $stmt->execute();
        $_SESSION['flash_message'] = '<div class="alert alert-success">New testimonial added!</div>';
    } elseif ($action === 'update') {
        $id = (int)$_POST['id'];
        $stmt = $conn->prepare("UPDATE testimonials SET author_name=?, author_position=?, quote=?, rating=?, display_order=?, is_active=? WHERE id=?");
        $stmt->bind_param("sssiisi", $name, $position, $quote, $rating, $order, $active, $id);
        $stmt->execute();
        $_SESSION['flash_message'] = '<div class="alert alert-success">Testimonial updated!</div>';
    }

    header("Location: testimonials.php");
    exit;
}

$testimonials = $conn->query("SELECT * FROM testimonials ORDER BY display_order ASC, id DESC");
$page_title = "Manage Testimonials";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <div class="d-flex align-items-center justify-content-between mb-4 flex-wrap" style="gap: 15px;">
        <div class="page-title-box mb-0">
            <h2 class="page-title mb-1"><i class="fas fa-comment-dots"></i> Customer Testimonials</h2>
            <p class="text-muted mb-0">Manage feedback from your clients to show on the website.</p>
        </div>
        <button class="btn btn-primary" data-toggle="modal" data-target="#addModal">
            <i class="fas fa-plus"></i> Add Testimonial
        </button>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <?= $_SESSION['flash_message'];
        unset($_SESSION['flash_message']); ?>
    <?php endif; ?>

    <div class="card shadow-sm">
        <div class="card-body card-body-no-padding">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th>Author</th>
                            <th>Quote</th>
                            <th class="text-center">Rating</th>
                            <th class="text-center">Status</th>
                            <th class="text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($testimonials->num_rows > 0): ?>
                            <?php while ($row = $testimonials->fetch_assoc()): ?>
                                <tr>
                                    <td>
                                        <div class="font-weight-bold"><?= htmlspecialchars($row['author_name']) ?></div>
                                        <div class="small text-muted"><?= htmlspecialchars($row['author_position']) ?></div>
                                    </td>
                                    <td>
                                        <p class="mb-0 text-muted" style="max-width: 400px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                            "<?= htmlspecialchars($row['quote']) ?>"
                                        </p>
                                    </td>
                                    <td class="text-center text-warning">
                                        <?php for ($i = 1; $i <= 5; $i++) echo ($i <= $row['rating']) ? '★' : '☆'; ?>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge badge-<?= $row['is_active'] ? 'success' : 'secondary' ?>"><?= $row['is_active'] ? 'Active' : 'Hidden' ?></span>
                                    </td>
                                    <td class="text-right">
                                        <div class="action-buttons">
                                            <button class="btn btn-sm btn-info" data-toggle="modal" data-target="#editModal<?= $row['id'] ?>"><i class="fas fa-edit"></i></button>
                                            <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete?');"><i class="fas fa-trash"></i></a>
                                        </div>
                                    </td>
                                </tr>

                                <!-- EDIT MODAL -->
                                <div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1">
                                    <div class="modal-dialog modal-lg modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header card-header-custom">
                                                <h5 class="modal-title">Edit Testimonial</h5><button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                            </div>
                                            <form method="POST">
                                                <input type="hidden" name="action" value="update">
                                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group"><label>Author Name</label><input type="text" class="form-control" name="author_name" value="<?= htmlspecialchars($row['author_name']) ?>" required></div>
                                                            <div class="form-group"><label>Author Position</label><input type="text" class="form-control" name="author_position" value="<?= htmlspecialchars($row['author_position']) ?>" required></div>
                                                            <div class="form-group"><label>Rating</label><select name="rating" class="form-control"><?php for ($i = 5; $i >= 1; $i--) echo "<option value='$i'" . ($row['rating'] == $i ? 'selected' : '') . ">$i Stars</option>"; ?></select></div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group"><label>Quote Text</label><textarea class="form-control" name="quote" rows="5" required><?= htmlspecialchars($row['quote']) ?></textarea></div>
                                                            <div class="row">
                                                                <div class="col-6">
                                                                    <div class="form-group"><label>Display Order</label><input type="number" class="form-control" name="display_order" value="<?= $row['display_order'] ?>"></div>
                                                                </div>
                                                                <div class="col-6">
                                                                    <div class="custom-control custom-switch mt-4"><input type="checkbox" class="custom-control-input" id="act<?= $row['id'] ?>" name="is_active" <?= $row['is_active'] ? 'checked' : '' ?>><label class="custom-control-label" for="act<?= $row['id'] ?>">Active</label></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer"><button type="submit" class="btn btn-primary px-4">Update</button></div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center py-5 text-muted">No testimonials found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- ADD MODAL -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header card-header-custom">
                <h5 class="modal-title">New Testimonial</h5><button type="button" class="close text-white" data-dismiss="modal">&times;</button>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group"><label>Author Name</label><input type="text" class="form-control" name="author_name" placeholder="e.g. Raya" required></div>
                            <div class="form-group"><label>Author Position</label><input type="text" class="form-control" name="author_position" value="Verified Buyer" required></div>
                            <div class="form-group"><label>Rating</label><select name="rating" class="form-control">
                                    <option value="5">5 Stars</option>
                                    <option value="4">4 Stars</option>
                                    <option value="3">3 Stars</option>
                                    <option value="2">2 Stars</option>
                                    <option value="1">1 Star</option>
                                </select></div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group"><label>Quote Text</label><textarea class="form-control" name="quote" rows="5" placeholder="Write the testimonial here..." required></textarea></div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group"><label>Display Order</label><input type="number" class="form-control" name="display_order" value="0"></div>
                                </div>
                                <div class="col-6">
                                    <div class="custom-control custom-switch mt-4"><input type="checkbox" class="custom-control-input" id="actNew" name="is_active" checked><label class="custom-control-label" for="actNew">Active</label></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer"><button type="submit" class="btn btn-primary px-4">Save Testimonial</button></div>
            </form>
        </div>
    </div>
</div>

<?php include 'includes/admin_footer.php'; ?>