<?php
require_once 'includes/db_config.php';
check_login();

// --- PRG Pattern: Flash Messages ---
$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

// --- HANDLE FORM SUBMISSION ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // 1. Text Fields (General, SEO, Contact)
    $text_fields = [
        'site_title', 'site_description', 'site_keywords', 
        'contact_phone', 'contact_email', 'contact_address', 
        'map_iframe',
        // Social URLs
        'social_facebook', 'social_instagram', 'social_twitter', 'social_youtube', 'social_telegram'
    ];

    foreach ($text_fields as $key) {
        if (isset($_POST[$key])) {
            $val = $conn->real_escape_string($_POST[$key]);
            $conn->query("INSERT INTO site_settings (setting_key, setting_value) VALUES ('$key', '$val') ON DUPLICATE KEY UPDATE setting_value='$val'");
        }
    }

    // 2. Social Status (Toggles)
    $status_fields = [
        'social_facebook_status', 'social_instagram_status', 'social_twitter_status', 'social_youtube_status', 'social_telegram_status'
    ];

    foreach ($status_fields as $key) {
        // Switch: if sent in POST, value is 1, otherwise 0
        $val = isset($_POST[$key]) ? '1' : '0';
        $conn->query("INSERT INTO site_settings (setting_key, setting_value) VALUES ('$key', '$val') ON DUPLICATE KEY UPDATE setting_value='$val'");
    }

    $_SESSION['flash_message'] = '<div class="alert alert-success alert-dismissible fade show"><strong>Success!</strong> Website settings updated successfully.<button type="button" class="close" data-dismiss="alert"><span>&times;</span></button></div>';
    header("Location: settings.php");
    exit;
}

// --- FETCH CURRENT SETTINGS ---
$settings = [];
$res = $conn->query("SELECT * FROM site_settings");
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}

// Helper: Get Value
function get_val($key, $data) {
    return isset($data[$key]) ? htmlspecialchars($data[$key]) : '';
}

// Helper: Check Toggle Status
function is_active($key, $data) {
    return (isset($data[$key]) && $data[$key] == '1') ? 'checked' : '';
}

$page_title = "Website Settings";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <div class="page-title-box">
        <h2 class="page-title"><i class="fas fa-cogs"></i> Website Settings</h2>
        <p class="text-muted">Manage global configurations, contact info, and footer social links.</p>
    </div>

    <?= $message ?>

    <form method="POST" enctype="multipart/form-data">
        <div class="row">
            
            <!-- LEFT COLUMN: General & Contact -->
            <div class="col-lg-7">
                
                <!-- 1. General & SEO -->
                <div class="card mb-4">
                    <div class="card-header card-header-custom">
                        <h5 class="mb-0"><i class="fas fa-globe"></i> General & SEO</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label>Website Title</label>
                            <input type="text" class="form-control" name="site_title" value="<?php echo get_val('site_title', $settings); ?>" placeholder="e.g. Miss.Sogasu">
                        </div>
                        <div class="form-group">
                            <label>Meta Description</label>
                            <textarea class="form-control" name="site_description" rows="3" placeholder="Short description for search engines..."><?php echo get_val('site_description', $settings); ?></textarea>
                        </div>
                        <div class="form-group mb-0">
                            <label>Meta Keywords</label>
                            <input type="text" class="form-control" name="site_keywords" value="<?php echo get_val('site_keywords', $settings); ?>" placeholder="fashion, dresses, women clothing...">
                        </div>
                    </div>
                </div>

                <!-- 2. Contact Information -->
                <div class="card mb-4">
                    <div class="card-header card-header-custom">
                        <h5 class="mb-0"><i class="fas fa-address-card"></i> Contact Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Phone Number</label>
                                    <input type="text" class="form-control" name="contact_phone" value="<?php echo get_val('contact_phone', $settings); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Email Address</label>
                                    <input type="email" class="form-control" name="contact_email" value="<?php echo get_val('contact_email', $settings); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Physical Address</label>
                            <textarea class="form-control" name="contact_address" rows="2"><?php echo get_val('contact_address', $settings); ?></textarea>
                        </div>
                        <div class="form-group mb-0">
                            <label>Google Map Iframe Code (Embed URL)</label>
                            <textarea class="form-control" name="map_iframe" rows="3" placeholder='<iframe src="..."></iframe>'><?php echo get_val('map_iframe', $settings); ?></textarea>
                        </div>
                    </div>
                </div>

            </div>

            <!-- RIGHT COLUMN: Social Media -->
            <div class="col-lg-5">
                <div class="card mb-4">
                    <div class="card-header card-header-custom">
                        <h5 class="mb-0"><i class="fas fa-share-alt"></i> Social Media Links</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted small mb-4">Enable the platforms you want to display in the website footer.</p>

                        <!-- Facebook -->
                        <div class="form-group border-bottom pb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <label class="mb-0"><i class="fab fa-facebook text-primary mr-2"></i> Facebook</label>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="social_facebook_status" name="social_facebook_status" value="1" <?php echo is_active('social_facebook_status', $settings); ?>>
                                    <label class="custom-control-label" for="social_facebook_status">Active</label>
                                </div>
                            </div>
                            <input type="text" class="form-control" name="social_facebook" value="<?php echo get_val('social_facebook', $settings); ?>" placeholder="https://facebook.com/...">
                        </div>

                        <!-- Instagram -->
                        <div class="form-group border-bottom pb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <label class="mb-0"><i class="fab fa-instagram text-danger mr-2"></i> Instagram</label>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="social_instagram_status" name="social_instagram_status" value="1" <?php echo is_active('social_instagram_status', $settings); ?>>
                                    <label class="custom-control-label" for="social_instagram_status">Active</label>
                                </div>
                            </div>
                            <input type="text" class="form-control" name="social_instagram" value="<?php echo get_val('social_instagram', $settings); ?>" placeholder="https://instagram.com/...">
                        </div>

                        <!-- Twitter -->
                        <div class="form-group border-bottom pb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <label class="mb-0"><i class="fab fa-twitter text-info mr-2"></i> Twitter (X)</label>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="social_twitter_status" name="social_twitter_status" value="1" <?php echo is_active('social_twitter_status', $settings); ?>>
                                    <label class="custom-control-label" for="social_twitter_status">Active</label>
                                </div>
                            </div>
                            <input type="text" class="form-control" name="social_twitter" value="<?php echo get_val('social_twitter', $settings); ?>" placeholder="https://twitter.com/...">
                        </div>

                        <!-- YouTube -->
                        <div class="form-group border-bottom pb-3">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <label class="mb-0"><i class="fab fa-youtube text-danger mr-2"></i> YouTube</label>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="social_youtube_status" name="social_youtube_status" value="1" <?php echo is_active('social_youtube_status', $settings); ?>>
                                    <label class="custom-control-label" for="social_youtube_status">Active</label>
                                </div>
                            </div>
                            <input type="text" class="form-control" name="social_youtube" value="<?php echo get_val('social_youtube', $settings); ?>" placeholder="https://youtube.com/...">
                        </div>

                        <!-- Telegram -->
                        <div class="form-group mb-0">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <label class="mb-0"><i class="fab fa-telegram text-info mr-2"></i> Telegram</label>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="social_telegram_status" name="social_telegram_status" value="1" <?php echo is_active('social_telegram_status', $settings); ?>>
                                    <label class="custom-control-label" for="social_telegram_status">Active</label>
                                </div>
                            </div>
                            <input type="text" class="form-control" name="social_telegram" value="<?php echo get_val('social_telegram', $settings); ?>" placeholder="https://t.me/...">
                        </div>
                    </div>
                </div>
            </div>

            <!-- ACTION BUTTON -->
            <div class="col-12 text-right mb-5">
                <button type="submit" class="btn btn-primary btn-lg px-5">
                    <i class="fas fa-save"></i> Save All Settings
                </button>
            </div>

        </div>
    </form>
</div>

<?php include 'includes/admin_footer.php'; ?>