<?php
require_once 'includes/db_config.php';
check_login();

// --- 1. HANDLE DELETE ---
if (isset($_GET['delete']) && ($id = (int)$_GET['delete'])) {
    $img_res = $conn->query("SELECT image_path FROM product_images WHERE product_id = $id");
    while($row = $img_res->fetch_assoc()) {
        if(!empty($row['image_path']) && file_exists('../' . $row['image_path'])) {
            @unlink('../' . $row['image_path']);
        }
    }
    $conn->query("DELETE FROM product_images WHERE product_id = $id");
    $conn->query("DELETE FROM product_sizes WHERE product_id = $id");
    $conn->query("DELETE FROM products WHERE id = $id");
    
    $_SESSION['flash_message'] = '<div class="alert alert-success">Product deleted successfully.</div>';
    header("Location: products.php");
    exit;
}

// --- 2. PREPARE FILTERS & SEARCH ---
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';
$cat_filter = isset($_GET['category']) ? (int)$_GET['category'] : 0;

// NEW: Identify the ID for the virtual "On Sale" category
$on_sale_query = $conn->query("SELECT id FROM categories WHERE slug = 'on-sale' LIMIT 1");
$on_sale_id = ($on_sale_query->num_rows > 0) ? $on_sale_query->fetch_assoc()['id'] : 0;

$where_clauses = ["1=1"];

if (!empty($search)) {
    $where_clauses[] = "(p.name LIKE '%$search%' OR p.sku LIKE '%$search%')";
}

if ($cat_filter > 0) {
    // Check if the user selected "On Sale"
    if ($cat_filter == $on_sale_id) {
        // Apply the logic: Show items with a valid discount
        $where_clauses[] = "(p.sale_price > 0 AND p.sale_price < p.price)";
    } else {
        // Normal category filter
        $where_clauses[] = "p.category_id = $cat_filter";
    }
}

$where_sql = implode(" AND ", $where_clauses);

// --- 3. FETCH DATA WITH OPTIMIZED PAGINATION ---
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10;
$offset = ($page - 1) * $per_page;

// Count total for pagination (considering filters)
$total_res = $conn->query("SELECT COUNT(*) as total FROM products p WHERE $where_sql");
$total_records = $total_res->fetch_assoc()['total'];
$total_pages = ceil($total_records / $per_page);

// Fetch categories for the filter dropdown
$all_cats = $conn->query("SELECT * FROM categories WHERE slug NOT IN ('new-arrivals', 'best-sellers') ORDER BY name ASC");

// Optimized Query - FIXED to show only default color images
$query = "
    SELECT 
        p.*, 
        c.name as cat_name,
        pi.image_path as primary_img,
        (SELECT SUM(stock_quantity) FROM product_sizes WHERE product_id = p.id) as total_stock
    FROM products p
    LEFT JOIN categories c ON p.category_id = c.id
    LEFT JOIN product_images pi ON p.id = pi.product_id 
        AND pi.is_primary = 1 
        AND (
            pi.color_group = p.default_color_group 
            OR p.default_color_group IS NULL 
            OR pi.color_group IS NULL
        )
    WHERE $where_sql
    ORDER BY p.id DESC
    LIMIT $per_page OFFSET $offset
";
$records = $conn->query($query);

$page_title = "Manage Products";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <div class="d-flex align-items-center justify-content-between mb-4">
        <div class="page-title-box mb-0">
            <h2 class="page-title mb-1"><i class="fas fa-tshirt"></i> Products</h2>
            <p class="text-muted mb-0">Add, edit, and manage all products for your store.</p>
        </div>
        <a href="product-add.php" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Product
        </a>
    </div>

    <!-- SEARCH & FILTER BAR -->
    <div class="card mb-4">
        <div class="card-body py-3">
            <form method="GET" action="products.php" class="row align-items-end g-3">
                <div class="col-md-5">
                    <label class="small font-weight-bold text-muted">Search Products</label>
                    <input type="text" name="search" class="form-control" placeholder="Search by name or SKU..." value="<?= htmlspecialchars($search) ?>">
                </div>
                <div class="col-md-4">
                    <label class="small font-weight-bold text-muted">Category Filter</label>
                    <select name="category" class="form-control">
                        <option value="">All Categories</option>
                        <?php while($cat = $all_cats->fetch_assoc()): ?>
                            <option value="<?= $cat['id'] ?>" <?= $cat_filter == $cat['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($cat['name']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-dark w-100">
                        <i class="fas fa-search mr-1"></i> Filter Results
                    </button>
                </div>
            </form>
        </div>
    </div>

    <?= $_SESSION['flash_message'] ?? ''; unset($_SESSION['flash_message']); ?>

    <div class="card">
        <div class="card-body card-body-no-padding">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>ID</th> <!-- Added ID Column -->
                            <th>Image</th>
                            <th>Product Name</th>
                            <th>Category</th>
                            <th>Price</th>
                            <th>Stock</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($records->num_rows > 0): while ($prod = $records->fetch_assoc()): 
                            $img_path = (!empty($prod['primary_img'])) ? $prod['primary_img'] : 'assets/img/placeholder.png';
                            $cat_name = (!empty($prod['cat_name'])) ? $prod['cat_name'] : 'N/A';
                            $total_stock = $prod['total_stock'] ?? 0;
                        ?>
                            <tr>
                                <td>#<?= $prod['id'] ?></td> <!-- Added ID Value -->
                                <td><img src="../<?= $img_path ?>" class="rounded" style="width: 50px; height: 50px; object-fit: cover;"></td>
                                <td><strong><?= htmlspecialchars($prod['name']) ?></strong><br><small class="text-muted">SKU: <?= htmlspecialchars($prod['sku']) ?></small></td>
                                <td><span class="badge bg-light text-dark"><?= htmlspecialchars($cat_name) ?></span></td>
                                <td>
                                    <?php if ($prod['sale_price']): ?>
                                        <del class="text-muted">₹<?= number_format($prod['price']) ?></del>
                                        <strong class="text-danger">₹<?= number_format($prod['sale_price']) ?></strong>
                                    <?php else: ?>
                                        <strong>₹<?= number_format($prod['price']) ?></strong>
                                    <?php endif; ?>
                                </td>
                                <td><?= $total_stock ?> In Stock</td>
                                <td><span class="badge badge-<?= $prod['is_active'] ? 'success' : 'secondary' ?>"><?= $prod['is_active'] ? 'Published' : 'Draft' ?></span></td>
                                <td>
                                    <div class="action-buttons">
                                        <a href="product-edit.php?id=<?= $prod['id'] ?>" class="btn btn-sm btn-info" title="Edit"><i class="fas fa-edit"></i></a>
                                        <a href="products.php?delete=<?= $prod['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this product permanently?');" title="Delete"><i class="fas fa-trash"></i></a>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; else: ?>
                            <tr><td colspan="8" class="text-center py-5 text-muted">No products found matching your criteria.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Pagination -->
    <?php if ($total_pages > 1): ?>
        <nav class="mt-4"><ul class="pagination justify-content-center">
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <?php 
                    // Create URL with search and filter parameters to keep context when clicking pages
                    $url_params = http_build_query([
                        'page' => $i,
                        'search' => $_GET['search'] ?? '',
                        'category' => $_GET['category'] ?? ''
                    ]);
                ?>
                <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                    <a class="page-link" href="?<?= $url_params ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
        </ul></nav>
    <?php endif; ?>
</div>

<?php include 'includes/admin_footer.php'; ?>