<?php
require_once 'includes/db_config.php';
check_login();

$page_title = "Manage Orders";
include 'includes/admin_header.php';

// --- SEARCH LOGIC ---
$search_query = "";
$where_clause = "";

if (isset($_GET['search']) && !empty($_GET['search'])) {
    $search_query = sanitize_input($_GET['search']);
    // Search in: Order ID, Razorpay ID, or User Name
    $where_clause = "WHERE o.id LIKE '%$search_query%' 
                     OR o.razorpay_payment_id LIKE '%$search_query%' 
                     OR u.full_name LIKE '%$search_query%'";
}

// --- FETCH ORDERS ---
// We Left Join users in case it was a guest checkout or user was deleted
$sql = "SELECT o.*, u.full_name as registered_name, u.email as registered_email 
        FROM orders o 
        LEFT JOIN users u ON o.user_id = u.id 
        $where_clause
        ORDER BY o.created_at DESC";
$orders = $conn->query($sql);
?>

<div class="container-fluid">

    <!-- 1. Page Title Block (Full Width) -->
    <div class="page-title-box mb-3">
        <h2 class="page-title"><i class="fas fa-shopping-cart"></i> Order Management</h2>
        <p class="text-muted mb-0">Track and manage customer orders, update statuses, and view revenue.</p>
    </div>

    <!-- 2. Search Bar Block (Moved Below, Full Width & Responsive) -->
    <div class="mb-4">
        <form method="GET" class="search-bar-container d-flex">
            <!-- Input grows to fill space -->
            <input type="text" name="search" class="form-control search-input flex-grow-1"
                placeholder="Search by Order ID, Name, or Payment ID..."
                value="<?= htmlspecialchars($search_query) ?>"
                style="margin-right: 10px;"> <!-- Margin for spacing -->

            <!-- Buttons stay fixed size -->
            <div class="search-buttons d-flex">
                <button type="submit" class="btn btn-primary search-btn">
                    <i class="fas fa-search"></i>
                </button>
                <?php if (!empty($search_query)): ?>
                    <a href="orders.php" class="btn btn-secondary clear-btn ml-2" title="Clear Search">
                        <i class="fas fa-times"></i>
                    </a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <div class="card">
        <div class="card-header card-header-custom d-flex justify-content-between align-items-center">
            <h5 class="mb-0">
                <?php if (!empty($search_query)): ?>
                    Search Results for: "<?= htmlspecialchars($search_query) ?>"
                <?php else: ?>
                    All Orders
                <?php endif; ?>
            </h5>
            <span class="badge badge-light text-dark font-weight-bold"><?= $orders->num_rows ?> Records</span>
        </div>
        <div class="card-body card-body-no-padding">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Order ID</th>
                            <th>Customer</th>
                            <th>Date</th>
                            <th>Total</th>
                            <th>Payment</th>
                            <th>Status</th>
                            <th class="text-right">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($orders->num_rows > 0): while ($o = $orders->fetch_assoc()): ?>
                                <?php
                                // Decode JSON address to get the name used at checkout (in case it differs from reg name)
                                $shipping = json_decode($o['shipping_address_details'], true);
                                $customer_name = $shipping['full_name'] ?? ($o['registered_name'] ?? 'Guest');

                                // Status Badge Logic
                                $status_class = 'secondary';
                                if ($o['order_status'] == 'Pending') $status_class = 'warning';
                                elseif ($o['order_status'] == 'Processing') $status_class = 'info';
                                elseif ($o['order_status'] == 'Shipped') $status_class = 'primary';
                                elseif ($o['order_status'] == 'Delivered') $status_class = 'success';
                                elseif ($o['order_status'] == 'Cancelled') $status_class = 'danger';
                                ?>
                                <tr>
                                    <td><strong>#<?= str_pad($o['id'], 6, '0', STR_PAD_LEFT) ?></strong></td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="font-weight-bold"><?= htmlspecialchars($customer_name) ?></span>
                                            <small class="text-muted"><?= $o['user_id'] ? 'Registered' : 'Guest' ?></small>
                                        </div>
                                    </td>
                                    <td><?= date('M d, Y', strtotime($o['created_at'])) ?><br><small class="text-muted"><?= date('h:i A', strtotime($o['created_at'])) ?></small></td>
                                    <td><strong>₹<?= number_format($o['total_amount'], 2) ?></strong></td>
                                    <td>

                                        <!-- 2. Display Payment ID (Main Focus) -->
                                        <div class="mt-1" style="font-size: 0.9rem; font-weight: 600;">
                                            <?php
                                            if (!empty($o['razorpay_payment_id'])) {
                                                echo htmlspecialchars($o['razorpay_payment_id']);
                                            } elseif ($o['payment_method'] == 'cod') {
                                                echo 'Cash on Delivery';
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </div>

                                        <!-- 3. Status Icon -->
                                        <?php if ($o['payment_status'] == 'Completed'): ?>
                                            <div class="small text-success"><i class="fas fa-check-circle"></i> Paid</div>
                                        <?php else: ?>
                                            <div class="small text-warning"><i class="fas fa-clock"></i> Pending</div>
                                        <?php endif; ?>
                                    </td>
                                    <td><span class="badge badge-<?= $status_class ?>"><?= $o['order_status'] ?></span></td>
                                    <td class="text-right">
                                        <a href="order-details.php?id=<?= $o['id'] ?>" class="btn btn-sm btn-primary">
                                            View Details <i class="fas fa-arrow-right ml-1"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile;
                        else: ?>
                            <tr>
                                <td colspan="7" class="text-center py-5 text-muted">
                                    <?php if (!empty($search_query)): ?>
                                        <i class="fas fa-search fa-2x mb-3 text-light-gray"></i><br>
                                        No orders found matching "<?= htmlspecialchars($search_query) ?>"
                                    <?php else: ?>
                                        No orders found.
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/admin_footer.php'; ?>