<?php
require_once 'includes/db_config.php';
check_login();

if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: orders.php");
    exit;
}

$order_id = (int)$_GET['id'];

// --- 1. HANDLE STATUS/TRACKING UPDATE ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_order'])) {
    $status = sanitize_input($_POST['order_status']);
    $pay_status = sanitize_input($_POST['payment_status']);
    $track_id = sanitize_input($_POST['tracking_id']);

    $stmt = $conn->prepare("UPDATE orders SET order_status=?, payment_status=?, tracking_id=? WHERE id=?");
    $stmt->bind_param("sssi", $status, $pay_status, $track_id, $order_id);

    if ($stmt->execute()) {
        $_SESSION['flash_message'] = '<div class="alert alert-success">Order updated successfully.</div>';
    } else {
        $_SESSION['flash_message'] = '<div class="alert alert-danger">Error updating order.</div>';
    }
    header("Location: order-details.php?id=$order_id");
    exit;
}

// --- 2. FETCH ORDER DATA ---
$order_sql = "SELECT * FROM orders WHERE id = $order_id";
$order_res = $conn->query($order_sql);

if ($order_res->num_rows === 0) {
    header("Location: orders.php");
    exit;
}

$order = $order_res->fetch_assoc();
$shipping = json_decode($order['shipping_address_details'], true);

// --- 3. FETCH ORDER ITEMS ---
$items_sql = "SELECT oi.*, p.name, p.slug,
              (SELECT image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.is_primary = 1 LIMIT 1) as main_image
              FROM order_items oi
              JOIN products p ON oi.product_id = p.id
              WHERE oi.order_id = $order_id";
$items_res = $conn->query($items_sql);

$page_title = "Order #" . str_pad($order_id, 6, '0', STR_PAD_LEFT);
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    
<!-- Top Header -->
    <!-- Changed: d-flex to d-block on mobile, d-md-flex on desktop -->
    <div class="d-block d-md-flex align-items-center justify-content-between mb-4">
        
        <!-- Left Side: Back Button + Title -->
        <div class="d-flex align-items-center mb-3 mb-md-0">
            <!-- Back Button (Arrow Only) -->
            <a href="orders.php" class="btn-circle-back mr-3 no-print flex-shrink-0" title="Back to Orders">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div>
                <h2 class="page-title mb-0" style="font-size: 1.5rem;">Order #<?= str_pad($order['id'], 6, '0', STR_PAD_LEFT) ?></h2>
                <p class="text-muted mb-0 small">
                    <i class="far fa-calendar-alt mr-1"></i>Placed on  <?= date('F d, Y \a\t h:i A', strtotime($order['created_at'])) ?>
                </p>
            </div>
        </div>

        <!-- Right Side: Print Button -->
        <div class="no-print pl-md-0"> <!-- Added padding-left for alignment under title on mobile -->
            <button class="btn btn-info shadow-sm" onclick="window.print()">
                <i class="fas fa-print mr-2"></i> Print Invoice
            </button>
        </div>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <?= $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?>
    <?php endif; ?>

    <div class="row">
        <!-- LEFT COLUMN: Order Details (100% on Print) -->
        <div class="col-lg-8">
            
<!-- Order Items Card -->
            <div class="card mb-4">
                <div class="card-header card-header-custom d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Items Ordered</h5>
                </div>
                <div class="card-body p-0">
                    <!-- Removed table-responsive to prevent scrollbar -->
                    <div>
                        <table class="table invoice-table mb-0">
                            <thead>
                                <tr>
                                    <th>Product Details</th>
                                    <!-- Hide these headers on mobile -->
                                    <th class="text-center d-none d-md-table-cell">Price</th>
                                    <th class="text-center d-none d-md-table-cell">Qty</th>
                                    <th class="text-right d-none d-md-table-cell">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $subtotal_calc = 0;
                                while ($item = $items_res->fetch_assoc()):
                                    $line_total = $item['price'] * $item['quantity'];
                                    $subtotal_calc += $line_total;
                                ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-start p-2">
                                                <img src="../<?= $item['main_image'] ?? 'assets/img/placeholder.png' ?>" 
                                                     class="rounded border mr-3 flex-shrink-0" 
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                                <div class="w-100">
                                                    <h6 class="mb-1 font-weight-bold text-dark"><?= htmlspecialchars($item['name']) ?></h6>
                                                    <div class="small text-muted mb-2">
                                                        <span class="mr-2">Color: <strong><?= $item['color'] ?? 'Standard' ?></strong></span>
                                                        <span>Size: <strong><?= $item['size'] ?? 'N/A' ?></strong></span>
                                                    </div>

                                                    <!-- MOBILE ONLY: Price & Qty Display -->
                                                    <div class="d-md-none d-flex justify-content-between align-items-center mt-2 pt-2 border-top">
                                                        <small class="text-muted">
                                                            ₹<?= number_format($item['price'], 2) ?> x <?= $item['quantity'] ?>
                                                        </small>
                                                        <span class="font-weight-bold text-dark">
                                                            ₹<?= number_format($line_total, 2) ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <!-- DESKTOP ONLY: Standard Columns -->
                                        <td class="text-center d-none d-md-table-cell">₹<?= number_format($item['price'], 2) ?></td>
                                        <td class="text-center font-weight-bold d-none d-md-table-cell"><?= $item['quantity'] ?></td>
                                        <td class="text-right pr-4 font-weight-bold d-none d-md-table-cell">₹<?= number_format($line_total, 2) ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                        
                        <!-- REFRACTORED FOOTER: Uses Flexbox for perfect mobile scaling -->
                        <div class="bg-light p-3">
                            <!-- Subtotal -->
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span class="text-muted font-weight-bold">Subtotal:</span>
                                <span class="font-weight-bold">₹<?= number_format($subtotal_calc, 2) ?></span>
                            </div>

                            <!-- Discount -->
                            <?php if($order['discount_amount'] > 0): ?>
                            <div class="d-flex justify-content-between align-items-center mb-2 text-danger">
                                <span class="font-weight-bold">
                                    Discount <small>(<?= htmlspecialchars($order['coupon_used'] ?? 'Coupon') ?>)</small>:
                                </span>
                                <span class="font-weight-bold">-₹<?= number_format($order['discount_amount'], 2) ?></span>
                            </div>
                            <?php endif; ?>

                            <!-- Shipping -->
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <span class="text-muted font-weight-bold">Shipping:</span>
                                <span class="font-weight-bold">Free</span>
                            </div>

                            <!-- Grand Total -->
                            <div class="d-flex justify-content-between align-items-center border-top pt-3">
                                <h5 class="m-0 font-weight-bold text-dark">Total:</h5>
                                <h5 class="m-0 font-weight-bold text-primary">₹<?= number_format($order['total_amount'], 2) ?></h5>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Logistics & Customer Card -->
            <div class="card">
                <div class="card-header card-header-custom">
                    <h5 class="mb-0">Logistics & Customer Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Customer -->
                        <div class="col-md-6 mb-3 mb-md-0">
                            <div class="label-heading"><i class="fas fa-user mr-1"></i> Customer</div>
                            <p class="mb-1 font-weight-bold"><?= htmlspecialchars($shipping['full_name'] ?? 'Guest') ?></p>
                            <p class="mb-1"><a href="mailto:<?= htmlspecialchars($shipping['email'] ?? '') ?>" class="text-dark"><?= htmlspecialchars($shipping['email'] ?? '') ?></a></p>
                            <p class="mb-0"><?= htmlspecialchars($shipping['phone'] ?? '') ?></p>
                        </div>
                        
                        <!-- Shipping -->
                        <div class="col-md-6">
                            <div class="label-heading"><i class="fas fa-map-marker-alt mr-1"></i> Shipping Address</div>
                            <p class="mb-0">
                                <?= htmlspecialchars($shipping['address_1'] ?? '') ?><br>
                                <?php if (!empty($shipping['address_2'])): ?>
                                    <?= htmlspecialchars($shipping['address_2']) ?><br>
                                <?php endif; ?>
                                <?= htmlspecialchars($shipping['city'] ?? '') ?>, <?= htmlspecialchars($shipping['state'] ?? '') ?> - <strong><?= htmlspecialchars($shipping['pincode'] ?? '') ?></strong>
                            </p>
                            <?php if (!empty($shipping['notes'])): ?>
                                <div class="mt-2 p-2 bg-light border rounded small">
                                    <i class="fas fa-sticky-note text-warning mr-1"></i> <?= htmlspecialchars($shipping['notes']) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <!-- Payment Details -->
                        <div class="col-md-12">
                            <div class="label-heading"><i class="fas fa-credit-card mr-1"></i> Payment & Tracking</div>
                            <div class="d-flex flex-wrap align-items-center">
                                <span class="mr-4 mb-2">Method: <strong><?= strtoupper($order['payment_method']) ?></strong></span>
                                <?php if (!empty($order['razorpay_payment_id'])): ?>
                                    <span class="mr-4 mb-2">Ref ID: <code class="text-primary"><?= htmlspecialchars($order['razorpay_payment_id']) ?></code></span>
                                <?php endif; ?>
                                <?php if (!empty($order['tracking_id'])): ?>
                                    <span class="mb-2">Tracking: <span class="badge badge-info p-2"><?= htmlspecialchars($order['tracking_id']) ?></span></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- RIGHT COLUMN: Actions (Hidden on Print) -->
        <div class="col-lg-4">
            <div class="card shadow-sm sticky-top" style="top: 90px; z-index: 1;">
                <div class="card-header card-header-custom bg-secondary">
                    <h5 class="mb-0">Update Order</h5>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <input type="hidden" name="order_id" value="<?= $order['id'] ?>">

                        <div class="form-group">
                            <label class="font-weight-bold text-dark small">ORDER STATUS</label>
                            <select name="order_status" class="form-control custom-select">
                                <?php 
                                $statuses = ['Pending', 'Processing', 'Shipped', 'Delivered', 'Cancelled'];
                                foreach($statuses as $st) {
                                    $sel = ($order['order_status'] == $st) ? 'selected' : '';
                                    echo "<option value='$st' $sel>$st</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold text-dark small">PAYMENT STATUS</label>
                            <select name="payment_status" class="form-control custom-select">
                                <option value="Pending" <?= $order['payment_status'] == 'Pending' ? 'selected' : '' ?>>Pending</option>
                                <option value="Completed" <?= $order['payment_status'] == 'Completed' ? 'selected' : '' ?>>Completed (Paid)</option>
                                <option value="Failed" <?= $order['payment_status'] == 'Failed' ? 'selected' : '' ?>>Failed</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold text-dark small">TRACKING ID</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fas fa-truck"></i></span>
                                </div>
                                <input type="text" name="tracking_id" class="form-control" placeholder="e.g. AW123456" value="<?= htmlspecialchars($order['tracking_id'] ?? '') ?>">
                            </div>
                            <small class="text-muted">Enter after shipping.</small>
                        </div>

                        <button type="submit" name="update_order" class="btn btn-primary btn-block font-weight-bold mt-4">
                            <i class="fas fa-save mr-1"></i> Save Changes
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/admin_footer.php'; ?>