<?php
require_once 'includes/db_config.php';
check_login();

// 1. CONFIG
$upload_dir = '../assets/uploads/offers/';
if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

// 2. HANDLE UPDATE
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_offer'])) {
    $id = (int)$_POST['id'];
    $sub_title = sanitize_input($_POST['sub_title']);
    $heading = sanitize_input($_POST['heading']);
    $paragraph = sanitize_input($_POST['paragraph']);
    $btn_text = sanitize_input($_POST['btn_text']);
    $btn_link = sanitize_input($_POST['btn_link']);
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    $image_path = $_POST['existing_image'];

    // Handle Image Upload
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'webp'])) {
            $new_name = 'offer_' . $id . '_' . time() . '.' . $ext;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $new_name)) {
                // Delete old image if it's not a default asset
                if (!empty($image_path) && strpos($image_path, 'uploads') !== false && file_exists('../' . $image_path)) {
                    unlink('../' . $image_path);
                }
                $image_path = 'assets/uploads/offers/' . $new_name;
            }
        }
    }

    $stmt = $conn->prepare("UPDATE offers SET sub_title=?, heading=?, paragraph=?, btn_text=?, btn_link=?, image_path=?, is_active=? WHERE id=?");
    $stmt->bind_param("ssssssii", $sub_title, $heading, $paragraph, $btn_text, $btn_link, $image_path, $is_active, $id);
    $stmt->execute();

    $_SESSION['flash_message'] = '<div class="alert alert-success">Offer updated successfully.</div>';
    header("Location: offers.php");
    exit;
}

$page_title = "Manage Offers";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <div class="page-title-box">
        <h2 class="page-title"><i class="fas fa-bullhorn"></i> Offer Section</h2>
        <p class="text-muted">Manage the promotional parallax banner displayed on the Homepage.</p>
    </div>

    <?php if (isset($_SESSION['flash_message'])): ?>
        <?= $_SESSION['flash_message'];
        unset($_SESSION['flash_message']); ?>
    <?php endif; ?>

    <div class="row">
        <?php
        // Logic: Only fetch the 'home' offer. The 'about' offer is hidden from admin.
        $offers = $conn->query("SELECT * FROM offers WHERE location = 'home'");
        while ($offer = $offers->fetch_assoc()):
            $loc_name = "Homepage";
        ?>
            <div class="col-lg-6 mb-4">
                <div class="card h-100">
                    <div class="card-header card-header-custom d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><?= $loc_name ?> Offer</h5>
                        <span class="badge badge-<?= $offer['is_active'] ? 'success' : 'secondary' ?>">
                            <?= $offer['is_active'] ? 'Active' : 'Hidden' ?>
                        </span>
                    </div>
                    <div class="card-body">
                        <!-- Preview -->
                        <div class="mb-4 position-relative rounded overflow-hidden"
                            style="height: 150px; background: url('../<?= $offer['image_path'] ?>') center/cover no-repeat;">
                            <div class="position-absolute w-100 h-100 d-flex flex-column justify-content-center align-items-center text-white"
                                style="background: rgba(0,0,0,0.4);">
                                <h4 class="mb-0"><?= htmlspecialchars($offer['heading']) ?></h4>
                                <small><?= htmlspecialchars($offer['sub_title']) ?></small>
                            </div>
                        </div>

                        <button class="btn btn-primary btn-block" data-toggle="modal" data-target="#editModal<?= $offer['id'] ?>">
                            <i class="fas fa-edit"></i> Edit Content
                        </button>
                    </div>
                </div>
            </div>

            <!-- Edit Modal -->
            <div class="modal fade" id="editModal<?= $offer['id'] ?>" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header card-header-custom">
                            <h5 class="modal-title">Edit <?= $loc_name ?></h5>
                            <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                        </div>
                        <form method="POST" enctype="multipart/form-data">
                            <input type="hidden" name="id" value="<?= $offer['id'] ?>">
                            <input type="hidden" name="existing_image" value="<?= $offer['image_path'] ?>">
                            <div class="modal-body">
                                <div class="form-group">
                                    <label>Background Image</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image" accept="image/*">
                                        <label class="custom-file-label">Upload new (Recommended: 1920x1080)</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group"><label>Sub Title</label><input type="text" name="sub_title" class="form-control" value="<?= htmlspecialchars($offer['sub_title']) ?>"></div>
                                        <div class="form-group"><label>Main Heading</label><input type="text" name="heading" class="form-control" value="<?= htmlspecialchars($offer['heading']) ?>"></div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group"><label>Button Text</label><input type="text" name="btn_text" class="form-control" value="<?= htmlspecialchars($offer['btn_text']) ?>"></div>
                                        <div class="form-group"><label>Button Link</label><input type="text" name="btn_link" class="form-control" value="<?= htmlspecialchars($offer['btn_link']) ?>"></div>
                                    </div>
                                </div>
                                <div class="form-group"><label>Paragraph</label><textarea name="paragraph" class="form-control" rows="2"><?= htmlspecialchars($offer['paragraph']) ?></textarea></div>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="act<?= $offer['id'] ?>" name="is_active" <?= $offer['is_active'] ? 'checked' : '' ?>>
                                    <label class="custom-control-label" for="act<?= $offer['id'] ?>">Section Visible</label>
                                </div>
                            </div>
                            <div class="modal-footer"><button type="submit" name="update_offer" class="btn btn-primary">Save Changes</button></div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    </div>
</div>

<script>
    document.querySelectorAll('.custom-file-input').forEach(input => {
        input.addEventListener('change', e => e.target.nextElementSibling.innerText = e.target.files[0].name);
    });
</script>

<?php include 'includes/admin_footer.php'; ?>