<?php
// admin/logout.php

// MODIFIED: Include db_config.php to use the correct session name from a single source.
// The session will also be started by this include if it hasn't been already.
require_once 'includes/db_config.php';

// 2. Unset all session variables
$_SESSION = array();

// 3. Destroy the session cookie (Important for deep cleanup)
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// 4. Destroy the session storage
session_destroy();

// 5. RETAINED: Prevent Browser Caching. This ensures that hitting the "Back"
// button won't show the cached, protected Admin Panel page.
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

// 6. MODIFIED: Redirect to the Admin Login Page, not the main website.
header("Location: index.php");
exit;
?>