<?php
/**
 * Database Configuration and Connection
 * Path: admin/includes/db_config.php
 */

// --- MODIFIED: Updated database credentials for the new project ---
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'miss_sogasu_db'); // Changed from 'isa_impex'

// Create connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set charset to UTF-8
$conn->set_charset("utf8mb4");

// --- MODIFIED: Added a unique session name for the Miss.Sogasu admin panel ---
session_name('MISS-SOGASU_ADMIN_SESSION'); // Changed from 'ISA-IMPEX_WEBSITE_SESSION'

// Session configuration
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// --- CORE HELPER FUNCTIONS (RETAINED) ---

// Function to sanitize input
function sanitize_input($data) {
    $data = trim($data);
    $data = stripslashes($data); // Removes any slashes added by the browser/server settings
    // NO real_escape_string here
    // NO htmlspecialchars here
    return $data;
}

// Function to check if admin is logged in
function check_login() {
    if (!isset($_SESSION['admin_id'])) {
        header("Location: index.php"); // Redirect to admin login
        exit;
    }
}

// Function to get admin info
function get_admin_info() {
    global $conn;
    if (isset($_SESSION['admin_id'])) {
        $admin_id = (int)$_SESSION['admin_id'];
        $stmt = $conn->prepare("SELECT * FROM admin_users WHERE id = ?");
        $stmt->bind_param("i", $admin_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result && $result->num_rows > 0) {
            return $result->fetch_assoc();
        }
    }
    return null;
}

// Function to hash password
function hash_password($password) {
    return password_hash($password, PASSWORD_BCRYPT);
}

// Function to verify password
function verify_password($password, $hash) {
    return password_verify($password, $hash);
}

// Function to count records
function count_records($table, $where = '') {
    global $conn;
    $where_clause = $where ? "WHERE $where" : '';
    $stmt = $conn->prepare("SELECT COUNT(*) as count FROM `$table` $where_clause");
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result) {
        $row = $result->fetch_assoc();
        return $row['count'];
    }
    return 0;
}

// Function to get recent records (prepared statement for security)
function get_recent_records($table, $limit = 5) {
    global $conn;
    $limit = (int)$limit; // Ensure limit is an integer
    $stmt = $conn->prepare("SELECT * FROM `$table` ORDER BY id DESC LIMIT ?");
    $stmt->bind_param("i", $limit);
    $stmt->execute();
    return $stmt->get_result();
}

// Function for pagination (prepared statements are harder here, ensure inputs are sanitized)
function paginate_records($table, $page = 1, $per_page = 10, $where = '') {
    global $conn;
    $offset = ($page - 1) * $per_page;
    $where_clause = $where ? "WHERE $where" : '';
    
    // Ensure table name is safe (not from user input)
    $table = '`' . str_replace('`', '', $table) . '`';

    $result = $conn->query("SELECT * FROM $table $where_clause ORDER BY id DESC LIMIT $offset, $per_page");
    
    $count_result = $conn->query("SELECT COUNT(*) as count FROM $table $where_clause");
    $count_row = $count_result->fetch_assoc();
    $total_records = $count_row['count'];
    $total_pages = ceil($total_records / $per_page);
    
    return array(
        'records' => $result,
        'current_page' => $page,
        'total_pages' => $total_pages,
        'total_records' => $total_records,
        'per_page' => $per_page
    );
}
?>