<?php
// Get the current page filename to set the 'active' class on the correct link
$current_page = basename($_SERVER['PHP_SELF']);
?>
<aside class="admin-sidebar">
    <div class="sidebar-header">
        <!-- Make sure to replace this with your actual admin logo -->
        <a href="dashboard.php">
            <img src="../assets/img/logo2.png" class="sidebar-logo" alt="Miss.Sogasu Logo">
        </a>
    </div>

    <ul class="sidebar-menu">
        <!-- Dashboard -->
        <li>
            <a href="dashboard.php" class="<?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>">
                <i class="fas fa-tachometer-alt"></i><span>Dashboard</span>
            </a>
        </li>

        <!-- E-COMMERCE MANAGEMENT -->
        <li class="menu-header">E-COMMERCE</li>
        <li>
            <a href="orders.php" class="<?php echo in_array(basename($_SERVER['PHP_SELF']), ['orders.php', 'order-details.php']) ? 'active' : ''; ?>">
                <i class="fas fa-shopping-cart"></i><span>Orders</span>
            </a>
        </li>
        <li>
            <a href="products.php" class="<?php echo in_array(basename($_SERVER['PHP_SELF']), ['products.php', 'product-add.php', 'product-edit.php']) ? 'active' : ''; ?>">
                <i class="fas fa-tshirt"></i><span>Products</span>
            </a>
        </li>
        <li>
            <a href="categories.php" class="<?php echo ($current_page == 'categories.php') ? 'active' : ''; ?>">
                <i class="fas fa-sitemap"></i><span>Categories</span>
            </a>
        </li>
        <li>
            <!-- FIX: Keep 'active' on customer-details page -->
            <a href="customers.php" class="<?php echo in_array($current_page, ['customers.php', 'customer-details.php']) ? 'active' : ''; ?>">
                <i class="fas fa-users"></i><span>Customers</span>
            </a>
        </li>
        <li>
            <a href="coupons.php" class="<?php echo ($current_page == 'coupons.php') ? 'active' : ''; ?>">
                <i class="fas fa-tags"></i><span>Coupons</span>
            </a>
        </li>

        <!-- WEBSITE CONTENT -->
        <li class="menu-header">WEBSITE CONTENT</li>
        <li>
            <a href="topbar.php" class="<?php echo ($current_page == 'topbar.php') ? 'active' : ''; ?>">
                <i class="fas fa-bullhorn"></i><span>Top Bar</span>
            </a>
        </li>
        <li>
            <a href="images_banners.php" class="<?php echo ($current_page == 'images_banners.php') ? 'active' : ''; ?>">
                <i class="fas fa-images"></i><span>Banners</span>
            </a>
        </li>
        <li>
            <a href="offers.php" class="<?php echo ($current_page == 'offers.php') ? 'active' : ''; ?>">
                <i class="fas fa-bullhorn"></i><span>Offers Area</span>
            </a>
        </li>
        <li>
            <a href="testimonials.php" class="<?php echo ($current_page == 'testimonials.php') ? 'active' : ''; ?>">
                <i class="fas fa-comment-dots"></i><span>Testimonials</span>
            </a>
        </li>
        <li>
            <a href="gallery.php" class="<?php echo ($current_page == 'gallery.php') ? 'active' : ''; ?>">
                <i class="fas fa-images"></i><span>Gallery</span>
            </a>
        </li>
        <li>
            <a href="contacts.php" class="<?php echo ($current_page == 'contacts.php') ? 'active' : ''; ?>">
                <i class="fas fa-envelope"></i><span>Contact Messages</span>
            </a>
        </li>

        <!-- SETTINGS -->
        <li class="menu-header">SETTINGS</li>

        <li>
            <a href="admins.php" class="<?php echo ($current_page == 'admins.php') ? 'active' : ''; ?>">
                <i class="fas fa-users-cog"></i><span>Admin Users</span>
            </a>
        </li>
        <li>
            <a href="settings.php" class="<?php echo ($current_page == 'settings.php') ? 'active' : ''; ?>">
                <i class="fas fa-cog"></i><span>Site Settings</span>
            </a>
        </li>
    </ul>
</aside>