<?php
// This file assumes db_config.php has been included and check_login() has been called.
$admin_info = get_admin_info();

// Fetch site title from database for the page <title> tag
$site_title_query = $conn->query("SELECT setting_value FROM site_settings WHERE setting_key = 'site_title'");
$site_title = $site_title_query->fetch_assoc()['setting_value'] ?? 'Miss.Sogasu Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) . ' | Admin' : htmlspecialchars($site_title); ?></title>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- BoxIcons (FIX: ADDED THIS LINE) -->
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Custom Admin CSS -->
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>

<div class="admin-wrapper">
    
    <?php include 'admin_sidebar.php'; ?>

    <div class="admin-main-content">
        <!-- Dark Overlay for Mobile Sidebar -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <header class="admin-header">
            <div class="admin-header-left">
                <!-- Hamburger Menu -->
                <button class="header-toggle-btn" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
                
                <h4>Welcome, <?php echo htmlspecialchars($admin_info['full_name'] ?? 'Admin'); ?></h4>
            </div>

            <div class="admin-header-right">
                
                <!-- Desktop View: Standard Buttons -->
                <div class="desktop-actions">
                    <a href="../index.php" class="header-btn btn-danger" target="_blank">
                        <i class="fas fa-eye"></i> <span>View Site</span>
                    </a>
                    <a href="logout.php" class="header-btn btn-primary ">
                        <i class="fas fa-sign-out-alt"></i> <span>Logout</span>
                    </a>
                </div>

                <!-- Mobile View: 3-Dot Dropdown -->
                <div class="mobile-actions dropdown">
                    <button class="btn btn-link text-dark p-0" type="button" id="mobileMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="font-size: 20px; text-decoration: none;">
                        <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right shadow" aria-labelledby="mobileMenuButton">
                        <a class="dropdown-item" href="../index.php" target="_blank">
                            <i class="fas fa-eye mr-2 text-primary"></i> View Site
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item text-danger" href="logout.php">
                            <i class="fas fa-sign-out-alt mr-2"></i> Logout
                        </a>
                    </div>
                </div>

            </div>
        </header>

        <main class="admin-page-content">