<?php
require_once 'includes/db_config.php';
check_login();

// --- 1. CONFIGURATION ---
$upload_base = '../assets/uploads/banners/';
if (!is_dir($upload_base)) mkdir($upload_base, 0777, true);
$max_file_size = 5 * 1024 * 1024;

function get_file_type($ext)
{
    $videos = ['mp4', 'webm'];
    $images = ['jpg', 'jpeg', 'png', 'webp'];
    if (in_array($ext, $videos)) return 'video';
    if (in_array($ext, $images)) return 'image';
    return false;
}

$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

// --- 2. HANDLE DELETE ---
if (isset($_GET['delete']) && ($id = (int)$_GET['delete'])) {
    $result = $conn->query("SELECT image_path FROM images_banners WHERE id = $id");
    if ($row = $result->fetch_assoc()) {
        if (!empty($row['image_path']) && file_exists("../" . $row['image_path'])) unlink("../" . $row['image_path']);
    }
    $conn->query("DELETE FROM images_banners WHERE id = $id");
    $_SESSION['flash_message'] = '<div class="alert alert-success">Slide deleted successfully.</div>';
    header("Location: images_banners.php");
    exit;
}

// --- 3. HANDLE POST REQUESTS ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    $heading_small = sanitize_input($_POST['heading_small']);
    $heading_large = sanitize_input($_POST['heading_large']);
    $paragraph     = sanitize_input($_POST['paragraph']);
    $text_color    = sanitize_input($_POST['text_color']); // Will be 'white' or 'black'
    $btn_text      = sanitize_input($_POST['btn_text']);
    $btn_link      = sanitize_input($_POST['btn_link']);
    $display_order = (int)$_POST['display_order'];
    $is_active     = isset($_POST['is_active']) ? 1 : 0;

    $image_path = $_POST['existing_path'] ?? '';
    $image_type = $_POST['existing_type'] ?? 'image';

    if (isset($_FILES['media_file']) && $_FILES['media_file']['error'] === 0) {
        $ext = strtolower(pathinfo($_FILES['media_file']['name'], PATHINFO_EXTENSION));
        $type = get_file_type($ext);
        if ($_FILES['media_file']['size'] > $max_file_size) {
            $_SESSION['flash_message'] = '<div class="alert alert-danger">File too large.</div>';
        } elseif (!$type) {
            $_SESSION['flash_message'] = '<div class="alert alert-danger">Invalid format.</div>';
        } else {
            $new_name = time() . '_' . uniqid() . '.' . $ext;
            if (move_uploaded_file($_FILES['media_file']['tmp_name'], $upload_base . $new_name)) {
                if (!empty($image_path) && file_exists("../" . $image_path)) unlink("../" . $image_path);
                $image_path = 'assets/uploads/banners/' . $new_name;
                $image_type = $type;
            }
        }
    }

    if (!isset($_SESSION['flash_message'])) {
        if ($action === 'add') {
            // Fields: path, type, section(val), small, large, para, color, btn_text, btn_link, order, active
            // Placeholders: 10 total
            $stmt = $conn->prepare("INSERT INTO images_banners (image_path, image_type, image_section, heading_small, heading_large, paragraph, text_color, btn_text, btn_link, display_order, is_active) VALUES (?, ?, 'hero', ?, ?, ?, ?, ?, ?, ?, ?)");

            // TYPE STRING: 8 strings ('s'), 2 integers ('i') = 'ssssssssii'
            $stmt->bind_param("ssssssssii", $image_path, $image_type, $heading_small, $heading_large, $paragraph, $text_color, $btn_text, $btn_link, $display_order, $is_active);
            $stmt->execute();
            $_SESSION['flash_message'] = '<div class="alert alert-success">New slide added!</div>';
        } elseif ($action === 'update') {
            $id = (int)$_POST['id'];
            // Same fields + WHERE id=?
            $stmt = $conn->prepare("UPDATE images_banners SET image_path=?, image_type=?, heading_small=?, heading_large=?, paragraph=?, text_color=?, btn_text=?, btn_link=?, display_order=?, is_active=? WHERE id=?");

            // TYPE STRING: 8 strings ('s'), 3 integers ('i') = 'ssssssssiii'
            $stmt->bind_param("ssssssssiii", $image_path, $image_type, $heading_small, $heading_large, $paragraph, $text_color, $btn_text, $btn_link, $display_order, $is_active, $id);
            $stmt->execute();
            $_SESSION['flash_message'] = '<div class="alert alert-success">Slide updated successfully.</div>';
        }
    }
    header("Location: images_banners.php");
    exit;
}

$slides = $conn->query("SELECT * FROM images_banners WHERE image_section = 'hero' ORDER BY display_order ASC, id DESC");
$page_title = "Hero Slider Manager";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <!-- Consolidated Header: Title on Left, Button on Right -->
    <div class="d-flex align-items-center justify-content-between mb-4 flex-wrap" style="gap: 15px;">
        <div class="page-title-box mb-0">
            <h2 class="page-title mb-1"><i class="fas fa-images"></i> Homepage Hero Slider</h2>
            <p class="text-muted mb-0">Manage the banners, text, and visibility for your homepage.</p>
        </div>
        <div class="header-actions">
            <button class="btn btn-primary" data-toggle="modal" data-target="#addSlideModal">
                <i class="fas fa-plus"></i> Add New Slide
            </button>
        </div>
    </div>

    <?= $message ?>

    <div class="slider-grid">
        <?php if ($slides->num_rows > 0): ?>
            <?php while ($row = $slides->fetch_assoc()): ?>
                <div class="card slide-card">
                    <div class="slide-preview-wrapper">
                        <span class="type-badge"><?= strtoupper($row['image_type']) ?></span>
                        <?php if ($row['image_type'] === 'video'): ?>
                            <video muted loop onmouseover="this.play()" onmouseout="this.pause()">
                                <source src="../<?= htmlspecialchars($row['image_path']) ?>" type="video/mp4">
                            </video>
                        <?php else: ?>
                            <img src="../<?= htmlspecialchars($row['image_path']) ?>" alt="Slide">
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <h6 class="text-truncate mb-2"><?= htmlspecialchars($row['heading_large']) ?></h6>
                        <div class="mb-3">
                            <span class="badge badge-<?= $row['text_color'] == 'white' ? 'light border' : 'dark' ?>">Text: <?= ucfirst($row['text_color']) ?></span>
                            <span class="badge badge-<?= $row['is_active'] ? 'success' : 'secondary' ?>"><?= $row['is_active'] ? 'Active' : 'Hidden' ?></span>
                        </div>
                        <div class="action-buttons w-100">
                            <button class="btn btn-sm btn-info flex-grow-1" data-toggle="modal" data-target="#editModal<?= $row['id'] ?>"><i class="fas fa-edit"></i> Edit</button>
                            <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger flex-grow-1" onclick="return confirm('Delete?');"><i class="fas fa-trash"></i> Delete</a>
                        </div>
                    </div>
                </div>

                <!-- EDIT MODAL -->
                <div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1">
                    <div class="modal-dialog modal-lg modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header card-header-custom">
                                <h5 class="modal-title">Edit Slide</h5><button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                            </div>
                            <form method="POST" enctype="multipart/form-data">
                                <input type="hidden" name="action" value="update"><input type="hidden" name="id" value="<?= $row['id'] ?>">
                                <input type="hidden" name="existing_path" value="<?= $row['image_path'] ?>"><input type="hidden" name="existing_type" value="<?= $row['image_type'] ?>">
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group"><label>Sub Title (Small)</label><input type="text" class="form-control" name="heading_small" value="<?= htmlspecialchars($row['heading_small']) ?>" required></div>
                                            <div class="form-group"><label>Main Title (Large)</label><input type="text" class="form-control" name="heading_large" value="<?= htmlspecialchars($row['heading_large']) ?>" required></div>
                                            <div class="form-group"><label>Description Paragraph</label><textarea class="form-control" name="paragraph" rows="2" required><?= htmlspecialchars($row['paragraph']) ?></textarea></div>
                                            <div class="form-group">
                                                <label>Text Color Theme</label>
                                                <select name="text_color" class="form-control">
                                                    <option value="white" <?= $row['text_color'] == 'white' ? 'selected' : '' ?>>White Text</option>
                                                    <option value="black" <?= $row['text_color'] == 'black' ? 'selected' : '' ?>>Black Text</option>
                                                </select>
                                            </div>
                                            <div class="custom-control custom-switch mt-4 ml-2">
                                                <input type="checkbox" class="custom-control-input" id="act<?= $row['id'] ?>" name="is_active" <?= $row['is_active'] ? 'checked' : '' ?>>
                                                <label class="custom-control-label" for="act<?= $row['id'] ?>">Slide is Active</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group"><label>Button Text</label><input type="text" class="form-control" name="btn_text" value="<?= htmlspecialchars($row['btn_text']) ?>" required></div>
                                            <div class="form-group"><label>Button Link</label><input type="text" class="form-control" name="btn_link" value="<?= htmlspecialchars($row['btn_link']) ?>" required></div>
                                            <div class="form-group"><label>Display Order</label><input type="number" class="form-control" name="display_order" value="<?= $row['display_order'] ?>"></div>
                                            <div class="form-group"><label>Replace File (Optional)</label><input type="file" class="form-control" name="media_file" accept=".mp4,.jpg,.jpeg,.png,.webp">
                                            <small class="form-text text-muted mt-2">
                                                <i class="fas fa-info-circle mr-1"></i> Recommended dimensions: <strong>1920 x 700 px</strong>. Max file size: <strong>5 MB</strong>.
                                            </small>
                                            </div>
                                            
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer"><button type="submit" class="btn btn-primary px-4">Update Slide</button></div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php endif; ?>
    </div>
</div>

<!-- ADD MODAL -->
<div class="modal fade" id="addSlideModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header card-header-custom">
                <h5 class="modal-title">New Hero Slide</h5><button type="button" class="close text-white" data-dismiss="modal">&times;</button>
            </div>
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group"><label>Sub Title (Small)</label><input type="text" class="form-control" name="heading_small" required></div>
                            <div class="form-group"><label>Main Title (Large)</label><input type="text" class="form-control" name="heading_large" required></div>
                            <div class="form-group"><label>Description Paragraph</label><textarea class="form-control" name="paragraph" rows="2" required></textarea></div>
                            <div class="form-group">
                                <label>Text Color Theme</label>
                                <select name="text_color" class="form-control">
                                    <option value="white">White Text</option>
                                    <option value="black">Black Text</option>
                                </select>
                            </div>
                            <div class="custom-control custom-switch mt-4 ml-2">
                                <input type="checkbox" class="custom-control-input" id="activeNew" name="is_active" checked>
                                <label class="custom-control-label" for="activeNew">Slide is Active</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group"><label>Button Text</label><input type="text" class="form-control" name="btn_text" placeholder="e.g. Shop Now" required></div>
                            <div class="form-group"><label>Button Link</label><input type="text" class="form-control" name="btn_link" placeholder="e.g. products.php" required></div>
                            <div class="form-group"><label>Display Order</label><input type="number" class="form-control" name="display_order" value="0"></div>
                            <div class="form-group">
                                <label>Upload Media File</label>
                                <input type="file" class="form-control" name="media_file" accept=".mp4,.jpg,.jpeg,.png,.webp" required>
                                <small class="form-text text-muted mt-2">
                                    <i class="fas fa-info-circle mr-1"></i> Recommended dimensions: <strong>1920 x 700 px</strong>. Max file size: <strong>5 MB</strong>.
                                </small>
                            </div>
                            
                        </div>
                    </div>
                </div>
                <div class="modal-footer"><button type="submit" class="btn btn-primary px-4">Create Slide</button></div>
            </form>
        </div>
    </div>
</div>

<?php include 'includes/admin_footer.php'; ?>