<?php
require_once 'includes/db_config.php';
check_login();

// --- CONFIGURATION ---
$upload_dir = '../assets/uploads/gallery/';
if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

// --- HANDLE DELETE ---
if (isset($_GET['delete']) && ($id = (int)$_GET['delete'])) {
    $res = $conn->query("SELECT image_path FROM gallery WHERE id = $id");
    if ($row = $res->fetch_assoc()) {
        if (file_exists("../" . $row['image_path'])) unlink("../" . $row['image_path']);
    }
    $conn->query("DELETE FROM gallery WHERE id = $id");
    $_SESSION['flash_message'] = '<div class="alert alert-success">Photo removed from gallery.</div>';
    header("Location: gallery.php");
    exit;
}

// --- HANDLE POST (ADD/UPDATE) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $order  = (int)$_POST['display_order'];
    $active = isset($_POST['is_active']) ? 1 : 0;
    $image_path = $_POST['existing_path'] ?? '';

    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'webp'])) {
            $new_name = 'gallery_' . time() . '_' . uniqid() . '.' . $ext;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $new_name)) {
                if (!empty($image_path) && file_exists("../" . $image_path)) unlink("../" . $image_path);
                $image_path = 'assets/uploads/gallery/' . $new_name;
            }
        }
    }

    if ($action === 'add' && !empty($image_path)) {
        $stmt = $conn->prepare("INSERT INTO gallery (image_path, display_order, is_active) VALUES (?, ?, ?)");
        $stmt->bind_param("sii", $image_path, $order, $active);
        $stmt->execute();
        $_SESSION['flash_message'] = '<div class="alert alert-success">Photo added to gallery!</div>';
    } elseif ($action === 'update') {
        $id = (int)$_POST['id'];
        $stmt = $conn->prepare("UPDATE gallery SET image_path=?, display_order=?, is_active=? WHERE id=?");
        $stmt->bind_param("siii", $image_path, $order, $active, $id);
        $stmt->execute();
        $_SESSION['flash_message'] = '<div class="alert alert-success">Gallery photo updated!</div>';
    }

    header("Location: gallery.php");
    exit;
}

$photos = $conn->query("SELECT * FROM gallery ORDER BY display_order ASC, id DESC");
$page_title = "Gallery Manager";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <div class="d-flex align-items-center justify-content-between mb-4 flex-wrap" style="gap: 15px;">
        <div class="page-title-box mb-0">
            <h2 class="page-title mb-1"><i class="fas fa-images"></i> Website Gallery</h2>
            <p class="text-muted mb-0">Manage the photos displayed in the footer gallery section.</p>
        </div>
        <button class="btn btn-primary" data-toggle="modal" data-target="#addModal">
            <i class="fas fa-plus"></i> Add Photo
        </button>
    </div>

    <?= $message ?>

    <div class="slider-grid">
        <?php if ($photos->num_rows > 0): ?>
            <?php while ($row = $photos->fetch_assoc()): ?>
                <div class="card slide-card">
                    <div class="slide-preview-wrapper">
                        <img src="../<?= htmlspecialchars($row['image_path']) ?>" alt="Gallery">
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="badge badge-<?= $row['is_active'] ? 'success' : 'secondary' ?>"><?= $row['is_active'] ? 'Active' : 'Hidden' ?></span>
                            <small class="text-muted">Order: <?= $row['display_order'] ?></small>
                        </div>
                        <div class="action-buttons w-100">
                            <button class="btn btn-sm btn-info flex-grow-1" data-toggle="modal" data-target="#editModal<?= $row['id'] ?>"><i class="fas fa-edit"></i> Edit</button>
                            <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger flex-grow-1" onclick="return confirm('Remove this photo?');"><i class="fas fa-trash"></i> Delete</a>
                        </div>
                    </div>
                </div>

                <!-- EDIT MODAL -->
                <div class="modal fade" id="editModal<?= $row['id'] ?>" tabindex="-1">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header card-header-custom"><h5 class="modal-title">Edit Photo</h5><button type="button" class="close text-white" data-dismiss="modal">&times;</button></div>
                            <form method="POST" enctype="multipart/form-data">
                                <input type="hidden" name="action" value="update"><input type="hidden" name="id" value="<?= $row['id'] ?>">
                                <input type="hidden" name="existing_path" value="<?= $row['image_path'] ?>">
                                <div class="modal-body">
                                    <div class="form-group"><label>Replace Image (Optional)</label><div class="custom-file"><input type="file" class="custom-file-input" name="image" accept="image/*"><label class="custom-file-label">Choose file...</label></div></div>
                                    <div class="form-group mt-3"><label>Display Order</label><input type="number" class="form-control" name="display_order" value="<?= $row['display_order'] ?>"></div>
                                    <div class="custom-control custom-switch mt-3"><input type="checkbox" class="custom-control-input" id="act<?= $row['id'] ?>" name="is_active" <?= $row['is_active'] ? 'checked' : '' ?>><label class="custom-control-label" for="act<?= $row['id'] ?>">Visible on Website</label></div>
                                </div>
                                <div class="modal-footer"><button type="submit" class="btn btn-primary">Update Photo</button></div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="col-12 py-5 text-center text-muted">Gallery is empty. Add some photos!</div>
        <?php endif; ?>
    </div>
</div>

<!-- ADD MODAL -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header card-header-custom"><h5 class="modal-title">Add New Gallery Photo</h5><button type="button" class="close text-white" data-dismiss="modal">&times;</button></div>
            <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add">
                <div class="modal-body">
                    <div class="form-group"><label>Select Image</label><div class="custom-file"><input type="file" class="custom-file-input" name="image" accept="image/*" required><label class="custom-file-label">Choose photo...</label></div><small class="form-text text-muted mt-2"><b>Recommended: 600x600px. Max: 2MB.</b></small></div>
                    <div class="form-group mt-3"><label>Display Order</label><input type="number" class="form-control" name="display_order" value="0"></div>
                    <div class="custom-control custom-switch mt-3"><input type="checkbox" class="custom-control-input" id="actNew" name="is_active" checked><label class="custom-control-label" for="actNew">Visible on Website</label></div>
                </div>
                <div class="modal-footer"><button type="submit" class="btn btn-primary">Upload to Gallery</button></div>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener('change', function(e) {
        if (e.target.classList.contains('custom-file-input')) {
            var fileName = e.target.files[0].name;
            e.target.nextElementSibling.innerText = fileName;
        }
    });
</script>

<?php include 'includes/admin_footer.php'; ?>