<?php
require_once 'includes/db_config.php';
check_login();

// --- PRG: Flash Messages ---
$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

// --- 1. HANDLE POST (SEARCH) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['search'])) {
        $_SESSION['customer_search'] = trim($_POST['search_query']);
    } elseif (isset($_POST['clear_search'])) {
        unset($_SESSION['customer_search']);
    }
    header("Location: customers.php");
    exit;
}

// --- 2. HANDLE GET (DELETE) ---
if (isset($_GET['delete']) && ($id = (int)$_GET['delete'])) {
    $conn->query("DELETE FROM users WHERE id = $id");
    $_SESSION['flash_message'] = '<div class="alert alert-success">Customer account deleted.</div>';
    header("Location: customers.php");
    exit;
}

// --- 3. BUILD SEARCH QUERY & FETCH DATA ---
$search_term = $_SESSION['customer_search'] ?? '';
$where_clause = '';
if (!empty($search_term)) {
    
    // NEW LOGIC: Check for # prefix
    if (strpos($search_term, '#') === 0) {
        // ID Search: Remove '#' and search only the 'id' column
        $id_to_search = (int)substr($search_term, 1);
        $where_clause = "WHERE id = $id_to_search";
    } else {
        // Standard Search: Search multiple columns
        $safe_search = "%" . $conn->real_escape_string($search_term) . "%";
        $where_clause = "WHERE full_name LIKE '$safe_search' OR email LIKE '$safe_search' OR phone LIKE '$safe_search'";
    }
}

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 15;
$pagination = paginate_records('users', $page, $per_page, ltrim($where_clause, 'WHERE '));

// Get total customers for the header, ignoring search filters
$total_customer_count = count_records('users');

$page_title = "Manage Customers";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <!-- Consolidated Header -->
    <div class="d-flex align-items-center justify-content-between mb-4 flex-wrap" style="gap: 15px;">
        <div class="page-title-box mb-0">
            <h2 class="page-title mb-1"><i class="fas fa-users"></i> Registered Customers</h2>
            <p class="text-muted mb-0">View, search, and manage user accounts.</p>
        </div>
        <!-- Total Customer Count -->
        <div class="stats-badge p-2 px-3 bg-dark text-white rounded-pill shadow-sm">
            Total Accounts: <strong><?= $total_customer_count ?></strong>
        </div>
    </div>

    <?= $message ?>

    <!-- SEARCH BAR -->
    <div class="card mb-4 shadow-sm border-0">
        <div class="card-body">

            <form method="POST">

                <div class="search-bar-container">

                    <!-- Search Input -->
                    <input type="text" name="search_query" class="form-control" placeholder="Search by Name, Email, Phone, or #ID " value="<?= htmlspecialchars($search_term) ?>">

                    <!-- Buttons -->
                    <div class="search-buttons">

                        <button type="submit"
                            name="search"
                            class="btn search-btn">
                            <i class="fas fa-search"></i> 
                        </button>

                        <?php if (!empty($search_term)): ?>
                            <button type="submit"
                                name="clear_search"
                                class="btn clear-btn">
                                <i class="fas fa-times"></i> 
                            </button>
                        <?php endif; ?>

                    </div>

                </div>

            </form>

        </div>
    </div>


    <!-- CUSTOMERS TABLE -->
    <div class="card shadow-sm border-0">
        <div class="card-body card-body-no-padding">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th><i class="fas fa-id-badge" title="Orders"></i> ID</th>
                            <th><i class="fas fa-user" title="Customer Details"></i> Customer Details</th>
                            <th><i class="fas fa-address-book" title="Contact Details"></i> Contact Details</th>
                            <th><i class="fas fa-shopping-bag" title="Orders"></i> Orders</th>
                            <!-- <th><i class="fas fa-map-marker-alt" title="Addresses"></i> Addresses</th> -->
                            <th><i class="fas fa-shopping-cart" title="Cart"></i> Cart</th>
                            <th><i class="fas fa-cog" title="Actions"></i>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($pagination['records'] && $pagination['records']->num_rows > 0): ?>
                            <?php while ($user = $pagination['records']->fetch_assoc()):
                                $user_id = $user['id'];
                                $order_count = $conn->query("SELECT COUNT(*) as c FROM orders WHERE user_id=$user_id")->fetch_assoc()['c'];
                                $addr_count = $conn->query("SELECT COUNT(*) as c FROM user_addresses WHERE user_id=$user_id")->fetch_assoc()['c'];
                                $cart_count = $conn->query("SELECT COUNT(*) as c FROM cart WHERE user_id=$user_id")->fetch_assoc()['c'];
                            ?>
                                <tr>
                                    <td><strong>#<?= $user_id ?></strong></td>
                                    <td>
                                        <strong><?= htmlspecialchars($user['full_name']) ?></strong><br>
                                        <!-- <small class="text-muted">
                                            <i class="far fa-calendar-alt mr-1"></i>Joined: 
                                            <?= date('M d, Y', strtotime($user['created_at'])) ?>
                                        </small> -->
                                    </td>
                                    <td> <!-- RE-ADDED THIS CELL -->
                                        <div><i class="far fa-envelope mr-1 text-muted"></i><?= htmlspecialchars($user['email']) ?></div>
                                        <div><i class="fas fa-phone-alt mr-1 text-muted"></i><?= htmlspecialchars($user['phone'] ?? 'N/A') ?></div>
                                    </td>
                                    <td class="text-center"><span class="badge bg-info text-white"><?= $order_count ?></span></td>
                                    <!-- <td class="text-center"><span class="badge bg-secondary text-white"><?= $addr_count ?></span></td> -->
                                    <td class="text-center"><span class="badge bg-warning"><?= $cart_count ?></span></td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="customer-details.php?id=<?= $user_id ?>" class="btn btn-sm btn-info" title="View Full Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="customers.php?delete=<?= $user_id ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this customer? This is irreversible.');" title="Delete Account">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">No customers found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Pagination -->
    <?php if ($pagination['total_pages'] > 1): ?>
        <nav class="mt-4">
            <ul class="pagination justify-content-center">
                <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                    <li class="page-item <?= $i == $page ? 'active' : '' ?>"><a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a></li>
                <?php endfor; ?>
            </ul>
        </nav>
    <?php endif; ?>
</div>

<?php include 'includes/admin_footer.php'; ?>