<?php
require_once 'includes/db_config.php';
check_login();

// --- 1. VALIDATE & FETCH CUSTOMER ID ---
if (!isset($_GET['id']) || !($customer_id = (int)$_GET['id'])) {
    header("Location: customers.php");
    exit;
}

// --- 2. FETCH ALL DATA ---
// a) Main User Details
$user_res = $conn->query("SELECT * FROM users WHERE id = $customer_id");
if ($user_res->num_rows === 0) {
    $_SESSION['flash_message'] = '<div class="alert alert-danger">Customer not found.</div>';
    header("Location: customers.php");
    exit;
}
$user = $user_res->fetch_assoc();

// b) Lifetime Stats
$stats = $conn->query("
    SELECT 
        COUNT(*) as total_orders,
        SUM(CASE WHEN payment_status = 'Completed' THEN total_amount ELSE 0 END) as total_spent
    FROM orders 
    WHERE user_id = $customer_id
")->fetch_assoc();

// c) Order History (for table)
$orders = $conn->query("SELECT * FROM orders WHERE user_id = $customer_id ORDER BY id DESC LIMIT 10");

// d) Saved Addresses
$addresses = $conn->query("SELECT * FROM user_addresses WHERE user_id = $customer_id");

// e) Current Cart
$cart_items = $conn->query("
    SELECT c.quantity, c.size, p.name, p.price, 
           (SELECT pi.image_path FROM product_images pi WHERE pi.product_id = p.id AND pi.is_primary = 1 LIMIT 1) as image_path
    FROM cart c
    JOIN products p ON c.product_id = p.id
    WHERE c.user_id = $customer_id
");

$page_title = "Portfolio: " . htmlspecialchars($user['full_name']);
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <!-- Header with Back Button -->
    <div class="d-flex align-items-center justify-content-between mb-4 flex-wrap">
<!-- Header with Back Button (Professional Style) -->
    <div class="page-header-nav">
        <a href="customers.php" title="Back to Customers"><i class="fas fa-arrow-left"></i></a>
        <h2>Customer Portfolio</h2>
    </div>
    </div>

    <!-- CUSTOMER PROFILE & STATS -->
    <div class="row">
        <div class="col-lg-4 mb-4">
            <div class="card h-100 shadow-sm border-0">
                <div class="card-body text-center">
                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center font-weight-bold mx-auto mb-3" style="width: 80px; height: 80px; font-size: 2.5rem;">
                        <?= strtoupper(substr($user['full_name'], 0, 1)) ?>
                    </div>
                    <h4 class="mb-1"><?= htmlspecialchars($user['full_name']) ?></h4>
                    <p class="text-muted">Customer since <?= date('M d, Y', strtotime($user['created_at'])) ?></p>
                </div>
                <div class="card-footer bg-light border-0 p-3">
                    <div class="d-flex justify-content-between px-2">
                        <div class="text-center">
                            <h5 class="mb-0"><?= $stats['total_orders'] ?></h5>
                            <small class="text-muted">Orders</small>
                        </div>
                        <div class="text-center">
                            <h5 class="mb-0">₹<?= number_format($stats['total_spent'], 0) ?></h5>
                            <small class="text-muted">Lifetime Value</small>
                        </div>
                        <div class="text-center">
                            <h5 class="mb-0"><?= $addresses->num_rows ?></h5>
                            <small class="text-muted">Addresses</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-8 mb-4">
            <div class="card h-100 shadow-sm border-0">
                <div class="card-header card-header-custom">
                    <h5 class="mb-0">Contact Information</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span class="text-muted">Full Name</span>
                            <strong><?= htmlspecialchars($user['full_name']) ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span class="text-muted">Email Address</span>
                            <a href="mailto:<?= htmlspecialchars($user['email']) ?>"><?= htmlspecialchars($user['email']) ?></a>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span class="text-muted">Phone Number</span>
                            <strong><?= htmlspecialchars($user['phone'] ?? 'N/A') ?></strong>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span class="text-muted">Customer ID</span>
                            <strong>#<?= $user['id'] ?></strong>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- SAVED ADDRESSES -->
    <div class="card shadow-sm border-0 mb-4">
        <div class="card-header card-header-custom">
            <h5 class="mb-0">Saved Addresses</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <?php if ($addresses->num_rows > 0): ?>
                    <?php while ($addr = $addresses->fetch_assoc()): ?>
                        <div class="col-lg-6 col-xl-4 mb-3">
                            <div class="bg-light border rounded p-3 h-100">
                                <h6 class="font-weight-bold"><?= htmlspecialchars($addr['full_name']) ?></h6>

                                <!-- Phone Line with Icon -->
                                <div class="address-line mb-1">
                                    <i class="fas fa-phone-alt mr-2 text-muted"></i>
                                    <span class="small"><?= htmlspecialchars($addr['phone']) ?></span>
                                </div>

                                <!-- Address Line with Icon -->
                                <div class="address-line">
                                    <i class="fas fa-map-marker-alt mr-2 text-muted"></i>
                                    <span class="small">
                                        <?= htmlspecialchars($addr['address_line_1']) ?><?= !empty($addr['address_line_2']) ? ', ' . htmlspecialchars($addr['address_line_2']) : '' ?><br>
                                        <?= htmlspecialchars($addr['city']) ?>, <?= htmlspecialchars($addr['state']) ?> - <?= htmlspecialchars($addr['pincode']) ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="col-12">
                        <p class="text-muted text-center py-3">No addresses saved.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- ORDER HISTORY & CART -->
    <div class="row">
        <div class="col-lg-8 mb-4">
            <div class="card shadow-sm border-0">
                <div class="card-header card-header-custom">
                    <h5 class="mb-0">Recent Order History</h5>
                </div>
                <div class="card-body card-body-no-padding">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>Date</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($orders->num_rows > 0): ?>
                                    <?php while ($order = $orders->fetch_assoc()): ?>
                                        <tr>
                                            <td><strong>#<?= str_pad($order['id'], 6, '0', STR_PAD_LEFT) ?></strong></td>
                                            <td><?= date('M d, Y', strtotime($order['created_at'])) ?></td>
                                            <td>₹<?= number_format($order['total_amount'], 2) ?></td>
                                            <td><span class="badge badge-info"><?= $order['order_status'] ?></span></td>
                                            <td><a href="order-details.php?id=<?= $order['id'] ?>" class="btn btn-sm btn-outline-dark">View</a></td>
                                        </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-4 text-muted">No orders found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm border-0">
                <div class="card-header card-header-custom">
                    <h5 class="mb-0">Current Cart</h5>
                </div>
                <div class="card-body card-body-no-padding">
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <tbody>
                                <?php if ($cart_items->num_rows > 0): ?>
                                    <?php while ($item = $cart_items->fetch_assoc()): ?>
                                        <tr>
                                            <td><img src="../<?= htmlspecialchars($item['image_path'] ?? 'assets/img/placeholder.png') ?>" class="rounded" style="width: 40px; height: 40px; object-fit: cover;"></td>
                                            <td><small><?= htmlspecialchars($item['name']) ?><br><span class="text-muted">Qty: <?= $item['quantity'] ?></span></small></td>
                                            <td class="text-right"><small>₹<?= number_format($item['price'] * $item['quantity'], 2) ?></small></td>
                                        </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td class="text-center py-4 text-muted">Cart is empty.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php include 'includes/admin_footer.php'; ?>