<?php
require_once 'includes/db_config.php';
check_login();

// --- 1. HANDLE DELETE ---
if (isset($_GET['delete']) && ($id = (int)$_GET['delete'])) {
    $conn->query("DELETE FROM coupons WHERE id = $id");
    $_SESSION['flash_message'] = '<div class="alert alert-success">Coupon removed successfully.</div>';
    header("Location: coupons.php");
    exit;
}

// --- 2. HANDLE POST (ADD/UPDATE) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    // Sanitize & Prepare Data
    $code = strtoupper(trim(preg_replace('/[^A-Za-z0-9]/', '', $_POST['code']))); 
    $cat_id = (int)$_POST['category_id']; // 0 = All, >0 = Specific
    $type = sanitize_input($_POST['discount_type']);
    $value = (float)$_POST['discount_value'];
    $min_spend = (float)$_POST['min_spend'];
    
    // Limits
    $usage_limit = (int)$_POST['usage_limit']; // Global
    $limit_per_user = (int)$_POST['limit_per_user']; // Per User
    
    $expiry = !empty($_POST['expiry_date']) ? $_POST['expiry_date'] : NULL;
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    // Validation
    $errors = [];
    if (empty($code)) $errors[] = "Coupon Code is required.";
    if ($value < 0) $errors[] = "Discount value cannot be negative.";

    if (empty($errors)) {
        if ($action === 'add') {
            // Check duplicate
            $check = $conn->query("SELECT id FROM coupons WHERE code = '$code'");
            if ($check->num_rows > 0) {
                $_SESSION['flash_message'] = '<div class="alert alert-danger">Code <strong>'.$code.'</strong> already exists.</div>';
            } else {
                $stmt = $conn->prepare("INSERT INTO coupons (code, category_id, discount_type, discount_value, min_spend, usage_limit, limit_per_user, expiry_date, is_active) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("sisddiisi", $code, $cat_id, $type, $value, $min_spend, $usage_limit, $limit_per_user, $expiry, $is_active);
                $stmt->execute();
                $_SESSION['flash_message'] = '<div class="alert alert-success">New coupon created!</div>';
            }
        } elseif ($action === 'update') {
            $id = (int)$_POST['id'];
            $stmt = $conn->prepare("UPDATE coupons SET code=?, category_id=?, discount_type=?, discount_value=?, min_spend=?, usage_limit=?, limit_per_user=?, expiry_date=?, is_active=? WHERE id=?");
            $stmt->bind_param("sisddiisii", $code, $cat_id, $type, $value, $min_spend, $usage_limit, $limit_per_user, $expiry, $is_active, $id);
            $stmt->execute();
            $_SESSION['flash_message'] = '<div class="alert alert-success">Coupon updated successfully.</div>';
        }
    } else {
        $_SESSION['flash_message'] = '<div class="alert alert-danger">' . implode('<br>', $errors) . '</div>';
    }

    header("Location: coupons.php");
    exit;
}

// --- 3. FETCH DATA ---
// Fetch Coupons with Category Name (Left Join in case category was deleted)
$sql = "SELECT c.*, cat.name as category_name 
        FROM coupons c 
        LEFT JOIN categories cat ON c.category_id = cat.id 
        ORDER BY c.created_at DESC";
$coupons = $conn->query($sql);

// Fetch Active Categories for Dropdown
$categories_res = $conn->query("SELECT id, name FROM categories 
                                WHERE is_active = 1 
                                AND slug NOT IN ('new-arrivals', 'best-sellers', 'on-sale') 
                                ORDER BY name ASC");
$active_categories = [];
while($cat = $categories_res->fetch_assoc()) {
    $active_categories[] = $cat;
}

$page_title = "Coupon Management";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex align-items-center justify-content-between mb-4 flex-wrap" style="gap: 15px;">
        <div class="page-title-box mb-0">
            <h2 class="page-title mb-1"><i class="fas fa-tags"></i> Coupon Management</h2>
            <p class="text-muted mb-0">Create codes, set category restrictions, and manage usage limits.</p>
        </div>
        <button class="btn btn-primary" data-toggle="modal" data-target="#addModal">
            <i class="fas fa-plus"></i> Create Coupon
        </button>
    </div>

    <!-- Flash Message -->
    <?php if (isset($_SESSION['flash_message'])): ?>
        <?= $_SESSION['flash_message'] ?>
        <?php unset($_SESSION['flash_message']); ?>
    <?php endif; ?>

    <!-- Data Table Card -->
    <div class="card">
        <div class="card-body card-body-no-padding">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Code / Applicability</th>
                            <th>Discount</th>
                            <th>Limits</th>
                            <th>Expiry</th>
                            <th>Status</th>
                            <th class="text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($coupons->num_rows > 0): while ($c = $coupons->fetch_assoc()): ?>
                            <?php 
                                $is_expired = ($c['expiry_date'] && strtotime($c['expiry_date']) < time());
                                $is_exhausted = ($c['usage_limit'] > 0 && $c['used_count'] >= $c['usage_limit']);
                                
                                $status_badge = '';
                                if (!$c['is_active']) $status_badge = '<span class="badge badge-secondary">Disabled</span>';
                                elseif ($is_expired) $status_badge = '<span class="badge badge-danger">Expired</span>';
                                elseif ($is_exhausted) $status_badge = '<span class="badge badge-warning">Exhausted</span>';
                                else $status_badge = '<span class="badge badge-success">Active</span>';

                                // Category Label Logic
                                $cat_label = 'All Categories';
                                if ($c['category_id'] > 0) {
                                    if (!empty($c['category_name'])) {
                                        $cat_label = 'Category: ' . htmlspecialchars($c['category_name']);
                                    } else {
                                        $cat_label = '<span class="text-danger" title="Category Deleted">Unavailable Category</span>';
                                    }
                                }
                            ?>
                            <tr>
                                <td>
                                    <strong class="text-primary text-uppercase" style="font-size: 1.1em; letter-spacing: 1px;">
                                        <?= htmlspecialchars($c['code']) ?>
                                    </strong>
                                    <div class="small text-muted mt-1">
                                        <i class="fas fa-layer-group text-secondary mr-1"></i> <?= $cat_label ?>
                                    </div>
                                </td>
                                <td>
                                    <?php if($c['discount_type'] == 'percentage'): ?>
                                        <span class="badge badge-info"><?= (float)$c['discount_value'] ?>% OFF</span>
                                    <?php else: ?>
                                        <span class="badge badge-info">₹<?= number_format($c['discount_value']) ?> OFF</span>
                                    <?php endif; ?>
                                    <?php if($c['min_spend'] > 0): ?>
                                        <div class="small text-muted mt-1">Min: ₹<?= number_format($c['min_spend']) ?></div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small class="d-block">Global: 
                                        <strong><?= $c['usage_limit'] == 0 ? '∞' : $c['used_count'].'/'.$c['usage_limit'] ?></strong>
                                    </small>
                                    <small class="d-block text-muted">Per User: 
                                        <strong><?= $c['limit_per_user'] == 0 ? '∞' : $c['limit_per_user'] ?></strong>
                                    </small>
                                </td>
                                <td>
                                    <?php if($c['expiry_date']): ?>
                                        <span class="<?= $is_expired ? 'text-danger font-weight-bold' : '' ?>">
                                            <?= date('d M Y', strtotime($c['expiry_date'])) ?>
                                        </span>
                                    <?php else: ?>
                                        <span class="text-muted">Never</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= $status_badge ?></td>
                                <td class="text-right">
                                    <div class="action-buttons justify-content-end">
                                        <button class="btn btn-sm btn-info" data-toggle="modal" data-target="#editModal<?= $c['id'] ?>"><i class="fas fa-edit"></i></button>
                                        <a href="?delete=<?= $c['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this coupon?');"><i class="fas fa-trash"></i></a>
                                    </div>
                                </td>
                            </tr>

                            <!-- EDIT MODAL (Inside Loop) -->
                            <div class="modal fade" id="editModal<?= $c['id'] ?>" tabindex="-1">
                                <div class="modal-dialog modal-lg modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-header card-header-custom">
                                            <h5 class="modal-title">Edit Coupon</h5><button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                        </div>
                                        <form method="POST">
                                            <input type="hidden" name="action" value="update">
                                            <input type="hidden" name="id" value="<?= $c['id'] ?>">
                                            
                                            <div class="modal-body">
                                                <!-- Row 1: Code & Category -->
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="font-weight-bold">Coupon Code</label>
                                                            <input type="text" name="code" class="form-control text-uppercase" value="<?= htmlspecialchars($c['code']) ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>Applicable Category</label>
                                                            <select name="category_id" class="form-control">
                                                                <option value="0" <?= $c['category_id'] == 0 ? 'selected' : '' ?>>All Categories</option>
                                                                <?php foreach($active_categories as $cat): ?>
                                                                    <option value="<?= $cat['id'] ?>" <?= $c['category_id'] == $cat['id'] ? 'selected' : '' ?>>
                                                                        <?= htmlspecialchars($cat['name']) ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                            <small class="text-muted">Orphaned coupons (deleted category) are safe.</small>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Row 2: Type, Value, Min Spend -->
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group"><label>Type</label>
                                                            <select name="discount_type" class="form-control">
                                                                <option value="percentage" <?= $c['discount_type'] == 'percentage' ? 'selected' : '' ?>>Percentage (%)</option>
                                                                <option value="fixed" <?= $c['discount_type'] == 'fixed' ? 'selected' : '' ?>>Fixed (₹)</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group"><label>Value</label>
                                                            <input type="number" step="0.01" name="discount_value" class="form-control" value="<?= $c['discount_value'] ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group"><label>Min Spend (₹)</label>
                                                            <input type="number" step="0.01" name="min_spend" class="form-control" value="<?= $c['min_spend'] ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Row 3: Limits & Expiry -->
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group"><label>Total Usage Limit</label>
                                                            <input type="number" name="usage_limit" class="form-control" value="<?= $c['usage_limit'] ?>">
                                                            <small class="text-muted">0 = Unlimited</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group"><label>Limit Per User</label>
                                                            <input type="number" name="limit_per_user" class="form-control" value="<?= $c['limit_per_user'] ?>">
                                                            <small class="text-muted">0 = Unlimited</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group"><label>Expiry Date</label>
                                                            <input type="date" name="expiry_date" class="form-control" value="<?= $c['expiry_date'] ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="custom-control custom-switch mt-2">
                                                    <input type="checkbox" class="custom-control-input" id="act<?= $c['id'] ?>" name="is_active" <?= $c['is_active'] ? 'checked' : '' ?>>
                                                    <label class="custom-control-label" for="act<?= $c['id'] ?>">Active</label>
                                                </div>
                                            </div>
                                            <div class="modal-footer"><button type="submit" class="btn btn-primary">Update Changes</button></div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- End Edit Modal -->

                        <?php endwhile; else: ?>
                            <tr><td colspan="6" class="text-center py-5 text-muted">No coupons found.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- ADD MODAL -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header card-header-custom">
                <h5 class="modal-title">Create New Coupon</h5><button type="button" class="close text-white" data-dismiss="modal">&times;</button>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="modal-body">
                    <!-- Row 1: Code & Category -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Coupon Code</label>
                                <div class="input-group">
                                    <input type="text" name="code" id="newCode" class="form-control text-uppercase" placeholder="e.g. SUMMER50" required>
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-dark" onclick="generateCode()"><i class="fas fa-random"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Applicable Category</label>
                                <select name="category_id" class="form-control">
                                    <option value="0">All Categories (Global)</option>
                                    <?php foreach($active_categories as $cat): ?>
                                        <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Row 2: Type, Value, Min Spend -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group"><label>Type</label>
                                <select name="discount_type" class="form-control">
                                    <option value="percentage">Percentage (%)</option>
                                    <option value="fixed">Fixed Amount (₹)</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group"><label>Value</label>
                                <input type="number" step="0.01" name="discount_value" class="form-control" placeholder="0.00" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group"><label>Min Spend (₹)</label>
                                <input type="number" step="0.01" name="min_spend" class="form-control" placeholder="0.00">
                            </div>
                        </div>
                    </div>

                    <!-- Row 3: Limits & Expiry -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group"><label>Total Usage Limit</label>
                                <input type="number" name="usage_limit" class="form-control" value="0">
                                <small class="text-muted">0 = Unlimited</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group"><label>Limit Per User</label>
                                <input type="number" name="limit_per_user" class="form-control" value="1">
                                <small class="text-muted">Default: 1</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group"><label>Expiry Date</label>
                                <input type="date" name="expiry_date" class="form-control">
                            </div>
                        </div>
                    </div>

                    <div class="custom-control custom-switch mt-2">
                        <input type="checkbox" class="custom-control-input" id="actNew" name="is_active" checked>
                        <label class="custom-control-label" for="actNew">Active Status</label>
                    </div>
                </div>
                <div class="modal-footer"><button type="submit" class="btn btn-primary px-4">Create Coupon</button></div>
            </form>
        </div>
    </div>
</div>

<script>
    function generateCode() {
        const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        let result = '';
        for (let i = 0; i < 8; i++) result += chars.charAt(Math.floor(Math.random() * chars.length));
        document.getElementById('newCode').value = result;
    }
</script>

<?php include 'includes/admin_footer.php'; ?>