<?php
require_once 'includes/db_config.php';
check_login();

// --- PRG: Flash Messages ---
$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

// --- 1. HANDLE DELETE ---
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM contacts WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();
    $_SESSION['flash_message'] = '<div class="alert alert-success">Message deleted successfully.</div>';
    header("Location: contacts.php");
    exit;
}

// --- 2. HANDLE UPDATE ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_contact'])) {
    $id = (int)$_POST['id'];
    $notes = sanitize_input($_POST['notes']);
    $stmt = $conn->prepare("UPDATE contacts SET notes = ?, read_status = 1 WHERE id = ?");
    $stmt->bind_param("si", $notes, $id);
    $stmt->execute();
    $stmt->close();
    $_SESSION['flash_message'] = '<div class="alert alert-success">Notes saved and message marked as read.</div>';
    header("Location: contacts.php");
    exit;
}

// --- 3. FETCH DATA ---
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10;
$pagination = paginate_records('contacts', $page, $per_page);

$page_title = "Contact Messages";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <!-- Consolidated Header -->
    <div class="d-flex align-items-center justify-content-between mb-4 flex-wrap" style="gap: 15px;">
        <div class="page-title-box mb-0">
            <h2 class="page-title mb-1"><i class="fas fa-envelope"></i> Contact Messages</h2>
            <p class="text-muted mb-0">Manage customer inquiries from your website.</p>
        </div>
        <span class="badge badge-dark p-2">Total Records: <?= $pagination['total_records'] ?></span>
    </div>

    <?= $message ?>

    <div class="card shadow-sm border-0">
        <div class="card-body card-body-no-padding">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email & Phone</th>
                            <th>Subject</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($pagination['records'] && $pagination['records']->num_rows > 0): ?>
                            <?php while ($row = $pagination['records']->fetch_assoc()): 
                                $is_new = ($row['read_status'] == 0);
                            ?>
                                <tr <?= $is_new ? 'style="background-color: rgba(218, 1, 3, 0.02); font-weight: 600;"' : '' ?>>
                                    <td><?= htmlspecialchars($row['name']) ?></td>
                                    <td>
                                        <div class="text-primary"><?= htmlspecialchars($row['email']) ?></div>
                                        <small class="text-muted"><?= htmlspecialchars($row['phone']) ?></small>
                                    </td>
                                    <td><span class="text-truncate d-inline-block" style="max-width: 200px;"><?= htmlspecialchars($row['subject']) ?></span></td>
                                    <td><?= date('M d, Y', strtotime($row['created_at'])) ?></td>
                                    <td>
                                        <span class="badge badge-<?= $is_new ? 'info' : 'secondary' ?>">
                                            <?= $is_new ? 'NEW' : 'READ' ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <button class="btn btn-sm btn-info" data-toggle="modal" data-target="#viewModal<?= $row['id'] ?>" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this message?');" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>

                                <!-- VIEW MODAL -->
                                <div class="modal fade" id="viewModal<?= $row['id'] ?>" tabindex="-1">
                                    <div class="modal-dialog modal-lg modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header card-header-custom">
                                                <h5 class="modal-title text-white">Contact Message Details</h5>
                                                <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
                                            </div>
                                            <form method="POST">
                                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                                <input type="hidden" name="update_contact" value="1">
                                                <div class="modal-body">
                                                    <div class="row mb-3">
                                                        <div class="col-md-6">
                                                            <p class="mb-1"><strong>Name:</strong> <?= htmlspecialchars($row['name']) ?></p>
                                                            <p class="mb-1"><strong>Email:</strong> <a href="mailto:<?= htmlspecialchars($row['email']) ?>"><?= htmlspecialchars($row['email']) ?></a></p>
                                                            <p class="mb-1"><strong>Phone:</strong> <?= htmlspecialchars($row['phone']) ?></p>
                                                        </div>
                                                        <div class="col-md-6 text-md-right">
                                                            <p class="mb-0 text-muted">Received: <?= date('F d, Y - h:i A', strtotime($row['created_at'])) ?></p>
                                                        </div>
                                                    </div>
                                                    <p class="mb-2"><strong>Subject:</strong> <?= htmlspecialchars($row['subject']) ?></p>
                                                    <hr>
                                                    <p class="font-weight-bold mb-2">Message:</p>
                                                    <div class="p-3 bg-light rounded mb-4" style="white-space: pre-wrap; font-style: italic; border-left: 4px solid var(--primary-red);"><?= htmlspecialchars($row['message']) ?></div>
                                                    
                                                    <div class="form-group mb-0">
                                                        <label class="font-weight-bold">Admin Internal Notes:</label>
                                                        <textarea class="form-control" name="notes" rows="3" placeholder="Add follow-up notes here..."><?= htmlspecialchars($row['notes'] ?? '') ?></textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary px-4"><i class="fas fa-check mr-1"></i> Save & Mark Read</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="6" class="text-center py-5 text-muted">No contact messages found.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Pagination -->
    <?php if ($pagination['total_pages'] > 1): ?>
        <nav class="mt-4">
            <ul class="pagination justify-content-center">
                <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                    <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
    <?php endif; ?>
</div>

<?php include 'includes/admin_footer.php'; ?>