<?php
require_once 'includes/db_config.php';
check_login();

// --- 1. CONFIGURATION ---
$upload_dir = '../assets/uploads/categories/';
if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

// --- 2. HANDLE DELETE ---
if (isset($_GET['delete']) && ($id = (int)$_GET['delete'])) {
    $img_res = $conn->query("SELECT image FROM categories WHERE id = $id");
    if ($row = $img_res->fetch_assoc()) {
        if (!empty($row['image'])) {
            $file_path = '../' . $row['image'];
            if (file_exists($file_path)) unlink($file_path);
        }
    }
    $conn->query("DELETE FROM categories WHERE id = $id");
    $_SESSION['flash_message'] = '<div class="alert alert-success">Category deleted successfully.</div>';
    header("Location: categories.php");
    exit;
}

// --- 3. HANDLE POST (ADD/UPDATE) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_category'])) {
    $id = (int)$_POST['category_id'];
    $name = sanitize_input($_POST['name']);
    $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $name)));
    $show_in_menu = isset($_POST['show_in_menu']) ? 1 : 0;
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $image_path = $_POST['existing_image'] ?? '';

    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'webp'])) {
            $new_filename = time() . '_' . $slug . '.' . $ext;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $new_filename)) {
                if ($id > 0 && !empty($image_path) && file_exists('../' . $image_path)) unlink('../' . $image_path);
                $image_path = 'assets/uploads/categories/' . $new_filename;
            }
        }
    }

    $display_order = (int)$_POST['display_order']; // Capture the new field

    if ($id > 0) { // Update
        $stmt = $conn->prepare("UPDATE categories SET name=?, slug=?, image=?, show_in_menu=?, is_active=?, display_order=? WHERE id=?");
        $stmt->bind_param("sssiiii", $name, $slug, $image_path, $show_in_menu, $is_active, $display_order, $id);
        $_SESSION['flash_message'] = '<div class="alert alert-success">Category updated successfully.</div>';
    } else { // Add
        $check = $conn->query("SELECT id FROM categories WHERE slug = '$slug'");
        if ($check->num_rows > 0) {
            $_SESSION['flash_message'] = '<div class="alert alert-danger">A category with this name already exists.</div>';
        } else {
            $stmt = $conn->prepare("INSERT INTO categories (name, slug, image, show_in_menu, is_active, display_order) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssiii", $name, $slug, $image_path, $show_in_menu, $is_active, $display_order);
            $_SESSION['flash_message'] = '<div class="alert alert-success">New category added!</div>';
        }
    }

    if (isset($stmt)) $stmt->execute();
    header("Location: categories.php");
    exit;
}

$categories = $conn->query("SELECT * FROM categories ORDER BY display_order ASC, name ASC");
$edit_data = null;
if (isset($_GET['edit']) && ($id = (int)$_GET['edit'])) {
    $res = $conn->query("SELECT * FROM categories WHERE id = $id");
    $edit_data = $res->fetch_assoc();
}

$page_title = "Product Categories";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <div class="page-title-box">
        <h2 class="page-title"><i class="fas fa-sitemap"></i> Product Categories</h2>
        <p class="text-muted">Manage categories for your products. Active categories appear on the homepage, while "Show in Menu" adds them to the main navigation.</p>
    </div>

    <?= $message ?>

    <div class="row">
        <!-- FORM COLUMN -->
        <div class="col-lg-12 mb-4">
            <div class="card h-100">
                <div class="card-header card-header-custom">
                    <h5 class="mb-0"><?= $edit_data ? 'Edit Category' : 'Add New Category' ?></h5>
                </div>
                <div class="card-body">
                    <form method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="category_id" value="<?= $edit_data['id'] ?? 0 ?>">
                        <input type="hidden" name="existing_image" value="<?= $edit_data['image'] ?? '' ?>">

                        <div class="row">

                            <!-- Category Name -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Category Name</label>
                                    <input type="text" name="name" class="form-control"
                                        value="<?= htmlspecialchars($edit_data['name'] ?? '') ?>"
                                        placeholder="e.g. Summer Dresses" required>
                                </div>
                            </div>

                            <!-- Display Order -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Display Order</label>
                                    <input type="number" name="display_order" class="form-control"
                                        value="<?= $edit_data['display_order'] ?? 0 ?>">
                                    <small class="text-muted">Lower numbers appear first (e.g., 0, 1, 2).</small>
                                </div>
                            </div>

                            <!-- Category Image -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Category Image</label>

                                    <?php if (!empty($edit_data['image'])): ?>
                                        <img src="../<?= $edit_data['image'] ?>" class="img-thumbnail mb-2" style="height: 100px;">
                                    <?php endif; ?>

                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="image" name="image" accept="image/*">
                                        <label class="custom-file-label">Choose file...</label>
                                    </div>

                                    <small class="form-text text-muted mt-2">
                                        <i class="fas fa-info-circle mr-1"></i>
                                        Recommended: <strong>750 x 500 pixels</strong>.
                                    </small>
                                </div>
                            </div>

                            <!-- Visibility -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="d-block">Visibility Options</label>

                                    <div class="custom-control custom-switch mb-2">
                                        <input type="checkbox" class="custom-control-input"
                                            id="is_active" name="is_active" value="1"
                                            <?= (!isset($edit_data) || $edit_data['is_active']) ? 'checked' : '' ?>>
                                        <label class="custom-control-label" for="is_active">
                                            Active (in Homepage)
                                        </label>
                                    </div>

                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input"
                                            id="show_in_menu" name="show_in_menu" value="1"
                                            <?= (isset($edit_data) && $edit_data['show_in_menu']) ? 'checked' : '' ?>>
                                        <label class="custom-control-label" for="show_in_menu">
                                            Active (in Shop Menu)
                                        </label>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <!-- Buttons -->
                        <button type="submit" name="save_category"
                            class="btn btn-primary btn-block mt-4">
                            <i class="fas fa-save"></i>
                            <?= $edit_data ? 'Update' : 'Save' ?>
                        </button>

                        <?php if ($edit_data): ?>
                            <a href="categories.php" class="btn btn-secondary btn-block mt-2">
                                Cancel Edit
                            </a>
                        <?php endif; ?>

                    </form>
                </div>

            </div>
        </div>

        <!-- TABLE COLUMN -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header card-header-custom">
                    <h5 class="mb-0">All Categories</h5>
                </div>
                <div class="card-body card-body-no-padding">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>Name / Slug</th>
                                    <th>Order</th>
                                    <th>Homepage</th>
                                    <th>Menu</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($categories->num_rows > 0): while ($cat = $categories->fetch_assoc()): ?>
                                        <tr>
                                            <td><img src="../<?= !empty($cat['image']) ? $cat['image'] : 'assets/img/placeholder.png' ?>" class="rounded" style="width: 60px; height: 40px; object-fit: cover;"></td>
                                            <td><strong><?= htmlspecialchars($cat['name']) ?></strong><br><small class="text-muted">/<?= htmlspecialchars($cat['slug']) ?></small></td>
                                            <td><span class="badge badge-light border"><?= $cat['display_order'] ?></span></td>
                                            <td><span class="badge badge-<?= $cat['is_active'] ? 'success' : 'secondary' ?>"><?= $cat['is_active'] ? 'Visible' : 'Hidden' ?></span></td>
                                            <td><span class="badge badge-<?= $cat['show_in_menu'] ? 'info' : 'secondary' ?>"><?= $cat['show_in_menu'] ? 'Visible' : 'Hidden' ?></span></td>
                                            <td>
                                                <div class="action-buttons"><a href="categories.php?edit=<?= $cat['id'] ?>" class="btn btn-sm btn-info" title="Edit"><i class="fas fa-edit"></i></a><a href="categories.php?delete=<?= $cat['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete category?');" title="Delete"><i class="fas fa-trash"></i></a></div>
                                            </td>
                                        </tr>
                                    <?php endwhile;
                                else: ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-4 text-muted">No categories created yet.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.querySelector('.custom-file-input').addEventListener('change', e => e.target.nextElementSibling.innerText = e.target.files[0].name);
</script>

<?php include 'includes/admin_footer.php'; ?>