<?php
require_once 'includes/db_config.php';
check_login();

// --- PRG Pattern: Use Session for Flash Messages ---
$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

// --- 1. HANDLE POST REQUEST (ADD ADMIN) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_admin'])) {
    $full_name = sanitize_input($_POST['full_name']);
    $username = sanitize_input($_POST['username']);
    $email = sanitize_input($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    // VALIDATION: Check if passwords match
    if ($password !== $confirm_password) {
        $_SESSION['flash_message'] = '<div class="alert alert-danger alert-dismissible fade show"><strong>Error!</strong> Passwords do not match.<button type="button" class="close" data-dismiss="alert"><span>&times;</span></button></div>';
    } else {
        // Check for duplicate Username or Email
        $stmt_check = $conn->prepare("SELECT id FROM admin_users WHERE username=? OR email=?");
        $stmt_check->bind_param("ss", $username, $email);
        $stmt_check->execute();
        $check_res = $stmt_check->get_result();
        
        if ($check_res->num_rows > 0) {
            $_SESSION['flash_message'] = '<div class="alert alert-danger alert-dismissible fade show"><strong>Error!</strong> Username or Email already exists.<button type="button" class="close" data-dismiss="alert"><span>&times;</span></button></div>';
        } else {
            // Hash password and Insert
            $hashed_password = password_hash($password, PASSWORD_BCRYPT);
            $stmt = $conn->prepare("INSERT INTO admin_users (full_name, username, email, password, created_at) VALUES (?, ?, ?, ?, NOW())");
            $stmt->bind_param("ssss", $full_name, $username, $email, $hashed_password);
            
            if ($stmt->execute()) {
                $_SESSION['flash_message'] = '<div class="alert alert-success alert-dismissible fade show"><strong>Success!</strong> New admin user added.<button type="button" class="close" data-dismiss="alert"><span>&times;</span></button></div>';
            } else {
                $_SESSION['flash_message'] = '<div class="alert alert-danger">Database Error: Could not create user.</div>';
            }
            $stmt->close();
        }
        $stmt_check->close();
    }
    
    header("Location: admins.php");
    exit;
}

// --- 2. HANDLE GET REQUEST (DELETE ADMIN) ---
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    
    // Prevent deleting yourself
    if ($id == $_SESSION['admin_id']) {
        $_SESSION['flash_message'] = '<div class="alert alert-warning alert-dismissible fade show"><strong>Warning!</strong> You cannot delete your own account while logged in.<button type="button" class="close" data-dismiss="alert"><span>&times;</span></button></div>';
    } else {
        $conn->query("DELETE FROM admin_users WHERE id = $id");
        $_SESSION['flash_message'] = '<div class="alert alert-success alert-dismissible fade show">Admin user deleted successfully.<button type="button" class="close" data-dismiss="alert"><span>&times;</span></button></div>';
    }
    header("Location: admins.php");
    exit;
}

// --- 3. DISPLAY PAGE ---
$page_title = "Manage Admins";
include 'includes/admin_header.php';
?>

<div class="container-fluid">
    <div class="page-title-box">
        <h2 class="page-title"><i class="fas fa-users-cog"></i> Manage Admin Users</h2>
        <p class="text-muted">Create and manage accounts with access to this admin panel.</p>
    </div>

    <?= $message ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header card-header-custom d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Existing Administrators</h5>
                    <button class="btn btn-sm btn-light text-dark font-weight-bold" data-toggle="modal" data-target="#addAdminModal">
                        <i class="fas fa-plus"></i> Add New Admin
                    </button>
                </div>
                <div class="card-body card-body-no-padding">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Full Name</th>
                                    <th>Username</th>
                                    <th>Email</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $result = $conn->query("SELECT * FROM admin_users ORDER BY created_at DESC");
                                if ($result->num_rows > 0) {
                                    while ($row = $result->fetch_assoc()) {
                                        $is_current_user = ($row['id'] == $_SESSION['admin_id']);
                                        ?>
                                        <tr>
                                            <td><?= $row['id'] ?></td>
                                            <td><strong><?= htmlspecialchars($row['full_name']) ?></strong></td>
                                            <td><?= htmlspecialchars($row['username']) ?></td>
                                            <td><?= htmlspecialchars($row['email']) ?></td>
                                            <td><?= date('M d, Y', strtotime($row['created_at'])) ?></td>
                                            <td>
                                                <?php if (!$is_current_user): ?>
                                                    <div class="action-buttons">
                                                        <a href="admins.php?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this admin? This cannot be undone.');" title="Delete User">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                                                    </div>
                                                <?php else: ?>
                                                    <span class="badge badge-secondary">Current User</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                } else {
                                    echo '<tr><td colspan="6" class="text-center py-4">No admin users found.</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Admin Modal -->
<div class="modal fade" id="addAdminModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header card-header-custom">
                <h5 class="modal-title text-white">Add New Administrator</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST">
                <input type="hidden" name="add_admin" value="1">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" class="form-control" name="full_name" placeholder="e.g. John Doe" required>
                    </div>
                    <div class="form-group">
                        <label>Username</label>
                        <input type="text" class="form-control" name="username" placeholder="e.g. johndoe" required>
                    </div>
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" class="form-control" name="email" placeholder="e.g. john@example.com" required>
                    </div>
                    
                    <!-- Password Field with Toggle -->
                    <div class="form-group">
                        <label>Password</label>
                        <div class="input-group">
                            <input type="password" class="form-control" name="password" id="new_password" required>
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary toggle-password" type="button" data-target="new_password">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Confirm Password Field with Toggle -->
                    <div class="form-group">
                        <label>Confirm Password</label>
                        <div class="input-group">
                            <input type="password" class="form-control" name="confirm_password" id="confirm_password" required>
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary toggle-password" type="button" data-target="confirm_password">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Create Account</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'includes/admin_footer.php'; ?>

<!-- Script for Password Visibility Toggle -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const toggles = document.querySelectorAll('.toggle-password');
    
    toggles.forEach(toggle => {
        toggle.addEventListener('click', function() {
            const targetId = this.getAttribute('data-target');
            const input = document.getElementById(targetId);
            const icon = this.querySelector('i');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    });
});
</script>