<?php
// add-to-cart.php
require_once 'includes/db.php';

// Ensure session is started if not already in db.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json');

$response = ['success' => false, 'message' => '', 'cart_count' => 0];

// Helper: Check if user is logged in
$is_logged_in = isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
$user_id = $is_logged_in ? (int)$_SESSION['user_id'] : 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'add';

    if ($action === 'add') {
        // --- ADD TO CART ---
        $product_id = (int)($_POST['product_id'] ?? 0);
        $color = sanitize_input($_POST['color'] ?? 'Standard');
        $size = sanitize_input($_POST['size'] ?? '');
        $quantity = (int)($_POST['quantity'] ?? 1);

        if ($product_id <= 0) {
            echo json_encode(['success' => false, 'message' => 'Invalid product']);
            exit;
        }

        if (empty($size)) {
            echo json_encode(['success' => false, 'message' => 'Please select a size']);
            exit;
        }

        // 1. Fetch product details
        $product_sql = "SELECT p.*, 
                       (SELECT image_path FROM product_images pi 
                        WHERE pi.product_id = p.id 
                        AND pi.is_primary = 1 
                        AND (pi.color_group = p.default_color_group OR pi.color_group IS NULL OR p.default_color_group IS NULL)
                        LIMIT 1) as main_image
                       FROM products p WHERE p.id = $product_id AND p.is_active = 1";
        $product_result = $conn->query($product_sql);

        if ($product_result->num_rows === 0) {
            echo json_encode(['success' => false, 'message' => 'Product not found']);
            exit;
        }

        $product = $product_result->fetch_assoc();

        // 2. Check stock for selected color and size
        $stock_sql = "SELECT stock_quantity FROM product_sizes 
                      WHERE product_id = $product_id 
                      AND color_group = '$color' 
                      AND size = '$size'";
        $stock_result = $conn->query($stock_sql);

        if ($stock_result->num_rows === 0) {
            echo json_encode(['success' => false, 'message' => 'Selected size/color combination not available']);
            exit;
        }

        $stock = $stock_result->fetch_assoc()['stock_quantity'];

        // 3. Calculate new quantity
        $cart_key = $product_id . '_' . $color . '_' . $size;
        $current_quantity = $_SESSION['cart'][$cart_key]['quantity'] ?? 0;
        $new_quantity = $current_quantity + $quantity;

        if ($new_quantity > $stock) {
            echo json_encode(['success' => false, 'message' => 'Only ' . $stock . ' items available in stock']);
            exit;
        }

        // 4. Get primary image for the SELECTED COLOR
        $color_image_sql = "SELECT image_path FROM product_images 
                   WHERE product_id = $product_id 
                   AND color_group = '$color' 
                   AND is_primary = 1 
                   LIMIT 1";
        $color_image_result = $conn->query($color_image_sql);

        $product_image = 'assets/img/placeholder.png';
        if ($color_image_result->num_rows > 0) {
            $product_image = $color_image_result->fetch_assoc()['image_path'];
        } elseif (!empty($product['main_image'])) {
            $product_image = $product['main_image'];
        }

        // 5. Update SESSION Cart
        $_SESSION['cart'][$cart_key] = [
            'product_id' => $product_id,
            'name' => $product['name'],
            'slug' => $product['slug'],
            'color' => $color,
            'size' => $size,
            'quantity' => $new_quantity,
            'price' => $product['sale_price'] > 0 ? $product['sale_price'] : $product['price'],
            'image' => $product_image
        ];

        // 6. Update DATABASE Cart (If Logged In)
        if ($is_logged_in) {
            // Check if this item already exists in DB cart
            $check_db = $conn->query("SELECT id FROM cart WHERE user_id = $user_id AND product_id = $product_id AND color = '$color' AND size = '$size'");
            
            if ($check_db->num_rows > 0) {
                // Update existing
                $conn->query("UPDATE cart SET quantity = $new_quantity WHERE user_id = $user_id AND product_id = $product_id AND color = '$color' AND size = '$size'");
            } else {
                // Insert new
                $conn->query("INSERT INTO cart (user_id, product_id, quantity, size, color) VALUES ($user_id, $product_id, $new_quantity, '$size', '$color')");
            }
        }

        $response['success'] = true;
        $response['message'] = 'Product added to cart';

    } elseif ($action === 'update') {
        // --- UPDATE QUANTITY ---
        $cart_key = $_POST['cart_key'] ?? '';
        $quantity = (int)($_POST['quantity'] ?? 1);

        if (isset($_SESSION['cart'][$cart_key])) {
            $item = $_SESSION['cart'][$cart_key];
            
            // Check stock
            $stock_sql = "SELECT stock_quantity FROM product_sizes 
                          WHERE product_id = {$item['product_id']} 
                          AND color_group = '{$item['color']}' 
                          AND size = '{$item['size']}'";
            $stock_result = $conn->query($stock_sql);

            if ($stock_result->num_rows > 0) {
                $stock = $stock_result->fetch_assoc()['stock_quantity'];

                if ($quantity <= $stock && $quantity > 0) {
                    // Update Session
                    $_SESSION['cart'][$cart_key]['quantity'] = $quantity;

                    // Update Database (If Logged In)
                    if ($is_logged_in) {
                        $p_id = $item['product_id'];
                        $p_color = $item['color'];
                        $p_size = $item['size'];
                        $conn->query("UPDATE cart SET quantity = $quantity WHERE user_id = $user_id AND product_id = $p_id AND color = '$p_color' AND size = '$p_size'");
                    }

                    $response['success'] = true;
                    $response['message'] = 'Quantity updated';
                } else {
                    $response['message'] = 'Quantity exceeds available stock';
                }
            }
        }

    } elseif ($action === 'remove') {
        // --- REMOVE ITEM ---
        $cart_key = $_POST['cart_key'] ?? '';

        if (isset($_SESSION['cart'][$cart_key])) {
            $item = $_SESSION['cart'][$cart_key];
            
            // Remove from Database (If Logged In)
            if ($is_logged_in) {
                $p_id = $item['product_id'];
                $p_color = $item['color'];
                $p_size = $item['size'];
                $conn->query("DELETE FROM cart WHERE user_id = $user_id AND product_id = $p_id AND color = '$p_color' AND size = '$p_size'");
            }

            // Remove from Session
            unset($_SESSION['cart'][$cart_key]);
            
            $response['success'] = true;
            $response['message'] = 'Item removed from cart';
        }
    }

    // Recalculate count
    $cart_count = 0;
    if (!empty($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $item) {
            $cart_count += $item['quantity'];
        }
    }
    $response['cart_count'] = $cart_count;

} elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['get_count'])) {
    // --- GET COUNT ---
    $cart_count = 0;
    
    // Optional: Sync DB to Session on load if logged in (Self-Correction/Recovery)
    if ($is_logged_in && empty($_SESSION['cart'])) {
        // Logic to load from DB to Session can go here if needed
        // For now, we just count what's in the session
    }

    if (!empty($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $item) {
            $cart_count += $item['quantity'];
        }
    }
    $response['success'] = true;
    $response['cart_count'] = $cart_count;
}

echo json_encode($response);